/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.service;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.SocketUtils;
import com.github.xingshuangs.iot.net.server.TcpServerBasic;
import com.github.xingshuangs.iot.protocol.s7.enums.EArea;
import com.github.xingshuangs.iot.protocol.s7.enums.EDataVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EErrorClass;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.enums.EReturnCode;
import com.github.xingshuangs.iot.protocol.s7.model.COTPConnection;
import com.github.xingshuangs.iot.protocol.s7.model.COTPData;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteDatum;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteParameter;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import com.github.xingshuangs.iot.protocol.s7.model.S7Data;
import com.github.xingshuangs.iot.protocol.s7.model.TPKT;
import com.github.xingshuangs.iot.protocol.s7.utils.AddressUtil;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7PLCServer
extends TcpServerBasic {
    private static final Logger log = LoggerFactory.getLogger(S7PLCServer.class);
    private final ReentrantLock locker = new ReentrantLock();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final HashMap<String, byte[]> dataMap = new HashMap();

    public S7PLCServer() {
        this(102);
    }

    public S7PLCServer(int port) {
        this.port = port;
        this.dataMap.put("DB1", new byte[65536]);
        this.dataMap.put("M", new byte[65536]);
        this.dataMap.put("I", new byte[65536]);
        this.dataMap.put("Q", new byte[65536]);
        this.dataMap.put("T", new byte[65536]);
        this.dataMap.put("C", new byte[65536]);
    }

    public Set<String> getAvailableAreas() {
        try {
            this.locker.lock();
            Set<String> set = this.dataMap.keySet();
            return set;
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDBArea(int ... dbNumbers) {
        log.debug("Add DB{} to server data area", (Object)dbNumbers);
        try {
            this.locker.lock();
            for (int x : dbNumbers) {
                String name = String.format("DB%s", x);
                this.dataMap.computeIfAbsent(name, key -> new byte[65536]);
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    protected boolean checkHandshake(Socket socket) {
        S7Data s7Data = this.readS7DataFromClient(socket);
        if (!(s7Data.getCotp() instanceof COTPConnection) || s7Data.getCotp().getPduType() != EPduType.CONNECT_REQUEST) {
            log.error("Client [{}] Handshake failed, not connection request", (Object)socket.getRemoteSocketAddress());
            return false;
        }
        S7Data connectConfirm = S7Data.createConnectConfirm(s7Data);
        this.write(socket, connectConfirm.toByteArray());
        s7Data = this.readS7DataFromClient(socket);
        if (!(s7Data.getCotp() instanceof COTPData) || s7Data.getCotp().getPduType() != EPduType.DT_DATA) {
            log.error("Client [{}] handshake failed, not parameter setting", (Object)socket.getRemoteSocketAddress());
            return false;
        }
        S7Data connectAckDtData = S7Data.createConnectAckDtData(s7Data);
        this.write(socket, connectAckDtData.toByteArray());
        log.debug("The client [{}] handshake succeeded", (Object)socket.getRemoteSocketAddress());
        return true;
    }

    @Override
    protected void doClientHandle(Socket socket) {
        S7Data response;
        S7Data req = this.readS7DataFromClient(socket);
        if (!(req.getCotp() instanceof COTPData) || req.getCotp().getPduType() != EPduType.DT_DATA || req.getHeader().getMessageType() != EMessageType.JOB) {
            response = S7Data.createErrorResponse(req, EErrorClass.ERROR_ON_SUPPLIES, 34048);
            this.write(socket, response.toByteArray());
        }
        try {
            switch (req.getParameter().getFunctionCode()) {
                case READ_VARIABLE: {
                    this.readVariableHandle(socket, req);
                    return;
                }
                case WRITE_VARIABLE: {
                    this.writeVariableHandle(socket, req);
                    return;
                }
            }
            response = S7Data.createErrorResponse(req, EErrorClass.ERROR_ON_SUPPLIES, 34048);
            this.write(socket, response.toByteArray());
        }
        catch (Exception e) {
            S7Data response2 = S7Data.createErrorResponse(req, EErrorClass.ERROR_ON_SERVICE_PROCESSING, 33796);
            this.write(socket, response2.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readVariableHandle(Socket socket, S7Data req) {
        ReadWriteParameter parameter = (ReadWriteParameter)req.getParameter();
        ArrayList<ReturnItem> returnItems = new ArrayList<ReturnItem>();
        try {
            this.rwLock.readLock().lock();
            parameter.getRequestItems().forEach(p1 -> {
                byte[] data;
                RequestItem p = (RequestItem)p1;
                String area = AddressUtil.parseArea(p);
                if (!this.dataMap.containsKey(area)) {
                    log.error("Client[{}] read [{}] data, area[{}], byte index[{}], bit index[{}], length[{}], no the address data", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount()});
                    returnItems.add(ReturnItem.createDefault(EReturnCode.OBJECT_DOES_NOT_EXIST));
                    return;
                }
                byte[] bytes = this.dataMap.get(area);
                ByteReadBuff buff = new ByteReadBuff(bytes);
                if (p.getVariableType() == EParamVariableType.BIT) {
                    byte[] byArray;
                    byte oldData = buff.getByte(p.getByteAddress());
                    if (BooleanUtil.getValue(oldData, p.getBitAddress())) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 1;
                    } else {
                        byte[] byArray3 = new byte[1];
                        byArray = byArray3;
                        byArray3[0] = 0;
                    }
                    data = byArray;
                } else {
                    int num = p.getArea() == EArea.S7_COUNTERS || p.getArea() == EArea.S7_TIMERS ? 2 : 1;
                    data = buff.getBytes(p.getByteAddress() * num, p.getByteCount());
                }
                log.debug("Client[{}] read [{}] data, area[{}], byte index[{}], bit index[{}], length[{}], address data{}", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount(), data});
                DataItem dataItem = DataItem.createAckBy(data, p.getVariableType() == EParamVariableType.BIT ? EDataVariableType.BIT : EDataVariableType.BYTE_WORD_DWORD);
                returnItems.add(dataItem);
            });
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        S7Data ack = S7Data.createReadWriteResponse(req, returnItems);
        this.write(socket, ack.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVariableHandle(Socket socket, S7Data req) {
        ReadWriteParameter parameter = (ReadWriteParameter)req.getParameter();
        ReadWriteDatum datum = (ReadWriteDatum)req.getDatum();
        List dataItems = datum.getReturnItems().stream().map(DataItem.class::cast).collect(Collectors.toList());
        ArrayList<ReturnItem> returnItems = new ArrayList<ReturnItem>();
        try {
            this.rwLock.writeLock().lock();
            for (int i = 0; i < parameter.getItemCount(); ++i) {
                RequestItem p = (RequestItem)parameter.getRequestItems().get(i);
                DataItem d = (DataItem)dataItems.get(i);
                String area = AddressUtil.parseArea(p);
                if (!this.dataMap.containsKey(area)) {
                    log.error("Client[{}] write [{}] data, area[{}], byte index[{}], bit index[{}], length[{}], no the address data", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount()});
                    returnItems.add(ReturnItem.createDefault(EReturnCode.OBJECT_DOES_NOT_EXIST));
                    continue;
                }
                byte[] bytes = this.dataMap.get(area);
                if (p.getVariableType() == EParamVariableType.BIT) {
                    byte newData = BooleanUtil.setBit(bytes[p.getByteAddress()], p.getBitAddress(), d.getData()[0] == 1);
                    System.arraycopy(new byte[]{newData}, 0, bytes, p.getByteAddress(), 1);
                } else {
                    int num = p.getArea() == EArea.S7_COUNTERS || p.getArea() == EArea.S7_TIMERS ? 2 : 1;
                    System.arraycopy(d.getData(), 0, bytes, p.getByteAddress() * num, d.getData().length);
                }
                log.debug("Client[{}] write [{}] data, area[{}], byte index[{}], bit index[{}], length[{}], address data{}", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount(), d.getData()});
                returnItems.add(ReturnItem.createDefault(EReturnCode.SUCCESS));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        S7Data ack = S7Data.createReadWriteResponse(req, returnItems);
        this.write(socket, ack.toByteArray());
    }

    private S7Data readS7DataFromClient(Socket socket) {
        byte[] data = this.readClientData(socket);
        return S7Data.fromBytes(data);
    }

    @Override
    protected byte[] readClientData(Socket socket) {
        try {
            InputStream in = socket.getInputStream();
            int firstByte = in.read();
            if (firstByte == -1) {
                SocketUtils.close(socket);
                throw new SocketRuntimeException("The client is disconnected.");
            }
            byte[] tpktData = new byte[4];
            tpktData[0] = (byte)firstByte;
            this.read(socket, tpktData, 1, 3, 1024, 0, true);
            TPKT tpkt = TPKT.fromBytes(tpktData);
            byte[] data = new byte[tpkt.getLength()];
            System.arraycopy(tpktData, 0, data, 0, tpktData.length);
            this.read(socket, data, 4, data.length - 4, 1024, 0, true);
            return data;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }
}

