/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

public class BCDUtil {
    private BCDUtil() {
    }

    public static int toInt(byte data) {
        return (data >> 4 & 0xF) * 10 + (data & 0xF);
    }

    public static int toInt(byte[] data) {
        int result = 0;
        for (byte b : data) {
            result = result * 100 + BCDUtil.toInt(b);
        }
        return result;
    }

    public static int toInt(byte[] data, int maxDigits) {
        int value = BCDUtil.toInt(data);
        int maxValue = (int)Math.pow(10.0, maxDigits);
        return value % maxValue;
    }

    public static byte toByte(int data) {
        if (data > 99 || data < 0) {
            throw new IllegalArgumentException("data > 99 || data < 0");
        }
        return (byte)(data / 10 << 4 | data % 10);
    }

    public static int numDigits(int value) {
        if (value == 0) {
            return 1;
        }
        return (int)Math.floor(Math.log10(Math.abs(value))) + 1;
    }

    public static byte[] toBytes(int value, int byteLength) {
        if (value < 0) {
            throw new IllegalArgumentException("BCD\u53ea\u652f\u6301\u975e\u8d1f\u6574\u6570");
        }
        byte[] bcd = new byte[byteLength];
        int temp = value;
        for (int i = byteLength - 1; i >= 0; --i) {
            int low = temp % 10;
            int high = (temp /= 10) % 10;
            temp /= 10;
            bcd[i] = (byte)(high << 4 | low);
        }
        return bcd;
    }

    public static byte[] toBytes(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("BCD\u53ea\u652f\u6301\u975e\u8d1f\u6574\u6570");
        }
        int number = BCDUtil.numDigits(value);
        int byteLength = number % 2 == 0 ? number / 2 : number / 2 + 1;
        return BCDUtil.toBytes(value, byteLength);
    }
}

