/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

import java.util.ArrayList;
import java.util.List;

public class BooleanUtil {
    private BooleanUtil() {
    }

    public static byte toByte(boolean data) {
        return BooleanUtil.setBit((byte)0, 0, data);
    }

    public static byte setBit(int bit, boolean res) {
        return BooleanUtil.setBit((byte)0, bit, res);
    }

    public static byte setBit(byte data, int bit, boolean res) {
        if (bit > 7 || bit < 0) {
            throw new IndexOutOfBoundsException("bit > 7 || bit < 0");
        }
        return res ? (byte)((data & 0xFF | 1 << bit) & 0xFF) : (byte)(data & 0xFF & ~(1 << bit) & 0xFF);
    }

    public static boolean getValue(byte data, int bit) {
        if (bit > 7 || bit < 0) {
            throw new IndexOutOfBoundsException("0 <= bit <= 7");
        }
        return (data & 0xFF & 1 << bit) != 0;
    }

    public static int getValueToInt(byte data, int bit) {
        if (bit > 7 || bit < 0) {
            throw new IndexOutOfBoundsException("0 <= bit <= 7");
        }
        return (data & 0xFF & 1 << bit) >> bit;
    }

    public static List<Boolean> byteArrayToList(int quantity, byte[] src) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (src.length * 8 < quantity) {
            throw new IllegalArgumentException("The sum of the bits of the operation byte array");
        }
        int count = 1;
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        for (byte data : src) {
            for (int j = 0; j < 8; ++j) {
                if (count > quantity) continue;
                res.add(BooleanUtil.getValue(data, j));
                ++count;
            }
        }
        return res;
    }

    public static byte[] listToByteArray(List<Boolean> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("list is null or empty");
        }
        int index = 0;
        byte[] values = new byte[list.size() / 8 + (list.size() % 8 == 0 ? 0 : 1)];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (index >= list.size()) continue;
                values[i] = BooleanUtil.setBit(values[i], j, list.get(index));
                ++index;
            }
        }
        return values;
    }
}

