/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

public class LongUtil {
    private LongUtil() {
    }

    public static byte[] toByteArray(long data) {
        return LongUtil.toByteArray(data, false);
    }

    public static byte[] toByteArray(long data, boolean littleEndian) {
        byte[] bytes = new byte[8];
        if (littleEndian) {
            bytes[0] = (byte)(data & 0xFFL);
            bytes[1] = (byte)(data >> 8 & 0xFFL);
            bytes[2] = (byte)(data >> 16 & 0xFFL);
            bytes[3] = (byte)(data >> 24 & 0xFFL);
            bytes[4] = (byte)(data >> 32 & 0xFFL);
            bytes[5] = (byte)(data >> 40 & 0xFFL);
            bytes[6] = (byte)(data >> 48 & 0xFFL);
            bytes[7] = (byte)(data >> 56 & 0xFFL);
        } else {
            bytes[0] = (byte)(data >> 56 & 0xFFL);
            bytes[1] = (byte)(data >> 48 & 0xFFL);
            bytes[2] = (byte)(data >> 40 & 0xFFL);
            bytes[3] = (byte)(data >> 32 & 0xFFL);
            bytes[4] = (byte)(data >> 24 & 0xFFL);
            bytes[5] = (byte)(data >> 16 & 0xFFL);
            bytes[6] = (byte)(data >> 8 & 0xFFL);
            bytes[7] = (byte)(data & 0xFFL);
        }
        return bytes;
    }

    public static long toInt64(byte[] data) {
        return LongUtil.toInt64(data, 0, false);
    }

    public static long toInt64(byte[] data, int offset) {
        return LongUtil.toInt64(data, offset, false);
    }

    public static long toInt64(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("data length < 8");
        }
        if (offset + 8 > data.length) {
            throw new IndexOutOfBoundsException("offset + 8 > data length");
        }
        int b = littleEndian ? 7 : 0;
        int d = littleEndian ? 1 : -1;
        return (long)(data[offset + b - d * 0] & 0xFF) << 56 | (long)(data[offset + b - d * 1] & 0xFF) << 48 | (long)(data[offset + b - d * 2] & 0xFF) << 40 | (long)(data[offset + b - d * 3] & 0xFF) << 32 | (long)(data[offset + b - d * 4] & 0xFF) << 24 | (long)(data[offset + b - d * 5] & 0xFF) << 16 | (long)(data[offset + b - d * 6] & 0xFF) << 8 | (long)(data[offset + b - d * 7] & 0xFF) << 0;
    }
}

