/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

public class ShortUtil {
    private ShortUtil() {
    }

    public static byte[] toByteArray(int data, boolean littleEndian) {
        byte[] bytes = new byte[2];
        if (littleEndian) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)(data >> 8 & 0xFF);
        } else {
            bytes[0] = (byte)(data >> 8 & 0xFF);
            bytes[1] = (byte)(data & 0xFF);
        }
        return bytes;
    }

    public static byte[] toByteArray(int data) {
        return ShortUtil.toByteArray(data, false);
    }

    public static byte[] toByteArray(short data) {
        return ShortUtil.toByteArray(data, false);
    }

    public static short toInt16(byte[] data) {
        return ShortUtil.toInt16(data, 0, false);
    }

    public static short toInt16(byte[] data, int offset) {
        return ShortUtil.toInt16(data, offset, false);
    }

    public static short toInt16(byte[] data, int offset, boolean littleEndian) {
        return (short)ShortUtil.toUInt16(data, offset, littleEndian);
    }

    public static int toUInt16(byte[] data) {
        return ShortUtil.toUInt16(data, 0, false);
    }

    public static int toUInt16(byte[] data, int offset) {
        return ShortUtil.toUInt16(data, offset, false);
    }

    public static int toUInt16(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 2) {
            throw new IndexOutOfBoundsException("data length < 2");
        }
        if (offset + 2 > data.length) {
            throw new IndexOutOfBoundsException("offset + 2 > data length");
        }
        int b = littleEndian ? 1 : 0;
        int d = littleEndian ? 1 : -1;
        return (data[offset + b - d * 0] & 0xFF) << 8 | (data[offset + b - d * 1] & 0xFF) << 0;
    }
}

