/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class TimesUtil {
    private TimesUtil() {
    }

    public static long getNTPTotalSecond(LocalDateTime dateTime) {
        Duration between = Duration.between(TimesUtil.getNTPOriginDateTime(), dateTime);
        return between.getSeconds();
    }

    public static LocalDate getNTPDate(long day) {
        return TimesUtil.getUTCOriginDate().plusDays(day);
    }

    public static LocalDateTime getNTPDateTime(long second) {
        return TimesUtil.getNTPOriginDateTime().plusSeconds(second);
    }

    public static LocalDate getNTPOriginDate() {
        return TimesUtil.getNTPOriginDateTime().toLocalDate();
    }

    public static LocalDateTime getNTPOriginDateTime() {
        return LocalDateTime.of(1900, 1, 1, 0, 0, 0);
    }

    public static long getUTCTotalSecond(LocalDateTime dateTime) {
        Duration between = Duration.between(TimesUtil.getUTCOriginDateTime(), dateTime);
        return between.getSeconds();
    }

    public static LocalDate getUTCDate(long day) {
        return TimesUtil.getUTCOriginDate().plusDays(day);
    }

    public static LocalDateTime getUTCDateTime(long second) {
        return TimesUtil.getUTCOriginDateTime().plusSeconds(second);
    }

    public static LocalDate getUTCOriginDate() {
        return TimesUtil.getUTCOriginDateTime().toLocalDate();
    }

    public static LocalDateTime getUTCOriginDateTime() {
        return LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    }
}

