/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.config;

import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;

@EnableJms
@Configuration
public class ActiveMQJmsConfig {
    @Value(value="${jms.queue.name:eipQueue}")
    private String queueName;
    @Value(value="${jms.topic.name:eipTopic}")
    private String topicName;
    @Resource
    JmsProperties jmsProperties;

    @Bean(value={"queue"})
    public Queue getQueue() {
        return new ActiveMQQueue(this.queueName);
    }

    @Bean(value={"topic"})
    public Topic getTopic() {
        return new ActiveMQTopic(this.topicName);
    }

    @Bean(value={"jmsListenerContainerTopic"})
    @ConditionalOnProperty(prefix="spring.activemq.pool", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JmsListenerContainerFactory<?> jmsListenerContainerTopic(JmsPoolConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory bean = new DefaultJmsListenerContainerFactory();
        bean.setPubSubDomain(Boolean.valueOf(this.jmsProperties.isPubSubDomain()));
        bean.setConnectionFactory((ConnectionFactory)connectionFactory);
        return bean;
    }

    @Bean(value={"jmsListenerContainerQueue"})
    @ConditionalOnProperty(prefix="spring.activemq.pool", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JmsListenerContainerFactory<?> jmsListenerContainerQueue(JmsPoolConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory bean = new DefaultJmsListenerContainerFactory();
        bean.setConnectionFactory((ConnectionFactory)connectionFactory);
        return bean;
    }

    @Bean(value={"jmsListenerContainerTopic"})
    @ConditionalOnProperty(prefix="spring.activemq.pool", name={"enabled"}, havingValue="false")
    public JmsListenerContainerFactory<?> jmsListenerContainerTopic2(ActiveMQConnectionFactory connectionFactory) {
        connectionFactory.setTrustAllPackages(true);
        DefaultJmsListenerContainerFactory bean = new DefaultJmsListenerContainerFactory();
        bean.setPubSubDomain(Boolean.valueOf(this.jmsProperties.isPubSubDomain()));
        bean.setConnectionFactory((ConnectionFactory)connectionFactory);
        return bean;
    }

    @Bean(value={"jmsListenerContainerQueue"})
    @ConditionalOnProperty(prefix="spring.activemq.pool", name={"enabled"}, havingValue="false")
    public JmsListenerContainerFactory<?> jmsListenerContainerQueue2(ActiveMQConnectionFactory connectionFactory) {
        connectionFactory.setTrustAllPackages(true);
        DefaultJmsListenerContainerFactory bean = new DefaultJmsListenerContainerFactory();
        bean.setConnectionFactory((ConnectionFactory)connectionFactory);
        return bean;
    }
}

