/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="jms", name={"enable", "bpmRuntime"}, havingValue="true")
public class JmsBpmTestCaseConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsBpmTestCaseConsumer.class);
    @Resource
    JmsConsumerService jmsConsumerService;

    @JmsListener(destination="bpmTestCase", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(Object model) throws Exception {
        logger.debug("[JMS]: queue message is :" + model.getClass().getName() + "---" + model);
        this.handlerAutoTest(model);
    }

    private void handlerAutoTest(Object source) {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage message = (ObjectMessage)source;
        Serializable object = null;
        try {
            object = message.getObject();
            this.jmsConsumerService.handlerAutoTest(BeanUtils.ObjectToString((Object)object));
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }
}

