/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.producer;

import com.hotent.activemq.model.JmsHolder;
import com.hotent.activemq.model.JmsMessage;
import com.hotent.base.context.BaseContext;
import com.hotent.base.jms.JmsTodoProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.util.JsonUtil;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"todo.enabled"}, havingValue="true", matchIfMissing=false)
public class DefaultJmsTodoProducer
implements JmsTodoProducer {
    private static final Log logger = LogFactory.getLog(DefaultJmsTodoProducer.class);
    @Value(value="${todo.activemq.user:}")
    private String username;
    @Value(value="${todo.activemq.password:}")
    private String password;
    @Value(value="${todo.activemq.broker-url:}")
    private String brokerURL;
    @Resource
    BaseContext baseContext;
    JmsMessagingTemplate todoJmsTemplate;

    public void sendToTodoTopic(Object object, String queueName) {
        Queue bnsQueue = this.getQueue(queueName);
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
        }
        this.sendJmsMessageImmediately(new JmsHolder(bnsQueue, object));
        logger.debug((Object)("[JMS]: Send to queue\uff1a" + queueName));
    }

    private void sendJmsMessageImmediately(JmsHolder holder) {
        try {
            if (holder.getMessage() != null) {
                if (holder.getQueue() != null) {
                    logger.debug((Object)("[JMS]: Send message to queue\uff1a" + holder.getQueue().toString()));
                    this.todoJmsTemplate.convertAndSend((Object)holder.getQueue(), holder.getMessage());
                } else if (holder.getTopic() != null) {
                    logger.debug((Object)("[JMS]: Send message to topic\uff1a" + holder.getTopic().toString()));
                    this.todoJmsTemplate.convertAndSend((Object)holder.getTopic(), holder.getMessage());
                }
                logger.debug((Object)("[JMS]: Send message content\uff1a" + JsonUtil.toJson((Object)holder.getMessage())));
            }
        }
        catch (Exception e) {
            logger.error((Object)"[JMS]: Send message error.", (Throwable)e);
        }
    }

    private Queue getQueue(String queueName) {
        ActiveMQQueue bnsQueue = new ActiveMQQueue(queueName);
        return bnsQueue;
    }

    @PostConstruct
    public void postConstruct() {
        this.todoJmsTemplate = new TodoJmsMessagingTemplate().createJmsTemplate();
    }

    class TodoJmsMessagingTemplate {
        TodoJmsMessagingTemplate() {
        }

        public ActiveMQConnectionFactory createConnectionFactory() {
            return this.createConnectionFactory(DefaultJmsTodoProducer.this.brokerURL, DefaultJmsTodoProducer.this.username, DefaultJmsTodoProducer.this.password);
        }

        public ActiveMQConnectionFactory createConnectionFactory(String brokerUrl, String username, String password) {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
            factory.setBrokerURL(brokerUrl);
            factory.setUserName(username);
            factory.setPassword(password);
            return factory;
        }

        public JmsMessagingTemplate createJmsTemplate() {
            JmsMessagingTemplate template = new JmsMessagingTemplate((ConnectionFactory)this.createConnectionFactory());
            return template;
        }
    }
}

