/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.util.BeanUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="jms", name={"enable", "portal"}, havingValue="true")
public class JmsMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsMessageConsumer.class);
    @Resource
    JmsConsumerService jmsConsumerService;

    @JmsListener(destination="${jms.queue.name:eipQueue}", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(Object model) {
        this.handlerJmsMessage(model);
    }

    private void handlerJmsMessage(Object source) {
        if (BeanUtils.isEmpty((Object)source)) {
            return;
        }
        if (source instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)source;
            try {
                Serializable object = objectMessage.getObject();
                this.jmsConsumerService.handlerJmsMessage(BeanUtils.ObjectToString((Object)object));
            }
            catch (JMSException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

