/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.util.BeanUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="jms", name={"enable", "portal"}, havingValue="true")
public class JmsFilePreviewTransConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsFilePreviewTransConsumer.class);
    @Resource
    JmsConsumerService jmsConsumerService;

    @JmsListener(destination="file_preview_trans_queue", containerFactory="jmsListenerContainerTopic")
    public void handlerPreviewTrans(Object model) {
        logger.debug("[JMS]: Topic message is :" + model.getClass().getName() + "---" + model);
        try {
            ObjectMessage message = (ObjectMessage)model;
            Serializable object = message.getObject();
            System.out.println(BeanUtils.ObjectToString((Object)object));
            this.jmsConsumerService.handlerPreviewTrans(BeanUtils.ObjectToString((Object)object));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }
}

