/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import javax.annotation.Resource;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="jms", name={"enable", "bpmRuntime"}, havingValue="true")
public class JmsPublishExtendJarConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsPublishExtendJarConsumer.class);
    @Resource
    JmsConsumerService jmsConsumerService;

    @JmsListener(destination="bpmPublishExtendJar", containerFactory="jmsListenerContainerTopic")
    public void receivePublish(Object model) {
        logger.debug("[JMS]: Topic message is :" + model.getClass().getName() + "---" + model);
        this.handlerJarPublish(model);
    }

    private void handlerJarPublish(Object source) {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof ActiveMQTextMessage)) {
            return;
        }
        ActiveMQTextMessage message = (ActiveMQTextMessage)source;
        String object = null;
        try {
            object = message.getText();
            this.jmsConsumerService.handlerPublishJar(object);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }
}

