/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.bpmn.converter.export;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.apache.commons.lang3.StringUtils;

public class HtDefinitionsRootExport
implements BpmnXMLConstants {
    protected static final Set<String> defaultNamespaces = new HashSet<String>(Arrays.asList("xsi", "xsd", "activiti", "bpmndi", "omgdc", "omgdi"));
    protected static final List<ExtensionAttribute> defaultAttributes = Arrays.asList(new ExtensionAttribute("typeLanguage"), new ExtensionAttribute("expressionLanguage"), new ExtensionAttribute("targetNamespace"));

    public static void writeRootElement(BpmnModel model, XMLStreamWriter xtw, String encoding) throws Exception {
        xtw.writeStartDocument(encoding, "1.0");
        xtw.writeStartElement("ext:definitions");
        xtw.setDefaultNamespace("http://www.omg.org/spec/BPMN/20100524/MODEL");
        xtw.writeDefaultNamespace("http://www.omg.org/spec/BPMN/20100524/MODEL");
        xtw.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xtw.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xtw.writeNamespace("activiti", "http://activiti.org/bpmn");
        xtw.writeNamespace("bpmndi", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeNamespace("omgdc", "http://www.omg.org/spec/DD/20100524/DC");
        xtw.writeNamespace("omgdi", "http://www.omg.org/spec/DD/20100524/DI");
        for (String prefix : model.getNamespaces().keySet()) {
            if (defaultNamespaces.contains(prefix) || !StringUtils.isNotEmpty((CharSequence)prefix)) continue;
            xtw.writeNamespace(prefix, (String)model.getNamespaces().get(prefix));
        }
        xtw.writeAttribute("typeLanguage", "http://www.w3.org/2001/XMLSchema");
        xtw.writeAttribute("expressionLanguage", "http://www.w3.org/1999/XPath");
        xtw.writeAttribute("targetNamespace", "http://activiti.org/bpmn20");
        xtw.writeNamespace("ext", "http://www.jee-soft.cn/bpm");
        xtw.writeNamespace("fn", "http://www.w3.org/2005/02/xpath-functions");
        xtw.writeNamespace("ht", "http://www.jee-soft.cn/BPMN20EXT");
        BpmnXMLUtil.writeCustomAttributes(model.getDefinitionsAttributes().values(), xtw, model.getNamespaces(), defaultAttributes);
    }
}

