/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.def;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.NodeInMulti;
import com.hotent.bpm.api.model.process.nodedef.ext.BaseBpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.persistence.manager.ActExecutionManager;
import com.hotent.bpm.persistence.manager.ActTaskManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.ActExecution;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.ClassLoadUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.util.StopWatch;

public class BpmDefUtil {
    private static Logger logger = LoggerFactory.getLogger(BpmDefUtil.class);
    private static final String OUTGOING_TRANSITION = "ot_";

    public static String transBpmDef(String id, String name, String xml) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader.getResourceAsStream("com/hotent/bpmx/activiti/xml/transformDef.xsl");
            if (is == null) {
                is = BpmDefUtil.class.getResourceAsStream("com/hotent/bpmx/activiti/xml/transformDef.xsl");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", id);
            map.put("name", name);
            String result = Dom4jUtil.transXmlByXslt((String)xml, (InputStream)is, map);
            result = result.replace("&lt;", "<").replace("&gt;", ">").replace("xmlns=\"\"", "").replace("&amp;", "&");
            return result;
        }
        catch (Exception ex) {
            throw new TransactionSystemException("\u8f6c\u6362\u6d41\u7a0b\u5b9a\u4e49\u51fa\u9519", (Throwable)ex);
        }
    }

    public static String transFlashBpmDef(String id, String name, String xml) throws Exception {
        return ClassLoadUtil.transform((String)id, (String)name, (String)xml);
    }

    public static Map<String, Object> prepare(String actDefId, String nodeId, String[] aryDestination) {
        StopWatch stopWatch = new StopWatch("BpmDefUtil.prepare\u8017\u65f6\u7edf\u8ba1");
        stopWatch.start("BpmDefUtil.prepare start");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            RepositoryService repositoryService = (RepositoryService)AppUtil.getBean(RepositoryService.class);
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(actDefId);
            ActivityImpl curAct = processDefinition.findActivity(nodeId);
            List outTrans = curAct.getOutgoingTransitions();
            ActivityImpl cloneCurAct = null;
            cloneCurAct = (ActivityImpl)FileUtil.cloneObject((Object)curAct);
            List cloneOutTrans = (List)FileUtil.cloneObject((Object)outTrans);
            map.put("outTrans", cloneOutTrans);
            if (aryDestination != null && aryDestination.length > 0) {
                boolean isSignCurrNode;
                BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
                BpmDefinitionService bpmDefinitionService = (BpmDefinitionService)AppUtil.getBean(BpmDefinitionService.class);
                String defId = bpmDefinitionService.getDefIdByBpmnDefId(actDefId);
                List nodeDefs = bpmDefinitionAccessor.getNodeDefs(defId);
                BpmNodeDef curNodeDef = nodeDefs.stream().filter(n -> n.getNodeId().equals(nodeId)).findFirst().orElse((BpmNodeDef)new BaseBpmNodeDef());
                List nodeInMultis = BpmUtil.getNodeInMulti((List)nodeDefs);
                NodeInMulti currentNodeInMulti = null;
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                ArrayList<String> actionNames = new ArrayList<String>();
                actionNames.add("reject");
                actionNames.add("backToStart");
                actionNames.add("recover");
                actionNames.add("recoverToStart");
                boolean autoFinishTaskFlag = false;
                boolean bl = isSignCurrNode = BeanUtils.isNotEmpty((Object)curNodeDef.getType()) && NodeType.SIGNTASK.getKey().equals(curNodeDef.getType().getKey());
                if (BeanUtils.isNotEmpty((Object)cmd) && BeanUtils.isNotEmpty((Object)cmd.getTransitVars("bpmTask_")) && actionNames.contains(cmd.getActionName())) {
                    if ("normal".equals(cmd.getTransitVars("backHandMode"))) {
                        currentNodeInMulti = BpmDefUtil.findCurrentNodeInMulti(nodeInMultis, nodeId);
                        autoFinishTaskFlag = true;
                    } else if ("direct".equals(cmd.getTransitVars("backHandMode")) && isSignCurrNode) {
                        BpmDefUtil.autoFinishSignTask(cmd, processDefinition, nodeInMultis);
                        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
                    }
                }
                curAct.getOutgoingTransitions().clear();
                for (String dest : aryDestination) {
                    ActivityImpl destAct = processDefinition.findActivity(dest);
                    if (BeanUtils.isNotEmpty((Object)currentNodeInMulti)) {
                        destAct = BpmDefUtil.changeFlowProcessDiagram(processDefinition, currentNodeInMulti, dest, nodeInMultis);
                    }
                    if (autoFinishTaskFlag) {
                        if ("recover".equals(cmd.getActionName()) && StringUtil.isNotEmpty((String)cmd.getInstId())) {
                            BpmSignDataManager bpmSignDataManager = (BpmSignDataManager)AppUtil.getBean(BpmSignDataManager.class);
                            bpmSignDataManager.deleteByNodeId(dest, cmd.getInstId());
                        }
                        if (!isSignCurrNode) {
                            BpmDefUtil.autoFinishTask(cmd, dest, processDefinition, nodeInMultis);
                        }
                    }
                    List incomingTransitions = destAct.getIncomingTransitions();
                    TransitionImpl transitionImpl = curAct.createOutgoingTransition(OUTGOING_TRANSITION + UniqueIdUtil.getSuid());
                    transitionImpl.setDestination(destAct);
                    BpmDefUtil.removeOldIncomingTransition(destAct.getIncomingTransitions());
                }
            }
            map.put("activity", curAct);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BaseException("\u9a73\u56de\u62a5\u9519" + ex.getMessage(), (Throwable)ex);
        }
        stopWatch.stop();
        logger.info(stopWatch.getLastTaskName() + "': running time = " + stopWatch.getTotalTimeMillis() + "\u6beb\u79d2");
        return map;
    }

    private static ActivityImpl changeFlowProcessDiagram(ProcessDefinitionEntity processDefinition, NodeInMulti currentNodeInMulti, String dest, List<NodeInMulti> nodeInMultis) {
        ActivityImpl destAct = processDefinition.findActivity(dest);
        if (currentNodeInMulti.getAllNodeIdInCurrentMulti().contains(dest)) {
            return destAct;
        }
        String destActId = currentNodeInMulti.getEndNodeId();
        TransitionImpl outgoingTransition = null;
        while (BeanUtils.isNotEmpty((Object)currentNodeInMulti)) {
            if (!currentNodeInMulti.getAllNodeIdInMulti().contains(dest)) {
                ActivityImpl nextAct = processDefinition.findActivity(currentNodeInMulti.getEndNodeId());
                if (outgoingTransition != null) {
                    outgoingTransition.setDestination(nextAct);
                }
                nextAct.getOutgoingTransitions().clear();
                if (NodeType.SUBPROCESS.equals((Object)currentNodeInMulti.getBpmNodeDef().getType())) {
                    ActivityImpl subProcessActImpl = processDefinition.findActivity(currentNodeInMulti.getBpmNodeDef().getNodeId());
                    subProcessActImpl.getOutgoingTransitions().clear();
                    outgoingTransition = subProcessActImpl.createOutgoingTransition(OUTGOING_TRANSITION + UniqueIdUtil.getSuid());
                } else {
                    outgoingTransition = nextAct.createOutgoingTransition(OUTGOING_TRANSITION + UniqueIdUtil.getSuid());
                }
                currentNodeInMulti = currentNodeInMulti.getParentNodeInMulti();
                continue;
            }
            currentNodeInMulti = null;
        }
        outgoingTransition.setDestination(destAct);
        ActivityImpl gatewayActivity = processDefinition.findActivity(destActId);
        return gatewayActivity;
    }

    private static NodeInMulti findCurrentNodeInMulti(List<NodeInMulti> nodeInMultis, String nodeId) {
        NodeInMulti currentNodeInMulti = null;
        for (int i = 0; i < nodeInMultis.size(); ++i) {
            NodeInMulti nodeInMulti = nodeInMultis.get(i);
            if (nodeInMulti == null || !nodeInMulti.getAllNodeIdInMulti().contains(nodeId)) continue;
            currentNodeInMulti = nodeInMulti;
            if (!nodeInMulti.getChildrenAllNodeIdInMulti().contains(nodeId)) continue;
            return BpmDefUtil.findCurrentNodeInMulti(nodeInMulti.getChildrens(), nodeId);
        }
        return currentNodeInMulti;
    }

    public static void restore(Map<String, Object> map) {
        ActivityImpl curAct = (ActivityImpl)map.get("activity");
        List outTrans = (List)map.get("outTrans");
        curAct.getOutgoingTransitions().clear();
        curAct.getOutgoingTransitions().addAll(outTrans);
    }

    private static void autoFinishSignTask(ActionCmd cmd, ProcessDefinitionEntity processDefinition, List<NodeInMulti> nodeInMultis) {
        try {
            BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
            String execId = bpmTask.getExecId();
            String currentNodeId = bpmTask.getNodeId();
            Map variables = cmd.getVariables();
            if (variables.containsKey("bpm_task_id_execution_id_" + bpmTask.getId())) {
                execId = (String)variables.get("bpm_task_id_execution_id_" + bpmTask.getId());
            }
            ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
            ActTaskManager actTaskManager = (ActTaskManager)AppUtil.getBean(ActTaskManager.class);
            String procInstId = bpmTask.getBpmnInstId();
            List actExecutions = actExecutionManager.getRejectByProcInstId(procInstId);
            Map<String, List<ActExecution>> actExecutionsMap = actExecutions.stream().collect(Collectors.groupingBy(ActExecution::getId));
            List<String> activeExecutionIds = BpmDefUtil.findCurrentExecutionActiveIds(actExecutionsMap, execId);
            List deleteExecutionIds = actExecutionManager.getExecutionIdsByProcInstIdAndNodeIds(bpmTask.getBpmnInstId(), Arrays.asList(currentNodeId), activeExecutionIds);
            TaskService taskSerivce = (TaskService)AppUtil.getBean(TaskService.class);
            List taskEntityList = actTaskManager.getTaskIdsByExecutionIds(deleteExecutionIds);
            Map finalFormBoData = (Map)cmd.getTransitVars("bo_inst_");
            String currentTaskActionName = cmd.getActionName();
            taskEntityList.forEach(taskEntity -> {
                String taskId = taskEntity.getId();
                BpmUtil.buildRejectCmd((String)taskId, (String)"agree", (String)currentTaskActionName, (Map)finalFormBoData, (Boolean)false);
                taskSerivce.complete(taskId);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u5904\u7406\u5176\u4ed6\u4f1a\u7b7e\u4efb\u52a1\u62a5\u9519", (Throwable)e);
        }
    }

    private static void autoFinishTask(ActionCmd cmd, String dest, ProcessDefinitionEntity processDefinition, List<NodeInMulti> nodeInMultis) {
        try {
            BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
            String execId = bpmTask.getExecId();
            String currentNodeId = bpmTask.getNodeId();
            Map variables = cmd.getVariables();
            if (variables.containsKey("bpm_task_id_execution_id_" + bpmTask.getId())) {
                execId = (String)variables.get("bpm_task_id_execution_id_" + bpmTask.getId());
            }
            ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
            ActTaskManager actTaskManager = (ActTaskManager)AppUtil.getBean(ActTaskManager.class);
            List<Object> parentUpdateNodeIds = new ArrayList();
            BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
            BpmNodeDef curNodeDef = bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
            if (BeanUtils.isNotEmpty((Object)curNodeDef.getParentBpmNodeDef())) {
                return;
            }
            BpmNodeDef taskNodeDef = null;
            Object afterNodes = null;
            Map<String, List<BpmNodeDef>> targetNodeDef = null;
            BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
            List nodeIds = bpmTaskManager.getNodeIdByProcInstId(bpmTask.getProcInstId());
            taskNodeDef = bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), dest);
            List after = BpmStackRelationUtil.getAllAfterListNodeAndTargetNode((String)bpmTask.getProcDefId(), (String)bpmTask.getProcInstId(), (String)taskNodeDef.getNodeId());
            targetNodeDef = after.stream().filter(bpmNodeDef -> StringUtil.isNotEmpty((String)bpmNodeDef.getTargetNode())).collect(Collectors.groupingBy(BpmNodeDef::getNodeId));
            Set fromStartNodeIds = after.stream().map(BpmNodeDef::getNodeId).collect(Collectors.toSet());
            Set updateProStatusNodeIds = after.stream().filter(bpmNodeDef -> StringUtil.isEmpty((String)bpmNodeDef.getTargetNode())).map(BpmNodeDef::getNodeId).collect(Collectors.toSet());
            parentUpdateNodeIds = fromStartNodeIds.stream().filter(nodeId -> nodeIds.contains(nodeId)).collect(Collectors.toList());
            String procInstId = bpmTask.getBpmnInstId();
            List actExecutions = actExecutionManager.getRejectByProcInstId(procInstId);
            Map<String, List<ActExecution>> actExecutionsMap = actExecutions.stream().collect(Collectors.groupingBy(ActExecution::getId));
            List<String> activeExecutionIds = BpmDefUtil.findCurrentExecutionActiveIds(actExecutionsMap, execId);
            List deleteExecutionIds = actExecutionManager.getExecutionIdsByProcInstIdAndNodeIds(bpmTask.getBpmnInstId(), parentUpdateNodeIds, activeExecutionIds);
            TaskService taskSerivce = (TaskService)AppUtil.getBean(TaskService.class);
            List taskEntityList = actTaskManager.getTaskIdsByExecutionIds(deleteExecutionIds);
            String mainProcessEndNodeId = ((BpmNodeDef)bpmDefinitionAccessor.getEndEvents(bpmTask.getProcDefId()).get(0)).getNodeId();
            parentUpdateNodeIds.remove(currentNodeId);
            Map<String, List<BpmNodeDef>> finalTargetNodeDef = targetNodeDef;
            parentUpdateNodeIds.forEach(nodeId -> {
                String targetNodeId = nodeId;
                if (finalTargetNodeDef.containsKey(nodeId)) {
                    targetNodeId = ((BpmNodeDef)((List)finalTargetNodeDef.get(nodeId)).get(0)).getTargetNode();
                }
                NodeInMulti nodeInMulti = BpmDefUtil.findCurrentNodeInMulti(nodeInMultis, targetNodeId);
                ActivityImpl activity = processDefinition.findActivity((String)nodeId);
                activity.getOutgoingTransitions().clear();
                TransitionImpl transitionImpl = activity.createOutgoingTransition(OUTGOING_TRANSITION + UniqueIdUtil.getSuid());
                ActivityImpl activityImpl = null;
                String destinationNodeId = mainProcessEndNodeId;
                if (BeanUtils.isNotEmpty((Object)nodeInMulti)) {
                    destinationNodeId = nodeInMulti.getEndNodeId();
                }
                activityImpl = processDefinition.findActivity(destinationNodeId);
                transitionImpl.setDestination(activityImpl);
                BpmDefUtil.removeOldIncomingTransition(activityImpl.getIncomingTransitions());
            });
            Map finalFormBoData = (Map)cmd.getTransitVars("bo_inst_");
            String currentTaskActionName = cmd.getActionName();
            ArrayList executeProcInstNodeId = new ArrayList();
            taskEntityList.forEach(taskEntity -> {
                String taskId = taskEntity.getId();
                String taskDefinitionKey = taskEntity.getTaskDefinitionKey();
                boolean isNotSameNode = !taskDefinitionKey.equals(currentNodeId);
                String procInstNodeId = taskEntity.getProcessInstanceId() + taskDefinitionKey;
                if (isNotSameNode && executeProcInstNodeId.contains(procInstNodeId)) {
                    return;
                }
                if (!BpmUtil.buildRejectCmd((String)taskId, (String)"agree", (String)currentTaskActionName, (Map)finalFormBoData, (Boolean)isNotSameNode).booleanValue()) {
                    logger.warn("\u6309\u4f1a\u7b7e\u89c4\u5219\u6d41\u7a0b\u5f15\u64ce\u5df2\u81ea\u52a8\u5904\u7406\u540e\u7eed\u5ba1\u6279\u4efb\u52a1");
                    executeProcInstNodeId.add(procInstNodeId);
                    return;
                }
                taskSerivce.complete(taskId);
                executeProcInstNodeId.add(procInstNodeId);
            });
            ContextThreadUtil.setActionCmd((ActionCmd)cmd);
            BpmProStatusManager bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
            bpmProStatusManager.updateRecycleNode(bpmTask.getProcInstId(), updateProStatusNodeIds, "1");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u83b7\u53d6\u76ee\u6807\u8282\u70b9\u62a5\u9519", (Throwable)e);
        }
    }

    private static void removeOldIncomingTransition(List<PvmTransition> incomingTransitions) {
        Optional<PvmTransition> first = incomingTransitions.stream().filter(pvmTransition -> !pvmTransition.getId().startsWith(OUTGOING_TRANSITION)).findFirst();
        if (first.isPresent()) {
            incomingTransitions.remove(first.get());
        }
    }

    private static List<String> findCurrentExecutionActiveIds(Map<String, List<ActExecution>> actExecutionsMap, String executionId) {
        ArrayList<String> activeExecutionIds = new ArrayList<String>();
        while (actExecutionsMap.containsKey(executionId)) {
            ActExecution actExecution = actExecutionsMap.get(executionId).get(0);
            if (actExecution.isActive()) {
                activeExecutionIds.add(actExecution.getId());
            }
            executionId = actExecution.getParentId();
        }
        return activeExecutionIds;
    }
}

