/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.def.graph;

import com.hotent.activiti.def.graph.ilog.activiti.BPMNEdge;
import com.hotent.activiti.def.graph.ilog.activiti.BPMNShap;
import com.hotent.activiti.def.graph.ilog.activiti.ProcessDiagramGenerator;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.process.def.BpmDefLayout;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmNodeLayout;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.DiagramService;
import com.hotent.bpm.natapi.graph.NatProcessImageService;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service(value="diagramService")
public class DefaultDiagramService
implements DiagramService {
    @Resource
    NatProcessImageService natProcessImageService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    private static final String BPM_XML_NS = "xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"";

    public InputStream getDiagramByBpmnDefId(String defId) {
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        return this.natProcessImageService.getProcessImageByBpmnXml(bpmDefinition.getBpmnXml());
    }

    public InputStream getDiagramByDefId(String defId, Map<String, String> colourMap) {
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        return this.natProcessImageService.getProcessImageByBpmnXml(bpmDefinition.getBpmnXml(), colourMap);
    }

    public BpmDefLayout getLayoutByDefId(String defId) {
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        String bpmnXml = bpmDefinition.getBpmnXml();
        BpmDefLayout bpmDefLayout = new BpmDefLayout();
        ArrayList<BpmNodeLayout> nodeLayoutlist = new ArrayList<BpmNodeLayout>();
        List<BPMNShap> shaps = ProcessDiagramGenerator.extractBPMNShap(bpmnXml);
        List<BPMNEdge> edges = ProcessDiagramGenerator.extractBPMNEdge(bpmnXml);
        Map<String, BPMNShap> shapMaps = shaps.stream().collect(Collectors.toMap(BPMNShap::getBpmnElement, shap -> shap));
        Point2D.Double[] points = ProcessDiagramGenerator.calculateCanvasSize(shaps, edges);
        double shiftX = points[0].getX() < 0.0 ? points[0].getX() : 0.0;
        double shiftY = points[0].getY() < 0.0 ? points[0].getY() : 0.0;
        double width = Math.round(points[1].getX() + 10.0 - shiftX);
        double height = Math.round(points[1].getY() + 10.0 - shiftY);
        double minX = Math.round(points[0].getX() - shiftX);
        double minY = Math.round(points[0].getY() - shiftY);
        minX = minX <= 5.0 ? 5.0 : minX;
        minY = minY <= 5.0 ? 5.0 : minY;
        bpmnXml = bpmnXml.replace(BPM_XML_NS, "");
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        List sequenceFlows = root.selectNodes("//sequenceFlow");
        HashMap<String, String> seqIdandName = new HashMap<String, String>();
        for (Object node : sequenceFlows) {
            String id = ((Element)node).attributeValue("id");
            String name = ((Element)node).attributeValue("name");
            seqIdandName.put(id, name);
        }
        List list = root.selectNodes("//bpmndi:BPMNShape");
        int subProcessNum = 1;
        HashMap<String, Integer> parentZIndexes = new HashMap<String, Integer>();
        double scalePrcent = 1.0;
        if (StringUtil.isNotEmpty((String)ThreadMsgUtil.getMapMsg((String)"flow_chart_scaling"))) {
            scalePrcent = Double.valueOf(ThreadMsgUtil.getMapMsg((String)"flow_chart_scaling"));
        }
        for (int i = 0; i < list.size(); ++i) {
            Element el = (Element)list.get(i);
            String id = el.attributeValue("bpmnElement");
            Element component = (Element)root.selectSingleNode("//*[@id='" + id + "']");
            if (component == null || component.getName().equalsIgnoreCase("participant") || component.getName().equalsIgnoreCase("lane")) continue;
            Element tmp = (Element)el.selectSingleNode("omgdc:Bounds");
            double x = (double)Float.parseFloat(tmp.attributeValue("x")) * scalePrcent;
            double y = (double)Float.parseFloat(tmp.attributeValue("y")) * scalePrcent;
            double w = (double)Float.parseFloat(tmp.attributeValue("width")) * scalePrcent;
            double h = (double)Float.parseFloat(tmp.attributeValue("height")) * scalePrcent;
            x = (float)(x - minX + 5.0 - shiftX);
            y = (float)(y - minY + 5.0 - shiftY);
            Element procEl = (Element)root.selectSingleNode("//process/descendant::*[@id='" + id + "']");
            if (procEl == null) continue;
            String type = procEl.getName();
            if (type.equals("endEvent")) {
                type = NodeType.END.getKey();
            }
            if (type.equals("startEvent")) {
                type = NodeType.START.getKey();
            }
            String nodeId = procEl.attributeValue("id");
            if (!"subProcess".equals(type) && !"callActivity".equals(type)) {
                Element multiObj = procEl.element("multiInstanceLoopCharacteristics");
                String signType = procEl.attributeValue("signType");
                if (multiObj != null && !"subProcess".equals(type)) {
                    type = NodeType.SIGNTASK.getKey();
                }
                if (StringUtil.isNotEmpty((String)signType)) {
                    type = NodeType.CUSTOMSIGNTASK.getKey();
                }
            }
            Element parent = procEl.getParent();
            String name = procEl.attributeValue("name");
            int zIndex = 10;
            String parentName = parent.getName();
            if (parentName.equals("subProcess")) {
                if (parent.getParent().getName().equals("subProcess")) {
                    ++subProcessNum;
                }
                if (type.equalsIgnoreCase("subProcess")) {
                    zIndex = (Integer)parentZIndexes.get(parent.attributeValue("id")) + 1;
                    parentZIndexes.put(id, zIndex);
                } else if (!type.equalsIgnoreCase("startEvent") && !type.equalsIgnoreCase("endEvent")) {
                    zIndex = 10 + subProcessNum;
                }
            } else if (type.equalsIgnoreCase("subProcess")) {
                parentZIndexes.put(id, zIndex);
            }
            String uniqueNodeType = type;
            if (NodeType.SIGNTASK.getKey().equals(uniqueNodeType)) {
                BPMNShap bpmnShap = shapMaps.get(nodeId);
                uniqueNodeType = "false".equals(bpmnShap.getProperties().get("isSequential")) ? "Sequential" + uniqueNodeType : "parallel" + uniqueNodeType;
            }
            BpmNodeLayout bpmNodeLayout = new BpmNodeLayout(id, name, NodeType.fromKey((String)type), x, y, w, h, uniqueNodeType.toLowerCase());
            if (type.equalsIgnoreCase("subProcess")) continue;
            nodeLayoutlist.add(bpmNodeLayout);
        }
        bpmDefLayout.setDefId(defId);
        bpmDefLayout.setName(bpmDefinition.getName());
        bpmDefLayout.setWidth(width);
        bpmDefLayout.setHeight(height + (scalePrcent - 1.0) * 160.0);
        bpmDefLayout.setListLayout(nodeLayoutlist);
        return bpmDefLayout;
    }
}

