/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.def.graph.ilog.activiti;

import com.hotent.activiti.def.graph.ilog.activiti.BPMNEdge;
import com.hotent.activiti.def.graph.ilog.activiti.BPMNShap;
import com.hotent.activiti.def.graph.ilog.activiti.BPMNShapType;
import com.hotent.activiti.def.graph.ilog.activiti.DirectionType;
import com.hotent.activiti.util.FontUtil;
import com.hotent.base.util.Dom4jUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class ProcessDiagramDivGenerator {
    private static FontMetrics getFontMetrics() {
        BufferedImage processDiagram = new BufferedImage(2, 2, 2);
        Graphics2D g = processDiagram.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(Color.black);
        Font font = FontUtil.getFont("\u5b8b\u4f53", 1, 12);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        return fontMetrics;
    }

    public static Point2D.Double[] caculateCanvasSize(List<BPMNShap> shaps, List<BPMNEdge> edges, boolean isEclipseDesigner) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (BPMNShap shap : shaps) {
            if (shap.getX() < minX) {
                minX = shap.getX();
            }
            if (shap.getY() < minY) {
                minY = shap.getY();
            }
            if (shap.getX() + shap.getWidth() > maxX) {
                maxX = shap.getX() + shap.getWidth();
            }
            if (!(shap.getY() + shap.getHeight() > maxY)) continue;
            maxY = shap.getY() + shap.getHeight();
        }
        for (BPMNEdge edge : edges) {
            for (Point2D.Double point : edge.getPoints()) {
                if (point.getX() < minX) {
                    minX = point.getX();
                }
                if (point.getY() < minY) {
                    minY = point.getY();
                }
                if (point.getX() > maxX) {
                    maxX = point.getX();
                }
                if (!(point.getY() > maxY)) continue;
                maxY = point.getY();
            }
            double labelMinX = minX;
            double labelMinY = minY;
            double labelMaxX = maxX;
            double labelMaxY = maxY;
            if (isEclipseDesigner) {
                if (edge.getLabelWidth() > 0.0f && (!(edge.labelX < 0.0f) || edge.labelY != 0.0f)) {
                    labelMinX = edge.getLabelX();
                    labelMinY = edge.getLabelY();
                    labelMaxX = edge.getLabelX() + edge.getLabelWidth();
                    labelMaxY = edge.getLabelY() + edge.getLabelHeight();
                }
            } else {
                String label;
                String string = label = edge.getName() == null ? "" : edge.getName();
                if (!"".equals(label)) {
                    Point2D.Double midPoint = edge.getMidpoint();
                    DirectionType directionType = edge.getDirection();
                    FontMetrics fontMetrics = ProcessDiagramDivGenerator.getFontMetrics();
                    if (directionType == DirectionType.UpToDown) {
                        labelMinX = midPoint.getX() + (double)fontMetrics.getHeight() / 2.0;
                        labelMinY = midPoint.getY();
                    } else if (directionType == DirectionType.DownToUp) {
                        labelMinX = midPoint.getX() - (double)fontMetrics.stringWidth(label) - (double)fontMetrics.getHeight() / 2.0;
                        labelMinY = midPoint.getY() - (double)fontMetrics.getHeight() / 2.0 - (double)fontMetrics.getHeight();
                    } else if (directionType == DirectionType.LeftToRight) {
                        labelMinX = midPoint.getX() - (double)fontMetrics.stringWidth(label) / 2.0;
                        labelMinY = midPoint.getY();
                    } else {
                        labelMinX = (double)fontMetrics.stringWidth(label) / 2.0;
                        labelMinY = midPoint.getY() + (double)fontMetrics.getHeight() - (double)fontMetrics.getHeight();
                    }
                    labelMaxX = labelMinX + (double)fontMetrics.stringWidth(label);
                    labelMaxY = labelMinY + (double)fontMetrics.getHeight();
                }
            }
            if (labelMinX < minX) {
                minX = labelMinX;
            }
            if (labelMinY < minY) {
                minY = labelMinY;
            }
            if (labelMaxX > maxX) {
                maxX = labelMaxX;
            }
            if (!(labelMaxY > maxY)) continue;
            maxY = labelMaxY;
        }
        return new Point2D.Double[]{new Point2D.Double(minX, minY), new Point2D.Double(maxX, maxY)};
    }

    public static List<BPMNShap> extractBPMNShap(String bpmnXml) {
        bpmnXml = bpmnXml.replace("xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"", "");
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        List shaps = root.selectNodes("//bpmndi:BPMNShape");
        ArrayList<BPMNShap> bpmnShaps = new ArrayList<BPMNShap>();
        for (Node node : shaps) {
            Element shap = (Element)node;
            BPMNShap bpmnShap = new BPMNShap();
            bpmnShap.setBpmnElement(shap.attributeValue("bpmnElement"));
            bpmnShap.setChoreographyActivityShape(shap.attributeValue("choreographyActivityShape"));
            bpmnShap.setHorizontal(ProcessDiagramDivGenerator.getBooleanAttr(shap, "isHorizontal"));
            bpmnShap.setExpanded(ProcessDiagramDivGenerator.getBooleanAttr(shap, "isExpanded"));
            bpmnShap.setMarkerVisible(ProcessDiagramDivGenerator.getBooleanAttr(shap, "isMarkerVisible"));
            bpmnShap.setMessageVisible(ProcessDiagramDivGenerator.getBooleanAttr(shap, "isMessageVisible"));
            bpmnShap.setParticipantBandKind(shap.attributeValue("participantBandKind"));
            Element bound = (Element)shap.selectSingleNode("./omgdc:Bounds");
            bpmnShap.setX(Double.parseDouble(bound.attributeValue("x")));
            bpmnShap.setY(Double.parseDouble(bound.attributeValue("y")));
            bpmnShap.setWidth(Double.parseDouble(bound.attributeValue("width")));
            bpmnShap.setHeight(Double.parseDouble(bound.attributeValue("height")));
            Element component = (Element)root.selectSingleNode("//*[@id='" + bpmnShap.getBpmnElement() + "']");
            if (component == null) continue;
            BPMNShapType type = ProcessDiagramDivGenerator.getBPMNShapType(component);
            bpmnShap.setType(type);
            bpmnShap.setName(component.attributeValue("name"));
            ProcessDiagramDivGenerator.setBPMNShapProperties(component, bpmnShap);
            bpmnShaps.add(bpmnShap);
        }
        return bpmnShaps;
    }

    public static List<BPMNEdge> extractBPMNEdge(String bpmnXml) {
        ArrayList<BPMNEdge> bpmnEdges = new ArrayList<BPMNEdge>();
        bpmnXml = bpmnXml.replace("xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"", "");
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        List edges = root.selectNodes("//bpmndi:BPMNEdge");
        for (Node node : edges) {
            DirectionType directionType;
            int i;
            double y;
            double x;
            Element edge = (Element)node;
            BPMNEdge bpmnEdge = new BPMNEdge();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            List waypoints = edge.selectNodes("./omgdi:waypoint");
            for (Node wayNode : waypoints) {
                Element waypoint = (Element)wayNode;
                x = Double.parseDouble(waypoint.attributeValue("x"));
                y = Double.parseDouble(waypoint.attributeValue("y"));
                Point2D.Double point = new Point2D.Double(x, y);
                points.add(point);
            }
            bpmnEdge.setPoints(points);
            Element label = (Element)edge.selectSingleNode("./bpmndi:BPMNLabel/omgdc:Bounds");
            if (label != null) {
                float labelX = Float.parseFloat(label.attributeValue("x"));
                float labelY = Float.parseFloat(label.attributeValue("y"));
                float labelWidth = Float.parseFloat(label.attributeValue("width"));
                float labelHeight = Float.parseFloat(label.attributeValue("height"));
                bpmnEdge.setLabelX(labelX);
                bpmnEdge.setLabelY(labelY);
                bpmnEdge.setLabelWidth(labelWidth);
                bpmnEdge.setLabelHeight(labelHeight);
            }
            String bpmnElement = edge.attributeValue("bpmnElement");
            Element component = (Element)root.selectSingleNode("//sequenceFlow[@id='" + bpmnElement + "']");
            bpmnEdge.setName(component.attributeValue("name"));
            x = 0.0;
            y = 0.0;
            ArrayList<Double> lens = new ArrayList<Double>();
            for (int i2 = 1; i2 < points.size(); ++i2) {
                lens.add(Math.abs(((Point2D.Double)points.get(i2 - 1)).getX() - ((Point2D.Double)points.get(i2)).getX()) + Math.abs(((Point2D.Double)points.get(i2 - 1)).getY() - ((Point2D.Double)points.get(i2)).getY()));
            }
            double halfLen = 0.0;
            Iterator iterator = lens.iterator();
            while (iterator.hasNext()) {
                double len = (Double)iterator.next();
                halfLen += len;
            }
            halfLen /= 2.0;
            double accumulativeLen = 0.0;
            for (i = 0; i < lens.size() && !((accumulativeLen += ((Double)lens.get(i)).doubleValue()) > halfLen); ++i) {
            }
            if (((Point2D.Double)points.get(i)).getX() == ((Point2D.Double)points.get(i + 1)).getX()) {
                if (((Point2D.Double)points.get(i)).getY() < ((Point2D.Double)points.get(i + 1)).getY()) {
                    y = halfLen - accumulativeLen + ((Point2D.Double)points.get(i + 1)).getY();
                    directionType = DirectionType.UpToDown;
                } else {
                    y = accumulativeLen - halfLen + ((Point2D.Double)points.get(i + 1)).getY();
                    directionType = DirectionType.DownToUp;
                }
                x = ((Point2D.Double)points.get(i)).getX();
            } else {
                if (((Point2D.Double)points.get(i)).getX() < ((Point2D.Double)points.get(i + 1)).getX()) {
                    x = halfLen - accumulativeLen + ((Point2D.Double)points.get(i + 1)).getX();
                    directionType = DirectionType.LeftToRight;
                } else {
                    x = accumulativeLen - halfLen + ((Point2D.Double)points.get(i + 1)).getX();
                    directionType = DirectionType.RightToLef;
                }
                y = ((Point2D.Double)points.get(i)).getY();
            }
            Point2D.Double midpoint = new Point2D.Double(x, y);
            bpmnEdge.setMidpoint(midpoint);
            bpmnEdge.setDirection(directionType);
            bpmnEdges.add(bpmnEdge);
        }
        return bpmnEdges;
    }

    private static BPMNShap setBPMNShapProperties(Element component, BPMNShap bpmnShap) {
        Element multiInstanceLoopCharacteristics;
        BPMNShapType type = bpmnShap.getType();
        Properties properties = bpmnShap.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if ((type == BPMNShapType.Task || type == BPMNShapType.ScriptTask || type == BPMNShapType.ServiceTask || type == BPMNShapType.BusinessRuleTask || type == BPMNShapType.ManualTask || type == BPMNShapType.UserTask || type == BPMNShapType.CallActivity || type == BPMNShapType.SubProcess) && (multiInstanceLoopCharacteristics = (Element)component.selectSingleNode("./multiInstanceLoopCharacteristics")) != null) {
            String isSequential = multiInstanceLoopCharacteristics.attributeValue("isSequential");
            properties.put("isSequential", isSequential);
        }
        if (type == BPMNShapType.ErrorEvent) {
            Element errorEventDefinition = (Element)component.selectSingleNode("errorEventDefinition");
            String errorRef = errorEventDefinition.attributeValue("errorRef");
            properties.put("errorRef", errorRef);
        }
        bpmnShap.setProperties(properties);
        return bpmnShap;
    }

    private static Boolean getBooleanAttr(Element element, String attr) {
        String attrVal = element.attributeValue(attr);
        if (attrVal != null) {
            return attrVal.equalsIgnoreCase("true");
        }
        return null;
    }

    public static BPMNShapType getBPMNShapType(Element component) {
        BPMNShapType retVal = BPMNShapType.UnknowType;
        if (component.getName().equals("startEvent")) {
            retVal = BPMNShapType.StartEvent;
        } else if (component.getName().equals("endEvent")) {
            Element errorEventDefinition = (Element)component.selectSingleNode("errorEventDefinition");
            retVal = errorEventDefinition == null ? BPMNShapType.EndEvent : BPMNShapType.ErrorEvent;
        } else if (component.getName().equals("exclusiveGateway")) {
            retVal = BPMNShapType.ExclusiveGateway;
        } else if (component.getName().equals("inclusiveGateway")) {
            retVal = BPMNShapType.InclusiveGateway;
        } else if (component.getName().equals("parallelGateway")) {
            retVal = BPMNShapType.ParallelGateway;
        } else if (component.getName().equals("scriptTask")) {
            retVal = BPMNShapType.ScriptTask;
        } else if (component.getName().equals("serviceTask")) {
            retVal = BPMNShapType.ServiceTask;
        } else if (component.getName().equals("businessRuleTask")) {
            retVal = BPMNShapType.BusinessRuleTask;
        } else if (component.getName().equals("task")) {
            retVal = BPMNShapType.Task;
        } else if (component.getName().equals("manualTask")) {
            retVal = BPMNShapType.ManualTask;
        } else if (component.getName().equals("userTask")) {
            retVal = BPMNShapType.UserTask;
        } else if (component.getName().equals("sendTask")) {
            retVal = BPMNShapType.SendTask;
        } else if (component.getName().equals("receiveTask")) {
            retVal = BPMNShapType.ReceiveTask;
        } else if (component.getName().equals("subProcess")) {
            retVal = BPMNShapType.SubProcess;
        } else if (component.getName().equals("callActivity")) {
            retVal = BPMNShapType.CallActivity;
        } else if (component.getName().equals("intermediateCatchEvent")) {
            retVal = BPMNShapType.IntermediateCatchEvent;
        } else if (component.getName().equals("adHocSubProcess")) {
            retVal = BPMNShapType.ComplexGateway;
        } else if (component.getName().equals("eventBasedGateway")) {
            retVal = BPMNShapType.EventBasedGateway;
        } else if (component.getName().equals("transaction")) {
            retVal = BPMNShapType.Transaction;
        } else if (component.getName().equals("participant")) {
            String id = component.attributeValue("id");
            String processRef = component.attributeValue("processRef");
            Element root = component.getDocument().getRootElement();
            Element process = (Element)root.selectSingleNode("//*[@id='" + processRef + "']");
            if (process.element("laneSet") != null) {
                Element shap = (Element)root.selectSingleNode("//*[@bpmnElement='" + id + "']");
                String isHorizontal = shap.attributeValue("isHorizontal");
                retVal = isHorizontal != null && isHorizontal.equalsIgnoreCase("false") ? BPMNShapType.VPool : BPMNShapType.HPool;
            }
        } else if (component.getName().equals("lane")) {
            String id = component.attributeValue("id");
            Element root = component.getDocument().getRootElement();
            Element shap = (Element)root.selectSingleNode("//*[@bpmnElement='" + id + "']");
            String isHorizontal = shap.attributeValue("isHorizontal");
            retVal = isHorizontal != null && isHorizontal.equalsIgnoreCase("false") ? BPMNShapType.VLane : BPMNShapType.HLane;
        }
        return retVal;
    }
}

