/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.def.graph.ilog.activiti;

import com.hotent.activiti.def.graph.ilog.activiti.BPMNEdge;
import com.hotent.activiti.def.graph.ilog.activiti.BPMNShap;
import com.hotent.activiti.def.graph.ilog.activiti.BPMNShapType;
import com.hotent.activiti.def.graph.ilog.activiti.DirectionType;
import com.hotent.activiti.def.graph.ilog.activiti.GraphDrawInstruction;
import com.hotent.activiti.def.graph.ilog.activiti.ProcessDiagramCanvas;
import com.hotent.activiti.util.FontUtil;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class ProcessDiagramGenerator {
    protected static final Map<BPMNShapType, GraphDrawInstruction> graphDrawInstructions = new HashMap<BPMNShapType, GraphDrawInstruction>();

    public static ProcessDiagramCanvas initProcessDiagramCanvas(List<BPMNShap> shapes, List<BPMNEdge> edges) {
        Point2D.Double[] points = ProcessDiagramGenerator.calculateCanvasSize(shapes, edges);
        Point2D.Double shiftPoint = ProcessDiagramGenerator.shiftPoint(points[0]);
        ProcessDiagramGenerator.shiftProcessDefinition(shapes, edges, shiftPoint.getX(), shiftPoint.getY());
        int width = (int)Math.round(points[1].getX() + 10.0 - shiftPoint.getX());
        int height = (int)Math.round(points[1].getY() + 10.0 - shiftPoint.getY());
        int minX = (int)Math.round(points[0].getX() - shiftPoint.getX());
        int minY = (int)Math.round(points[0].getY() - shiftPoint.getY());
        return new ProcessDiagramCanvas(width, height, minX, minY);
    }

    private static Point2D.Double shiftPoint(Point2D.Double point) {
        double shiftX = point.getX() < 0.0 ? point.getX() : 0.0;
        double shiftY = point.getY() < 0.0 ? point.getY() : 0.0;
        return new Point2D.Double(shiftX, shiftY);
    }

    public static InputStream generatePngDiagram(String bpmnXml) {
        return ProcessDiagramGenerator.generateDiagram(bpmnXml, "png", Collections.emptyList());
    }

    public static InputStream generateJpgDiagram(String bpmnXml) {
        return ProcessDiagramGenerator.generateDiagram(bpmnXml, "jpg", Collections.emptyList());
    }

    public static InputStream generatePngDiagram(String bpmnXml, Map<String, String> highLightedActivities) {
        return ProcessDiagramGenerator.generateDiagram(bpmnXml, highLightedActivities, "png");
    }

    public static ProcessDiagramCanvas generateDiagram(String bpmnXml, List<String> highLightedActivities) {
        List<BPMNShap> bpmnShaps = ProcessDiagramGenerator.extractBPMNShap(bpmnXml);
        List<BPMNEdge> bpmnEdges = ProcessDiagramGenerator.extractBPMNEdge(bpmnXml);
        ProcessDiagramCanvas processDiagramCanvas = ProcessDiagramGenerator.initProcessDiagramCanvas(bpmnShaps, bpmnEdges);
        ProcessDiagramGenerator.drawSequenceFlows(processDiagramCanvas, new HashMap<String, String>(), bpmnEdges);
        ProcessDiagramGenerator.drawActivities(processDiagramCanvas, highLightedActivities, bpmnShaps);
        return processDiagramCanvas;
    }

    public static ProcessDiagramCanvas generateDiagram(Map<String, String> highLightedActivities, String bpmnXml) {
        List<BPMNEdge> bpmnEdges = ProcessDiagramGenerator.extractBPMNEdge(bpmnXml);
        List<BPMNShap> bpmnShaps = ProcessDiagramGenerator.extractBPMNShap(bpmnXml);
        ProcessDiagramCanvas processDiagramCanvas = ProcessDiagramGenerator.initProcessDiagramCanvas(bpmnShaps, bpmnEdges);
        ProcessDiagramGenerator.handleHighLightedActivities(bpmnEdges, bpmnShaps, highLightedActivities);
        ProcessDiagramGenerator.drawSequenceFlows(processDiagramCanvas, highLightedActivities, bpmnEdges);
        ProcessDiagramGenerator.drawActivities(processDiagramCanvas, highLightedActivities, bpmnShaps);
        return processDiagramCanvas;
    }

    private static void handleHighLightedActivities(List<BPMNEdge> bpmnEdges, List<BPMNShap> bpmnShaps, Map<String, String> highLightedActivities) {
        Set passedEdges = bpmnEdges.stream().filter(item -> highLightedActivities.containsKey(item.getTargetRef())).map(BPMNEdge::getSourceRef).collect(Collectors.toSet());
        bpmnShaps.stream().filter(item -> passedEdges.contains(item.getBpmnElement())).filter(item -> BPMNShapType.ExclusiveGateway == item.getType() || BPMNShapType.InclusiveGateway == item.getType() || BPMNShapType.ParallelGateway == item.getType()).forEach(item -> highLightedActivities.put(item.getBpmnElement(), "#07C160"));
    }

    public static InputStream generateDiagram(String bpmnXml, Map<String, String> highLightedActivities, String imageType) {
        return ProcessDiagramGenerator.generateDiagram(highLightedActivities, bpmnXml).generateImage(imageType);
    }

    public static InputStream generateDiagram(String bpmnXml, String imageType, List<String> highLightedActivities) {
        return ProcessDiagramGenerator.generateDiagram(bpmnXml, highLightedActivities).generateImage(imageType);
    }

    public static void drawActivity(ProcessDiagramCanvas processDiagramCanvas, BPMNShap bpmnShap, List<String> highLightedActivities) {
        GraphDrawInstruction drawInstruction = graphDrawInstructions.get((Object)bpmnShap.getType());
        if (drawInstruction != null) {
            drawInstruction.draw(processDiagramCanvas, bpmnShap, null);
            boolean multiInstanceSequential = false;
            boolean multiInstanceParallel = false;
            boolean collapsed = false;
            Boolean expanded = bpmnShap.isExpanded();
            if (expanded != null) {
                collapsed = expanded == false;
            }
            processDiagramCanvas.drawActivityMarkers((int)Math.round(bpmnShap.getX()), (int)Math.round(bpmnShap.getY()), (int)Math.round(bpmnShap.getWidth()), (int)Math.round(bpmnShap.getHeight()), multiInstanceSequential, multiInstanceParallel, collapsed);
            if (highLightedActivities.contains(bpmnShap.getBpmnElement())) {
                ProcessDiagramGenerator.drawHighLight(processDiagramCanvas, bpmnShap);
            }
        }
    }

    public static void drawActivity(ProcessDiagramCanvas processDiagramCanvas, Map<String, String> highLightedActivities, BPMNShap bpmnShap) {
        GraphDrawInstruction drawInstruction = graphDrawInstructions.get((Object)bpmnShap.getType());
        if (drawInstruction != null) {
            String highLightColor = highLightedActivities.get(bpmnShap.getBpmnElement());
            drawInstruction.draw(processDiagramCanvas, bpmnShap, highLightColor);
            boolean multiInstanceSequential = false;
            boolean multiInstanceParallel = false;
            boolean collapsed = false;
            Boolean expanded = bpmnShap.isExpanded();
            if (expanded != null) {
                collapsed = expanded == false;
            }
            processDiagramCanvas.drawActivityMarkers((int)Math.round(bpmnShap.getX()), (int)Math.round(bpmnShap.getY()), (int)Math.round(bpmnShap.getWidth()), (int)Math.round(bpmnShap.getHeight()), multiInstanceSequential, multiInstanceParallel, collapsed);
        }
    }

    public static void drawActivities(ProcessDiagramCanvas processDiagramCanvas, Map<String, String> highLightedActivities, List<BPMNShap> bpmnShapes) {
        for (BPMNShap bpmnShap : bpmnShapes) {
            ProcessDiagramGenerator.drawActivity(processDiagramCanvas, highLightedActivities, bpmnShap);
        }
    }

    public static void drawActivities(ProcessDiagramCanvas processDiagramCanvas, List<String> highLightedActivities, List<BPMNShap> bpmnShapes) {
        for (BPMNShap bpmnShap : bpmnShapes) {
            ProcessDiagramGenerator.drawActivity(processDiagramCanvas, bpmnShap, highLightedActivities);
        }
    }

    public static void drawSequenceFlows(ProcessDiagramCanvas processDiagramCanvas, Map<String, String> highLightedActivities, List<BPMNEdge> bpmnEdges) {
        for (BPMNEdge bpmnEdge : bpmnEdges) {
            processDiagramCanvas.drawSequenceflowWidthLabel(bpmnEdge, highLightedActivities.containsKey(bpmnEdge.getTargetRef()));
        }
    }

    private static void drawHighLight(ProcessDiagramCanvas processDiagramCanvas, BPMNShap bpmnShap) {
        processDiagramCanvas.drawHighLight((int)Math.round(bpmnShap.getX()), (int)Math.round(bpmnShap.getY()), (int)Math.round(bpmnShap.getWidth()), (int)Math.round(bpmnShap.getHeight()));
    }

    private static void drawHighLight(ProcessDiagramCanvas processDiagramCanvas, BPMNShap bpmnShap, String color) {
        processDiagramCanvas.drawHighLight((int)Math.round(bpmnShap.getX()), (int)Math.round(bpmnShap.getY()), (int)Math.round(bpmnShap.getWidth()), (int)Math.round(bpmnShap.getHeight()), color);
    }

    private static void drawHighLight(ProcessDiagramCanvas processDiagramCanvas, BPMNShap bpmnShap, Short status) {
        processDiagramCanvas.drawHighLight((int)Math.round(bpmnShap.getX()), (int)Math.round(bpmnShap.getY()), (int)Math.round(bpmnShap.getWidth()), (int)Math.round(bpmnShap.getHeight()), status);
    }

    private static FontMetrics getFontMetrics() {
        BufferedImage processDiagram = new BufferedImage(2, 2, 2);
        Graphics2D g = processDiagram.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(Color.black);
        Font font = FontUtil.getFont("\u5b8b\u4f53", 1, 12);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        return fontMetrics;
    }

    public static Point2D.Double[] calculateCanvasSize(List<BPMNShap> shapes, List<BPMNEdge> edges) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (BPMNShap shape : shapes) {
            if (shape.getX() < minX) {
                minX = shape.getX();
            }
            if (shape.getY() < minY) {
                minY = shape.getY();
            }
            if (shape.getX() + shape.getWidth() > maxX) {
                maxX = shape.getX() + shape.getWidth();
            }
            if (!(shape.getY() + shape.getHeight() > maxY)) continue;
            maxY = shape.getY() + shape.getHeight();
        }
        for (BPMNEdge edge : edges) {
            double labelMinY;
            double labelMinX;
            for (Point2D.Double point : edge.getPoints()) {
                if (point.getX() < minX) {
                    minX = point.getX();
                }
                if (point.getY() < minY) {
                    minY = point.getY();
                }
                if (point.getX() > maxX) {
                    maxX = point.getX();
                }
                if (!(point.getY() > maxY)) continue;
                maxY = point.getY();
            }
            String label = edge.getName() == null ? "" : edge.getName();
            Point2D.Double midPoint = edge.getMidpoint();
            DirectionType directionType = edge.getDirection();
            FontMetrics fontMetrics = ProcessDiagramGenerator.getFontMetrics();
            if (directionType == DirectionType.UpToDown) {
                labelMinX = midPoint.getX() + (double)fontMetrics.getHeight() / 2.0;
                labelMinY = midPoint.getY();
            } else if (directionType == DirectionType.DownToUp) {
                labelMinX = midPoint.getX() - (double)fontMetrics.stringWidth(label) - (double)fontMetrics.getHeight() / 2.0;
                labelMinY = midPoint.getY() - (double)fontMetrics.getHeight() / 2.0 - (double)fontMetrics.getHeight();
            } else if (directionType == DirectionType.LeftToRight) {
                labelMinX = midPoint.getX() - (double)fontMetrics.stringWidth(label) / 2.0;
                labelMinY = midPoint.getY();
            } else {
                labelMinX = (double)fontMetrics.stringWidth(label) / 2.0;
                labelMinY = midPoint.getY() + (double)fontMetrics.getHeight() - (double)fontMetrics.getHeight();
            }
            double labelMaxX = labelMinX + (double)fontMetrics.stringWidth(label);
            double labelMaxY = labelMinY + (double)fontMetrics.getHeight();
            if (labelMinX < minX) {
                minX = labelMinX;
            }
            if (labelMinY < minY) {
                minY = labelMinY;
            }
            if (labelMaxX > maxX) {
                maxX = labelMaxX;
            }
            if (!(labelMaxY > maxY)) continue;
            maxY = labelMaxY;
        }
        return new Point2D.Double[]{new Point2D.Double(minX, minY), new Point2D.Double(maxX, maxY)};
    }

    private static void shiftProcessDefinition(List<BPMNShap> shapes, List<BPMNEdge> edges, double x, double y) {
        for (BPMNShap shape : shapes) {
            shape.setX(shape.getX() - x);
            shape.setY(shape.getY() - y);
        }
        for (BPMNEdge edge : edges) {
            for (Point2D.Double point : edge.getPoints()) {
                point.x = point.getX() - x;
                point.y = point.getY() - y;
            }
            edge.getMidpoint().x = edge.getMidpoint().getX() - x;
            edge.getMidpoint().y = edge.getMidpoint().getY() - y;
        }
    }

    public static List<BPMNShap> extractBPMNShap(String bpmnXml) {
        bpmnXml = bpmnXml.replace("xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"", "");
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        double scalePrcent = 1.0;
        if (StringUtil.isNotEmpty((String)ThreadMsgUtil.getMapMsg((String)"flow_chart_scaling"))) {
            scalePrcent = Double.valueOf(ThreadMsgUtil.getMapMsg((String)"flow_chart_scaling"));
        }
        List shaps = root.selectNodes("//bpmndi:BPMNShape");
        ArrayList<BPMNShap> bpmnShaps = new ArrayList<BPMNShap>();
        for (Node node : shaps) {
            Element shap = (Element)node;
            BPMNShap bpmnShap = new BPMNShap();
            bpmnShap.setBpmnElement(shap.attributeValue("bpmnElement"));
            bpmnShap.setChoreographyActivityShape(shap.attributeValue("choreographyActivityShape"));
            bpmnShap.setHorizontal(ProcessDiagramGenerator.getBooleanAttr(shap, "isHorizontal"));
            bpmnShap.setExpanded(ProcessDiagramGenerator.getBooleanAttr(shap, "isExpanded"));
            bpmnShap.setMarkerVisible(ProcessDiagramGenerator.getBooleanAttr(shap, "isMarkerVisible"));
            bpmnShap.setMessageVisible(ProcessDiagramGenerator.getBooleanAttr(shap, "isMessageVisible"));
            bpmnShap.setParticipantBandKind(shap.attributeValue("participantBandKind"));
            Element bound = (Element)shap.selectSingleNode("./omgdc:Bounds");
            bpmnShap.setX(Double.parseDouble(bound.attributeValue("x")) * scalePrcent);
            bpmnShap.setY(Double.parseDouble(bound.attributeValue("y")) * scalePrcent);
            bpmnShap.setWidth(Double.parseDouble(bound.attributeValue("width")) * scalePrcent);
            bpmnShap.setHeight(Double.parseDouble(bound.attributeValue("height")) * scalePrcent);
            Element component = (Element)root.selectSingleNode("//*[@id='" + bpmnShap.getBpmnElement() + "']");
            if (component == null) continue;
            BPMNShapType type = ProcessDiagramGenerator.getBPMNShapType(component);
            bpmnShap.setParentRef(component.getParent().attributeValue("id"));
            bpmnShap.setType(type);
            bpmnShap.setName(component.attributeValue("name"));
            ProcessDiagramGenerator.setBPMNShapProperties(component, bpmnShap);
            bpmnShaps.add(bpmnShap);
        }
        return bpmnShaps;
    }

    public static List<BPMNEdge> extractBPMNEdge(String bpmnXml) {
        ArrayList<BPMNEdge> bpmnEdges = new ArrayList<BPMNEdge>();
        bpmnXml = bpmnXml.replace("xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"", "");
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        double scalePrcent = 1.0;
        if (StringUtil.isNotEmpty((String)ThreadMsgUtil.getMapMsg((String)"flow_chart_scaling"))) {
            scalePrcent = Double.valueOf(ThreadMsgUtil.getMapMsg((String)"flow_chart_scaling"));
        }
        List edges = root.selectNodes("//bpmndi:BPMNEdge");
        for (Node node : edges) {
            DirectionType directionType;
            int i;
            Element edge = (Element)node;
            BPMNEdge bpmnEdge = new BPMNEdge();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            List waypoints = edge.selectNodes("./omgdi:waypoint");
            for (Node wayNode : waypoints) {
                Element waypoint = (Element)wayNode;
                double x = Double.parseDouble(waypoint.attributeValue("x"));
                double y = Double.parseDouble(waypoint.attributeValue("y"));
                Point2D.Double point = new Point2D.Double(x * scalePrcent, y * scalePrcent);
                points.add(point);
            }
            bpmnEdge.setPoints(points);
            String bpmnElement = edge.attributeValue("bpmnElement");
            Element component = (Element)root.selectSingleNode("//sequenceFlow[@id='" + bpmnElement + "']");
            bpmnEdge.setId(component.attributeValue("id"));
            bpmnEdge.setName(component.attributeValue("name"));
            bpmnEdge.setSourceRef(component.attributeValue("sourceRef"));
            bpmnEdge.setTargetRef(component.attributeValue("targetRef"));
            bpmnEdge.setParentRef(component.getParent().attributeValue("id"));
            double x = 0.0;
            double y = 0.0;
            ArrayList<Double> lens = new ArrayList<Double>();
            for (int i2 = 1; i2 < points.size(); ++i2) {
                lens.add(Math.abs(((Point2D.Double)points.get(i2 - 1)).getX() - ((Point2D.Double)points.get(i2)).getX()) + Math.abs(((Point2D.Double)points.get(i2 - 1)).getY() - ((Point2D.Double)points.get(i2)).getY()));
            }
            double halfLen = 0.0;
            Iterator iterator = lens.iterator();
            while (iterator.hasNext()) {
                double len = (Double)iterator.next();
                halfLen += len;
            }
            halfLen /= 2.0;
            double accumulativeLen = 0.0;
            for (i = 0; i < lens.size() && !((accumulativeLen += ((Double)lens.get(i)).doubleValue()) > halfLen); ++i) {
            }
            if (((Point2D.Double)points.get(i)).getX() == ((Point2D.Double)points.get(i + 1)).getX()) {
                if (((Point2D.Double)points.get(i)).getY() < ((Point2D.Double)points.get(i + 1)).getY()) {
                    y = halfLen - accumulativeLen + ((Point2D.Double)points.get(i + 1)).getY();
                    directionType = DirectionType.UpToDown;
                } else {
                    y = accumulativeLen - halfLen + ((Point2D.Double)points.get(i + 1)).getY();
                    directionType = DirectionType.DownToUp;
                }
                x = ((Point2D.Double)points.get(i)).getX();
            } else {
                if (((Point2D.Double)points.get(i)).getX() < ((Point2D.Double)points.get(i + 1)).getX()) {
                    x = halfLen - accumulativeLen + ((Point2D.Double)points.get(i + 1)).getX();
                    directionType = DirectionType.LeftToRight;
                } else {
                    x = accumulativeLen - halfLen + ((Point2D.Double)points.get(i + 1)).getX();
                    directionType = DirectionType.RightToLef;
                }
                y = ((Point2D.Double)points.get(i)).getY();
            }
            Point2D.Double midpoint = new Point2D.Double(x, y);
            bpmnEdge.setMidpoint(midpoint);
            bpmnEdge.setDirection(directionType);
            bpmnEdges.add(bpmnEdge);
        }
        return bpmnEdges;
    }

    private static BPMNShap setBPMNShapProperties(Element component, BPMNShap bpmnShap) {
        Element multiInstanceLoopCharacteristics;
        BPMNShapType type = bpmnShap.getType();
        Properties properties = bpmnShap.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if ((type == BPMNShapType.Task || type == BPMNShapType.ScriptTask || type == BPMNShapType.ServiceTask || type == BPMNShapType.BusinessRuleTask || type == BPMNShapType.ManualTask || type == BPMNShapType.UserTask || type == BPMNShapType.CallActivity || type == BPMNShapType.SubProcess) && (multiInstanceLoopCharacteristics = (Element)component.selectSingleNode("./multiInstanceLoopCharacteristics")) != null) {
            Attribute isSequentialAttribute = multiInstanceLoopCharacteristics.attribute("isSequential");
            String isSequential = "false";
            if (isSequentialAttribute != null) {
                isSequential = multiInstanceLoopCharacteristics.attributeValue("isSequential");
            }
            properties.put("isSequential", isSequential);
        }
        if (type == BPMNShapType.ErrorEvent) {
            Element errorEventDefinition = (Element)component.selectSingleNode("errorEventDefinition");
            String errorRef = errorEventDefinition.attributeValue("errorRef");
            properties.put("errorRef", errorRef);
        }
        bpmnShap.setProperties(properties);
        return bpmnShap;
    }

    private static Boolean getBooleanAttr(Element element, String attr) {
        String attrVal = element.attributeValue(attr);
        if (attrVal != null) {
            return attrVal.equalsIgnoreCase("true");
        }
        return null;
    }

    public static BPMNShapType getBPMNShapType(Element component) {
        BPMNShapType retVal = BPMNShapType.UnknowType;
        if (component.getName().equals("startEvent")) {
            retVal = BPMNShapType.StartEvent;
        } else if (component.getName().equals("endEvent")) {
            Element errorEventDefinition = (Element)component.selectSingleNode("errorEventDefinition");
            retVal = errorEventDefinition == null ? BPMNShapType.EndEvent : BPMNShapType.ErrorEvent;
        } else if (component.getName().equals("exclusiveGateway")) {
            retVal = BPMNShapType.ExclusiveGateway;
        } else if (component.getName().equals("inclusiveGateway")) {
            retVal = BPMNShapType.InclusiveGateway;
        } else if (component.getName().equals("parallelGateway")) {
            retVal = BPMNShapType.ParallelGateway;
        } else if (component.getName().equals("scriptTask")) {
            retVal = BPMNShapType.ScriptTask;
        } else if (component.getName().equals("serviceTask")) {
            retVal = BPMNShapType.ServiceTask;
        } else if (component.getName().equals("businessRuleTask")) {
            retVal = BPMNShapType.BusinessRuleTask;
        } else if (component.getName().equals("task")) {
            retVal = BPMNShapType.Task;
        } else if (component.getName().equals("manualTask")) {
            retVal = BPMNShapType.ManualTask;
        } else if (component.getName().equals("userTask")) {
            retVal = BPMNShapType.UserTask;
        } else if (component.getName().equals("sendTask")) {
            retVal = BPMNShapType.SendTask;
        } else if (component.getName().equals("receiveTask")) {
            retVal = BPMNShapType.ReceiveTask;
        } else if (component.getName().equals("subProcess")) {
            retVal = BPMNShapType.SubProcess;
        } else if (component.getName().equals("callActivity")) {
            retVal = BPMNShapType.CallActivity;
        } else if (component.getName().equals("intermediateCatchEvent")) {
            retVal = BPMNShapType.IntermediateCatchEvent;
        } else if (component.getName().equals("adHocSubProcess")) {
            retVal = BPMNShapType.ComplexGateway;
        } else if (component.getName().equals("eventBasedGateway")) {
            retVal = BPMNShapType.EventBasedGateway;
        } else if (component.getName().equals("transaction")) {
            retVal = BPMNShapType.Transaction;
        } else if (component.getName().equals("participant")) {
            String id = component.attributeValue("id");
            String processRef = component.attributeValue("processRef");
            Element root = component.getDocument().getRootElement();
            Element process = (Element)root.selectSingleNode("//*[@id='" + processRef + "']");
            if (process.element("laneSet") != null) {
                Element shap = (Element)root.selectSingleNode("//*[@bpmnElement='" + id + "']");
                String isHorizontal = shap.attributeValue("isHorizontal");
                retVal = isHorizontal != null && isHorizontal.equalsIgnoreCase("false") ? BPMNShapType.VPool : BPMNShapType.HPool;
            }
        } else if (component.getName().equals("lane")) {
            String id = component.attributeValue("id");
            Element root = component.getDocument().getRootElement();
            Element shap = (Element)root.selectSingleNode("//*[@bpmnElement='" + id + "']");
            String isHorizontal = shap.attributeValue("isHorizontal");
            retVal = isHorizontal != null && isHorizontal.equalsIgnoreCase("false") ? BPMNShapType.VLane : BPMNShapType.HLane;
        }
        return retVal;
    }

    static {
        graphDrawInstructions.put(BPMNShapType.StartEvent, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawNoneStartEvent(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.ErrorEvent, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawErrorEndEvent(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.EndEvent, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawNoneEndEvent(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.CancelEvent, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawErrorEndEvent(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.Task, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.UserTask, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawUserTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor, shap);
            }
        });
        graphDrawInstructions.put(BPMNShapType.ScriptTask, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawScriptTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.ServiceTask, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawServiceTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.ReceiveTask, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawReceiveTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.SendTask, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawSendTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.ManualTask, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawManualTask(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.ExclusiveGateway, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawExclusiveGateway(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.InclusiveGateway, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawInclusiveGateway(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.ParallelGateway, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawParallelGateway(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()), highLightColor);
            }
        });
        graphDrawInstructions.put(BPMNShapType.SubProcess, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                if (shap.isExpanded() != null && !shap.isExpanded().booleanValue()) {
                    processDiagramCanvas.drawCollapsedSubProcess(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
                } else {
                    processDiagramCanvas.drawExpandedSubProcess(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
                }
            }
        });
        graphDrawInstructions.put(BPMNShapType.CallActivity, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawCollapsedCallActivity(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.HPool, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawHPool(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.HLane, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawHLane(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.VPool, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawVPool(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
        graphDrawInstructions.put(BPMNShapType.VLane, new GraphDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCanvas, BPMNShap shap, String highLightColor) {
                processDiagramCanvas.drawVLane(shap.getName(), (int)Math.round(shap.getX()), (int)Math.round(shap.getY()), (int)Math.round(shap.getWidth()), (int)Math.round(shap.getHeight()));
            }
        });
    }
}

