/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.activiti.editor.constants.HtStencilConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.CallActivityJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class HtStartSubFlowTaskJsonConverter
extends CallActivityJsonConverter
implements HtStencilConstants {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        HtStartSubFlowTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        HtStartSubFlowTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("StartSubFlowTask", HtStartSubFlowTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, HtStartSubFlowTaskJsonConverter.class);
    }

    protected String getStencilId(BaseElement baseElement) {
        return "StartSubFlowTask";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        CallActivity callActivity = (CallActivity)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            propertiesNode.put("callactivitycalledelement", callActivity.getCalledElement());
        }
        this.handleAddJsonParameters("callactivityinparameters", "inParameters", callActivity.getInParameters(), propertiesNode);
        this.handleAddJsonParameters("callactivityoutparameters", "outParameters", callActivity.getOutParameters(), propertiesNode);
    }

    private void handleAddJsonParameters(String propertyName, String valueName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSource())) {
                parameterItemNode.put("source", parameter.getSource());
            } else {
                parameterItemNode.putNull("source");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                parameterItemNode.put("target", parameter.getTarget());
            } else {
                parameterItemNode.putNull("target");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                parameterItemNode.put("sourceExpression", parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull("sourceExpression");
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.set(valueName, (JsonNode)itemsNode);
        propertiesNode.set(propertyName, (JsonNode)parametersNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        CallActivity callActivity = new CallActivity();
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("callactivitycalledelement", elementNode))) {
            callActivity.setCalledElement(this.getPropertyValueAsString("callactivitycalledelement", elementNode));
        }
        callActivity.getInParameters().addAll(this.handleConvertToIOParameters("callactivityinparameters", "inParameters", elementNode));
        callActivity.getOutParameters().addAll(this.handleConvertToIOParameters("callactivityoutparameters", "outParameters", elementNode));
        return callActivity;
    }

    private List<IOParameter> handleConvertToIOParameters(String propertyName, String valueName, JsonNode elementNode) {
        JsonNode itemsArrayNode;
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        JsonNode parametersNode = this.getProperty(propertyName, elementNode);
        if (parametersNode != null && (itemsArrayNode = (parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)parametersNode)).get(valueName)) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode sourceNode = itemNode.get("source");
                JsonNode sourceExpressionNode = itemNode.get("sourceExpression");
                if ((sourceNode == null || !StringUtils.isNotEmpty((CharSequence)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((CharSequence)sourceExpressionNode.asText()))) continue;
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("source", itemNode))) {
                    parameter.setSource(this.getValueAsString("source", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("sourceExpression", itemNode))) {
                    parameter.setSourceExpression(this.getValueAsString("sourceExpression", itemNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("target", itemNode))) {
                    parameter.setTarget(this.getValueAsString("target", itemNode));
                }
                ioParameters.add(parameter);
            }
        }
        return ioParameters;
    }
}

