/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.ext.model;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmTaskService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class BpmDelegateTaskImpl
implements BpmDelegateTask {
    private List<BpmIdentity> list = new ArrayList<BpmIdentity>();
    private TaskEntity task = null;
    private BpmTaskService bpmTaskService;

    public void setDelegateTask(DelegateTask delegateTask) {
        this.task = (TaskEntity)delegateTask;
    }

    public Map<String, Object> getVariables() {
        return this.task.getVariables();
    }

    public Map<String, Object> getVariablesLocal() {
        return this.task.getVariablesLocal();
    }

    public Object getVariable(String variableName) {
        return this.task.getVariable(variableName);
    }

    public Object getVariableLocal(String variableName) {
        return this.task.getVariableLocal(variableName);
    }

    public Set<String> getVariableNames() {
        return this.task.getVariableNames();
    }

    public Set<String> getVariableNamesLocal() {
        return this.task.getVariableNamesLocal();
    }

    public void setVariable(String variableName, Object value) {
        this.task.setVariable(variableName, value);
    }

    public Object setVariableLocal(String variableName, Object value) {
        return this.task.setVariableLocal(variableName, value);
    }

    public void setVariables(Map<String, ? extends Object> variables) {
        this.task.setVariables(variables);
    }

    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        this.task.setVariablesLocal(variables);
    }

    public boolean hasVariables() {
        return this.task.hasVariables();
    }

    public boolean hasVariablesLocal() {
        return this.task.hasVariablesLocal();
    }

    public boolean hasVariable(String variableName) {
        return this.task.hasVariable(variableName);
    }

    public boolean hasVariableLocal(String variableName) {
        return this.task.hasVariableLocal(variableName);
    }

    public void createVariableLocal(String variableName, Object value) {
        this.task.createVariableLocal(variableName, value);
    }

    public void removeVariable(String variableName) {
        this.task.removeVariable(variableName);
    }

    public void removeVariableLocal(String variableName) {
        this.task.removeVariableLocal(variableName);
    }

    public void removeVariables(Collection<String> variableNames) {
        this.task.removeVariables(variableNames);
    }

    public void removeVariablesLocal(Collection<String> variableNames) {
        this.task.removeVariablesLocal(variableNames);
    }

    public void removeVariables() {
        this.task.removeVariables();
    }

    public void removeVariablesLocal() {
        this.task.removeVariablesLocal();
    }

    public String getId() {
        return this.task.getId();
    }

    public String getName() {
        return this.task.getName();
    }

    public void setName(String name) {
        this.task.setName(name);
    }

    public String getDescription() {
        return this.task.getDescription();
    }

    public void setDescription(String description) {
        this.task.setDescription(description);
    }

    public int getPriority() {
        return this.task.getPriority();
    }

    public void setPriority(int priority) {
        this.task.setPriority(priority);
    }

    public String getProcessInstanceId() {
        return this.task.getProcessInstanceId();
    }

    public String getExecutionId() {
        return this.task.getExecutionId();
    }

    public String getBpmnDefId() {
        return this.task.getProcessDefinitionId();
    }

    public LocalDateTime getCreateTime() {
        if (BeanUtils.isNotEmpty((Object)this.task.getCreateTime())) {
            Instant instant = this.task.getCreateTime().toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            return instant.atZone(zoneId).toLocalDateTime();
        }
        return null;
    }

    public String getTaskDefinitionKey() {
        return this.task.getTaskDefinitionKey();
    }

    public String getEventName() {
        return this.task.getEventName();
    }

    public int getSuspensionState() {
        return this.task.getSuspensionState();
    }

    public LocalDateTime getDueDate() {
        if (BeanUtils.isNotEmpty((Object)this.task.getDueDate())) {
            Instant instant = this.task.getDueDate().toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            return instant.atZone(zoneId).toLocalDateTime();
        }
        return null;
    }

    public void setDueDate(LocalDateTime dueDate) {
        if (BeanUtils.isNotEmpty((Object)dueDate)) {
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zdt = dueDate.atZone(zoneId);
            this.task.setDueDate(Date.from(zdt.toInstant()));
        } else {
            this.task.setDueDate(null);
        }
    }

    public String getOwner() {
        BpmTask bpmTask = this.bpmTaskService.getByTaskId(this.task.getId());
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            throw new BaseException("\u6ca1\u6709\u627e\u5230\u4efb\u52a1\u6570\u636e");
        }
        return bpmTask.getOwnerId();
    }

    public void setOwner(String owner) {
    }

    public String getAssignee() {
        BpmTask bpmTask = this.bpmTaskService.getByTaskId(this.task.getId());
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            throw new BaseException("\u6ca1\u6709\u627e\u5230\u4efb\u52a1\u6570\u636e");
        }
        return bpmTask.getAssigneeId();
    }

    public void setAssignee(String assignee) {
    }

    public void cleanExecutor() {
        this.list.clear();
    }

    public void addExecutor(BpmIdentity bpmIdentity) {
        boolean isExist = this.isExecutorExist(bpmIdentity);
        if (isExist) {
            return;
        }
        this.list.add(bpmIdentity);
    }

    public void addExecutors(List<BpmIdentity> bpmIdentitys) {
        for (BpmIdentity bpmIdentity : bpmIdentitys) {
            this.addExecutor(bpmIdentity);
        }
    }

    public boolean isExecutorExist(BpmIdentity bpmIndentity) {
        for (BpmIdentity obj : this.list) {
            if (!obj.equals(bpmIndentity)) continue;
            return true;
        }
        return false;
    }

    public List<BpmIdentity> getExecutors() {
        return this.list;
    }

    public void delExecutor(BpmIdentity bpmIndentity) {
        this.list.remove(bpmIndentity);
    }

    public String getSupperExecutionId() {
        return this.task.getExecution().getSuperExecutionId();
    }

    public Map<String, Object> getSupperVars() {
        if (this.task.getExecution().getSuperExecution() != null) {
            return this.task.getExecution().getSuperExecution().getVariables();
        }
        return null;
    }

    public Object getSupperVariable(String varName) {
        ExecutionEntity ent = this.task.getExecution().getSuperExecution();
        if (ent != null) {
            return ent.getVariable(varName);
        }
        return null;
    }

    public MultiInstanceType supperMultiInstanceType() {
        if (this.task.getExecution().getSuperExecution() != null) {
            String multiInstance = (String)this.task.getExecution().getSuperExecution().getActivity().getProperty("multiInstance");
            if (StringUtil.isEmpty((String)multiInstance)) {
                return MultiInstanceType.NO;
            }
            return MultiInstanceType.fromKey((String)multiInstance);
        }
        return MultiInstanceType.NO;
    }

    public MultiInstanceType multiInstanceType() {
        String multiInstance = (String)this.task.getExecution().getActivity().getProperty("multiInstance");
        if (StringUtil.isEmpty((String)multiInstance)) {
            return MultiInstanceType.NO;
        }
        return MultiInstanceType.fromKey((String)multiInstance);
    }

    public Object getExecutionLocalVariable(String name) {
        return this.task.getExecution().getVariableLocal(name);
    }

    public void setExecutionLocalVariable(String name, Object obj) {
        this.task.getExecution().setVariableLocal(name, obj);
    }

    public Object getProxyObj() {
        return this.task;
    }

    public boolean isInExtSubFlow() {
        return this.task.getExecution().getSuperExecution() != null;
    }

    public String getParentExecuteId() {
        return this.task.getExecution().getParentId();
    }

    public String getParentExecuteId(int level) {
        ExecutionEntity ent = this.task.getExecution();
        for (int i = 0; i < level; ++i) {
            if ((ent = ent.getParent()) != null) continue;
            throw new RuntimeException("\u6307\u5b9a\u7ea7\u522b\u7684\u7236\u8282\u70b9\u627e\u4e0d\u5230");
        }
        return ent.getId();
    }

    public Boolean isNotEmpty() {
        return BeanUtils.isNotEmpty((Object)this.task);
    }

    public boolean isTaskEmpty() {
        return BeanUtils.isEmpty((Object)this.task);
    }

    public void setBpmTaskService(BpmTaskService bpmTaskService) {
        this.bpmTaskService = bpmTaskService;
    }
}

