/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.inst.service.impl;

import com.hotent.activiti.cmd.GetExecutionVariableCmd;
import com.hotent.activiti.cmd.GetSuperVariableCmd;
import com.hotent.activiti.def.BpmDefUtil;
import com.hotent.activiti.inst.cmd.ProcessInstanceEndCmd;
import com.hotent.activiti.util.ActivitiUtil;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.stereotype.Service;

@Service
public class ProInstanceServiceImpl
implements NatProInstanceService {
    @Resource
    RuntimeService runtimeService;
    @Resource
    ProcessEngine processEngine;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    RepositoryService repositoryService;

    public String startProcessInstance(String processDefinitionId, String businessKey, Map<String, Object> variables, String ... aryDestination) throws Exception {
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(processDefinitionId);
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getStartEvent(defId);
        String nodeId = bpmNodeDef.getNodeId();
        if (variables.containsKey("start_destiontion") && ((Boolean)variables.get("start_destiontion")).booleanValue()) {
            nodeId = ((BpmNodeDef)bpmNodeDef.getOutcomeNodes().get(0)).getNodeId();
        }
        Map<String, Object> activityMap = BpmDefUtil.prepare(processDefinitionId, nodeId, aryDestination);
        String bpmnInstId = "";
        try {
            bpmnInstId = this.startProcessInstance(processDefinitionId, businessKey, variables);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return bpmnInstId;
    }

    public String startProcessInstance(String processDefinitionId, String businessKey, Map<String, Object> variables) {
        try {
            ProcessInstance instance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, variables);
            String string = instance.getId();
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, Object> getVariables(String processInstanceId) {
        return this.runtimeService.getVariables(processInstanceId);
    }

    public void setVariable(String executionId, String variableName, Object value) {
        this.runtimeService.setVariable(executionId, variableName, value);
    }

    public void setVariableLocal(String executionId, String variableName, Object value) {
        this.runtimeService.setVariableLocal(executionId, variableName, value);
    }

    public void setVariables(String executionId, Map<String, ? extends Object> variables) {
        this.runtimeService.setVariables(executionId, variables);
    }

    public void setVariablesLocal(String executionId, Map<String, ? extends Object> variables) {
        this.runtimeService.setVariablesLocal(executionId, variables);
    }

    public void removeVariable(String executionId, String variableName) {
        this.runtimeService.removeVariable(executionId, variableName);
    }

    public void removeVariableLocal(String executionId, String variableName) {
        this.runtimeService.removeVariableLocal(executionId, variableName);
    }

    public void removeVariables(String executionId, Collection<String> variableNames) {
        this.runtimeService.removeVariables(executionId, variableNames);
    }

    public void removeVariablesLocal(String executionId, Collection<String> variableNames) {
        this.runtimeService.removeVariablesLocal(executionId, variableNames);
    }

    public boolean hasVariableLocal(String executionId, String variableName) {
        return this.runtimeService.hasVariableLocal(executionId, variableName);
    }

    public Object getVariableLocal(String executionId, String variableName) {
        CommandExecutor executor = ActivitiUtil.getCommandExecutor();
        GetExecutionVariableCmd cmd = new GetExecutionVariableCmd(executionId, variableName, true);
        return executor.execute((Command)cmd);
    }

    public boolean hasVariable(String executionId, String variableName) {
        return this.runtimeService.hasVariable(executionId, variableName);
    }

    public Object getVariable(String executionId, String variableName) {
        return this.runtimeService.getVariable(executionId, variableName);
    }

    public Map<String, Object> getVariablesLocal(String executionId, Collection<String> variableNames) {
        return this.runtimeService.getVariablesLocal(executionId);
    }

    public Map<String, Object> getVariablesLocal(String executionId) {
        return this.runtimeService.getVariablesLocal(executionId);
    }

    public Map<String, Object> getVariables(String executionId, Collection<String> variableNames) {
        return this.runtimeService.getVariables(executionId, variableNames);
    }

    public void endProcessInstance(String bpmnInstanceId) {
        ProcessEngineImpl engine = (ProcessEngineImpl)this.processEngine;
        CommandExecutor cmdExecutor = engine.getProcessEngineConfiguration().getCommandExecutor();
        cmdExecutor.execute((Command)new ProcessInstanceEndCmd(bpmnInstanceId));
    }

    public void activateProcessInstanceById(String bpmnInstanceId) {
        this.runtimeService.activateProcessInstanceById(bpmnInstanceId);
    }

    public void suspendProcessInstanceById(String bpmnInstanceId) {
        this.runtimeService.suspendProcessInstanceById(bpmnInstanceId);
    }

    public void deleteProcessInstance(String bpmnInstId, String reason) {
        this.runtimeService.deleteProcessInstance(bpmnInstId, reason);
    }

    public Object getSuperVariable(String bpmnId, String varName) {
        CommandExecutor executor = ActivitiUtil.getCommandExecutor();
        GetSuperVariableCmd cmd = new GetSuperVariableCmd(bpmnId, varName);
        return executor.execute((Command)cmd);
    }
}

