/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.listener;

import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.model.def.SubProcessStartOrEndEventModel;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.impl.BpmExeStackManagerImpl;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import javax.annotation.Resource;
import org.activiti.engine.impl.entity.GatewayUnmetJoinEventModel;
import org.activiti.engine.impl.event.GatewayUnmetJoinEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GatewayUnmetJoinEventListener
implements ApplicationListener<GatewayUnmetJoinEvent>,
Ordered {
    @Resource
    BpmExeStackManagerImpl bpmExeStackManager;
    @Resource
    NatTaskService natTaskService;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(GatewayUnmetJoinEvent ev) {
        GatewayUnmetJoinEventModel eventModel = (GatewayUnmetJoinEventModel)ev.getSource();
        String nodeId = eventModel.getActivity().getId();
        String nodeName = eventModel.getActivityExecution().getCurrentActivityName();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        DefaultBpmTask bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        if (bpmTask == null) {
            return;
        }
        if (eventModel.getFlag() != null && eventModel.getFlag().equals("ParallelMultiInstanceEnd")) {
            SubProcessStartOrEndEventModel model = (SubProcessStartOrEndEventModel)cmd.getTransitVars("SubProcessStartOrEndEventModel");
            if (model == null) {
                return;
            }
            if (model != null) {
                nodeId = model.getNodeId();
                nodeName = model.getNodeName();
            }
        }
        cmd.addTransitVars("CurrentEventType", (Object)"GatewayUnmetJoinEvent");
        cmd.addTransitVars("GatewayUnmetNoteType", (Object)eventModel.getNoteType());
    }
}

