/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.activiti.def.BpmDefUtil;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.model.BpmFreeProcessDef;
import com.hotent.bpm.persistence.dao.BpmDefinitionDao;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmCustomSignDataManager;
import com.hotent.bpm.persistence.manager.BpmDefDataManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmFreeProcessDefManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.model.BpmDefData;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.impl.event.ProcessInstanceEndEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessInstEndListener
implements ApplicationListener<ProcessInstanceEndEvent>,
Ordered {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    BpmDefDataManager bpmDefDataManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmFreeProcessDefManager bpmFreeProcessDefManager;
    @Resource
    BpmDefinitionDao bpmDefinitionDao;

    public void onApplicationEvent(ProcessInstanceEndEvent ev) {
        BpmDelegateExecution execution = (BpmDelegateExecution)ev.getSource();
        this.updProcessInstance(execution);
        Integer instCount = (Integer)execution.getSupperVariable("nrOfInstances");
        Integer completeInstCount = (Integer)execution.getSupperVariable("nrOfCompletedInstances");
        if (StringUtil.isNotZeroEmpty((String)execution.getSupperExecutionId()) && (instCount == null || instCount.equals(completeInstCount))) {
            String destination;
            Map commuVars_ = execution.getVariables();
            Map commuVars = ContextThreadUtil.getCommuVars();
            commuVars_.putAll(commuVars);
            ContextThreadUtil.setCommuVars((Map)commuVars_);
            String parentProcInstId = (String)commuVars_.get("parentInstanceId_");
            BpmDelegateExecution supperExecution = execution.getSupperExecution();
            if (BeanUtils.isNotEmpty((Object)supperExecution) && StringUtil.isNotEmpty((String)(destination = this.getDestination(parentProcInstId, supperExecution.getNodeId(), ContextThreadUtil.getActionCmd())))) {
                BpmDefUtil.prepare(supperExecution.getBpmnDefId(), supperExecution.getNodeId(), new String[]{destination});
            }
            this.converCmd(parentProcInstId);
        }
        String instId = (String)execution.getVariable("instanceId_");
        String defId = (String)execution.getVariable("processDefId_");
        String flowKey = (String)execution.getVariable("flowKey_");
        DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getMainByDefKey(flowKey);
        if (BeanUtils.isNotEmpty((Object)mainByDefKey) && BeanUtils.isNotEmpty((Object)mainByDefKey.getFlowType()) && mainByDefKey.getFlowType() == 2) {
            BpmFreeProcessDef bpmFreeProcessDef = new BpmFreeProcessDef();
            bpmFreeProcessDef.setId(defId);
            bpmFreeProcessDef.setSourceDefId(mainByDefKey.getDefId());
            bpmFreeProcessDef.setProcInstId(instId);
            BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
            bpmFreeProcessDef.setBpmnXml(bpmDefData.getBpmnXml());
            this.bpmFreeProcessDefManager.create((Model)bpmFreeProcessDef);
            this.bpmDefinitionManager.removeDefByDefId(defId);
        }
    }

    private void converCmd(String parentProcInstId) {
        BaseActionCmd baseCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        BpmProcessInstance parentProcessInst = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)parentProcInstId));
        DefaultProcessInstCmd cmd = new DefaultProcessInstCmd();
        cmd.setInstId(parentProcInstId);
        cmd.setActionName(baseCmd.getActionName());
        cmd.setBpmIdentities(baseCmd.getBpmIdentities());
        cmd.addTransitVars("processInstance", (Object)parentProcessInst);
        cmd.addTransitVars("bpmTask_", baseCmd.getTransitVars("bpmTask_"));
        cmd.addTransitVars("previous_cmd", (Object)baseCmd);
        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
    }

    private void updProcessInstance(BpmDelegateExecution execution) {
        String instId = (String)execution.getVariable("instanceId_");
        BaseActionCmd cmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        String procInstId = instance.getId();
        DefaultBpmCheckOpinion entity = BpmCheckOpinionUtil.buildBpmCheckOpinion((BpmDelegateExecution)execution, (String)instId, (Boolean)true);
        DefaultBpmTask task = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        if (BeanUtils.isNotEmpty((Object)task)) {
            entity.setParentTaskId(task.getTaskId());
        }
        this.bpmCheckOpinionManager.create((Model)entity);
        this.bpmCheckOpinionManager.archiveHistory(procInstId);
        if (StringUtil.isZeroEmpty((String)instance.getParentInstId())) {
            TodoPushUtil.updateProcessStatus((DefaultBpmProcessInstance)instance);
        }
        this.updateStatus(instance, cmd.getActionName());
        ArrayList<String> instList = new ArrayList<String>();
        instList.add(procInstId);
        this.bpmSignDataManager.delByInstList(instList);
        this.bpmCustomSignDataManager.removeByInstId(procInstId);
    }

    private void updateStatus(DefaultBpmProcessInstance instance, String actionName) {
        instance.setStatus(ProcessInstanceStatus.STATUS_END.getKey());
        instance.setDuration(this.getDuration(instance.getCreateTime()));
        instance.setResultType(actionName);
        instance.setEndTime(LocalDateTime.now());
        this.bpmProcessInstanceManager.update((Model)instance);
        TodoPushUtil.updateProcessStatus((DefaultBpmProcessInstance)instance);
    }

    private Long getDuration(LocalDateTime localDateTime) {
        Long duration = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)localDateTime);
        return duration;
    }

    public int getOrder() {
        return 1;
    }

    private String getDestination(String instId, String nodeId, Object transitVars) {
        BpmExeStackManager bpmExeStackManager = (BpmExeStackManager)AppUtil.getBean(BpmExeStackManager.class);
        BpmExeStack stack = bpmExeStackManager.getStack(instId, nodeId, null);
        if (BeanUtils.isNotEmpty((Object)stack) && StringUtil.isNotEmpty((String)stack.getTargetNode())) {
            DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)transitVars;
            cmd.setDestination(stack.getTargetNode());
            return stack.getTargetNode();
        }
        return "";
    }
}

