/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.listener;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.calendar.ICalendarService;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.TaskSignCreateEvent;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.NodeEmptyUserService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmCustomSignDataManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmSignData;
import com.hotent.bpm.persistence.model.BpmTaskDueTime;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateTask;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TaskSignCreateEventListener
implements ApplicationListener<TaskSignCreateEvent>,
Ordered {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    ICalendarService iCalendarService;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    BpmIdentityExtractService extractService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    NodeEmptyUserService nodeEmptyUserService;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(TaskSignCreateEvent event) {
        block25: {
            try {
                String executeId;
                BpmDelegateTask delegateTask = (BpmDelegateTask)event.getSource();
                DelegateTask actTask = (DelegateTask)delegateTask.getProxyObj();
                BpmTask task = BpmUtil.convertTask((BpmDelegateTask)delegateTask);
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
                    ThreadMsgUtil.addMapMsg((String)"bpmTask_", (String)delegateTask.getId());
                }
                delegateTask.setVariable("bpm_task_id_execution_id_" + task.getId(), (Object)task.getExecId());
                String instId = task.getProcInstId();
                String nodeId = task.getNodeId();
                BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(task.getProcDefId(), nodeId);
                boolean isCommonSign = true;
                String signType = null;
                Map vars = delegateTask.getVariables();
                BpmIdentity taskExecutor = (BpmIdentity)vars.get("assignee");
                if (null == taskExecutor && null != vars.get("nodeAuditor_" + task.getNodeId())) {
                    taskExecutor = this.getRejectExecutors(task, vars);
                }
                ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
                identityList.add(taskExecutor);
                if (taskExecutor != null && ExtractType.EXACT_EXACT_DELAY.equals((Object)taskExecutor.getExtractType())) {
                    identityList = this.extractService.extractBpmIdentity(identityList);
                }
                try {
                    this.bpmTaskManager.assignUser(delegateTask, identityList, (DefaultBpmTask)task);
                }
                catch (Exception e2) {
                    throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e2), (Throwable)e2);
                }
                this.addOpinion(delegateTask, identityList, instId, signType, isCommonSign);
                try {
                    this.setDueTime(delegateTask, identityList);
                }
                catch (Exception e2) {
                    throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                }
                this.bpmProStatusManager.createOrUpd(instId, delegateTask.getBpmnDefId(), delegateTask.getTaskDefinitionKey(), delegateTask.getName(), NodeStatus.PENDING);
                Integer loopCounter = (Integer)delegateTask.getVariable("loopCounter");
                Integer token_ = 0;
                if (loopCounter == null) {
                    loopCounter = 0;
                }
                if (!(loopCounter != 0 || OpinionStatus.REJECT.getKey().equals(cmd.getActionName()) && "direct".equals(cmd.getTransitVars("backHandMode")))) {
                    BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
                    if (BeanUtils.isEmpty((Object)instance)) {
                        instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
                    }
                    if (BeanUtils.isNotEmpty((Object)instance)) {
                        String[] names = new String[]{"bpm_node_users_" + nodeId, "bpm_destination_" + nodeId};
                        delegateTask.removeVariables(Arrays.asList(names));
                    }
                }
                token_ = loopCounter;
                String resultVarName = "signResult_" + delegateTask.getTaskDefinitionKey();
                MultiInstanceType instanceType = delegateTask.multiInstanceType();
                if (MultiInstanceType.PARALLEL.equals((Object)instanceType)) {
                    delegateTask.removeVariable(resultVarName);
                    executeId = delegateTask.getParentExecuteId(2);
                    if (isCommonSign) {
                        this.addSignData(task, executeId, loopCounter);
                    } else if (cmd.getTransitVars("IsDoneUnused") == null) {
                        this.bpmCustomSignDataManager.addCustomSignData(task, null);
                    }
                } else {
                    delegateTask.setVariableLocal("token_", (Object)token_);
                    if (loopCounter == 0 || cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue()) {
                        delegateTask.removeVariable(resultVarName);
                        executeId = actTask.getExecution().getParentId();
                        if (isCommonSign) {
                            this.addSignData(task, executeId);
                        }
                    }
                    if (!isCommonSign && cmd.getTransitVars("IsDoneUnused") == null) {
                        String preTaskId = null;
                        if (cmd instanceof DefaultTaskFinishCmd && loopCounter > 0) {
                            DefaultTaskFinishCmd taskFinishCmd = (DefaultTaskFinishCmd)cmd;
                            preTaskId = taskFinishCmd.getTaskId();
                        }
                        this.bpmCustomSignDataManager.addCustomSignData(task, preTaskId);
                    }
                }
                cmd.addTransitVars("SubProcessMultiStartOrEndEvent", null);
                String subject = (String)delegateTask.getVariable("subject_");
                TodoPushUtil.addTodoToPortal((BpmDelegateTask)delegateTask, (String)instId, (String)subject);
                this.signTaskCreateHandleEmptyUser(bpmNodeDef, delegateTask);
                try {
                    BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
                    List users = bpmIdentityExtractService.extractUser(identityList);
                    if (BeanUtils.isNotEmpty((Object)users)) {
                        DefaultBpmTask defaultTask = BpmUtil.convertTask((DefaultBpmTask)((DefaultBpmTask)task), (String)task.getParentId(), (TaskType)TaskType.NORMAL, (IUser)((IUser)users.get(0)));
                        BpmUtil.restfulPluginExecut((DefaultBpmTask)defaultTask, (EventType)EventType.TASK_CREATE_EVENT);
                        break block25;
                    }
                    BpmUtil.restfulPluginExecut((DefaultBpmTask)((DefaultBpmTask)task), (EventType)EventType.TASK_CREATE_EVENT);
                }
                catch (Exception e) {
                    System.out.println("\u4f1a\u7b7erestful\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            catch (Exception e3) {
                throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e3));
            }
        }
    }

    private void signTaskCreateHandleEmptyUser(BpmNodeDef bpmNodeDef, BpmDelegateTask delegateTask) {
        String emptyUserExecutionId;
        String executionId = delegateTask.getExecutionId();
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)executionId), (String)"executionId\u4e0d\u80fd\u4e3a\u7a7a");
        Object emptyUserExecutionIdObj = ContextThreadUtil.getCommuVar((String)"sign_task_create_handle_empty_user", null);
        if (BeanUtils.isNotEmpty((Object)emptyUserExecutionIdObj) && emptyUserExecutionIdObj instanceof String && executionId.equals(emptyUserExecutionId = emptyUserExecutionIdObj.toString())) {
            this.nodeEmptyUserService.handleByBpmNodeDef(bpmNodeDef, delegateTask);
        }
    }

    private BpmIdentity getRejectExecutors(BpmTask task, Map<String, Object> vars) throws Exception {
        BpmIdentity taskExecutor = null;
        String accounts = vars.get("nodeAuditor_" + task.getNodeId()).toString();
        if (!accounts.contains(",")) {
            String executorAccount = vars.get("nodeAuditor_" + task.getNodeId()).toString();
            IUser iuser = this.userServiceImpl.getUserByAccount(executorAccount);
            if (BeanUtils.isNotEmpty((Object)iuser)) {
                taskExecutor = DefaultBpmIdentity.getIdentityByUserId((String)iuser.getUserId(), (String)iuser.getFullname());
            }
        } else {
            List opinions = this.bpmCheckOpinionManager.getByInstNodeIdStatus(task.getProcInstId(), task.getNodeId(), (Object)OpinionStatus.REJECT);
            if (BeanUtils.isNotEmpty((Object)opinions) && StringUtil.isNotEmpty((String)((DefaultBpmCheckOpinion)opinions.get(0)).getQualfieds())) {
                String qualfieds = ((DefaultBpmCheckOpinion)opinions.get(opinions.size() - 1)).getQualfieds();
                ArrayNode users = (ArrayNode)JsonUtil.toJsonNode((String)qualfieds);
                taskExecutor = (BpmIdentity)JsonUtil.toBean((JsonNode)users.get(0), DefaultBpmIdentity.class);
            }
        }
        return taskExecutor;
    }

    private void addOpinion(BpmDelegateTask delegateTask, List<BpmIdentity> identityList, String instId, String signType, boolean isCommonSign) {
        String id;
        DefaultBpmCheckOpinion defaultBpmCheckOpinion;
        Map variables;
        DefaultBpmCheckOpinion opinion = BpmCheckOpinionUtil.buildBpmCheckOpinion((BpmDelegateTask)delegateTask, (String)instId);
        opinion.setSignType(signType);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (isCommonSign && (variables = cmd.getVariables()).containsKey("pre_bpm_check_opinion_id") && BeanUtils.isNotEmpty(variables.get("pre_bpm_check_opinion_id")) && BeanUtils.isNotEmpty((Object)(defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)(id = String.valueOf(variables.get("pre_bpm_check_opinion_id"))))))) && StringUtil.isNotEmpty((String)defaultBpmCheckOpinion.getSignType())) {
            opinion.setSignType("AfterSign");
        }
        if (cmd instanceof TaskFinishCmd) {
            opinion.setParentTaskId(((TaskFinishCmd)cmd).getTaskId());
        }
        String ids = BpmCheckOpinionUtil.getIdentityIds(identityList);
        String names = BpmCheckOpinionUtil.getIdentityNames(identityList);
        opinion.setQualfieds(ids);
        opinion.setQualfiedNames(names);
        this.bpmCheckOpinionManager.create((Model)opinion);
    }

    private void addSignData(BpmTask bpmTask, String executeId, Integer index) {
        String nodeId = bpmTask.getNodeId();
        BaseActionCmd actionCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        List idList = (List)actionCmd.getBpmIdentities().get(nodeId);
        if (BeanUtils.isEmpty((Object)idList)) {
            return;
        }
        BpmIdentity bpmIdentity = (BpmIdentity)idList.get(index);
        BpmSignData signData = this.bpmSignDataManager.getSignData(bpmTask, executeId, bpmIdentity);
        signData.setIndex(Short.valueOf(index.shortValue()));
        signData.setIdentityType(bpmIdentity.getGroupType());
        this.bpmSignDataManager.create((Model)signData);
    }

    private void addSignData(BpmTask bpmTask, String executeId) {
        String nodeId = bpmTask.getNodeId();
        BaseActionCmd actionCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        List idList = (List)actionCmd.getBpmIdentities().get(nodeId);
        if (BeanUtils.isEmpty((Object)idList)) {
            return;
        }
        for (short i = 0; i < idList.size(); i = (short)(i + 1)) {
            BpmIdentity bpmIdentity = (BpmIdentity)idList.get(i);
            BpmSignData signData = this.bpmSignDataManager.getSignData(bpmTask, executeId, bpmIdentity);
            signData.setIndex(Short.valueOf(i));
            signData.setIdentityType(bpmIdentity.getGroupType());
            this.bpmSignDataManager.create((Model)signData);
        }
    }

    private void setDueTime(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) throws Exception {
        BpmIdentity bpmIdentity;
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(delegateTask.getId());
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
        BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(bpmTask.getProcDefId());
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        NodeProperties nodeProperties = bpmNodeDef.getLocalProperties();
        LocalDateTime dueTime = null;
        String userId = "";
        String userName = "";
        int dueTimeMin = 0;
        String dateTpye = "";
        if (nodeProperties.getDueTime() != 0) {
            dueTimeMin = nodeProperties.getDueTime();
            dateTpye = nodeProperties.getDateType();
        } else {
            dueTimeMin = defExt.getExtProperties().getDueTime();
            dateTpye = defExt.getExtProperties().getDateType();
        }
        if (dueTimeMin == 0) {
            return;
        }
        if ("caltime".equals(dateTpye)) {
            dueTime = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)dueTimeMin, (long)TimeUtil.getTimeMillis((LocalDateTime)bpmTask.getCreateTime())));
        } else if (BeanUtils.isNotEmpty(identityList) && "user".equals((bpmIdentity = identityList.get(0)).getType())) {
            userId = bpmIdentity.getId();
            userName = bpmIdentity.getName();
            dueTime = this.iCalendarService.getEndTimeByUser(identityList.get(0).getId(), bpmTask.getCreateTime(), (long)dueTimeMin);
        }
        bpmTask.setDueTime(dueTime);
        this.bpmTaskManager.update((Model)bpmTask);
        BpmTaskDueTime bpmTaskDueTime = new BpmTaskDueTime();
        bpmTaskDueTime.setId(UniqueIdUtil.getSuid());
        bpmTaskDueTime.setDateType(dateTpye);
        bpmTaskDueTime.setDueTime(dueTimeMin);
        bpmTaskDueTime.setRemainingTime(dueTimeMin);
        bpmTaskDueTime.setExpirationDate(dueTime);
        bpmTaskDueTime.setInstId(bpmTask.getProcInstId());
        bpmTaskDueTime.setTaskId(bpmTask.getTaskId());
        bpmTaskDueTime.setStartTime(bpmTask.getCreateTime());
        bpmTaskDueTime.setUserId(userId);
        bpmTaskDueTime.setUserName(userName);
        bpmTaskDueTime.setIsNew(Short.valueOf((short)1));
        bpmTaskDueTime.setStatus(Short.valueOf((short)0));
        this.bpmTaskDueTimeManager.create((Model)bpmTaskDueTime);
    }
}

