/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.def.graph;

import com.hotent.activiti.cmd.GenFlowColorImageCmd;
import com.hotent.activiti.cmd.GenFlowImageCmd;
import com.hotent.activiti.util.ActivitiUtil;
import com.hotent.bpm.natapi.graph.NatProcessImageService;
import com.hotent.i18n.util.I18nUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class FlowImageService
implements NatProcessImageService {
    public InputStream getProcessImageByBpmnXml(String bpmnXml) {
        CommandExecutor commandExecutor = ActivitiUtil.getCommandExecutor();
        InputStream inputStream = (InputStream)commandExecutor.execute((Command)new GenFlowImageCmd(bpmnXml));
        return inputStream;
    }

    public InputStream getProcessImageByBpmnXml(String bpmnXml, Map<String, String> colorMap) {
        CommandExecutor commandExecutor = ActivitiUtil.getCommandExecutor();
        bpmnXml = this.xmlToI18(bpmnXml);
        InputStream inputStream = (InputStream)commandExecutor.execute((Command)new GenFlowColorImageCmd(bpmnXml, colorMap));
        return inputStream;
    }

    private String xmlToI18(String bpmnXml) {
        Locale locale = LocaleContextHolder.getLocale();
        if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            return bpmnXml;
        }
        try {
            Document document = DocumentHelper.parseText((String)bpmnXml);
            Element rootElement = document.getRootElement();
            Element process = rootElement.element("process");
            String defkey = process.attributeValue("id");
            this.getAndSetNodeI18n("userTask", process, defkey, locale);
            this.getAndSetNodeI18n("exclusiveGateway", process, defkey, locale);
            this.getAndSetNodeI18n("sequenceFlow", process, defkey, locale);
            this.getAndSetNodeI18n("serviceTask", process, defkey, locale);
            this.getAndSetNodeI18n("callActivity", process, defkey, locale);
            this.getAndSetNodeI18n("subProcess", process, defkey, locale);
            this.getAndSetNodeI18n("inclusiveGateway", process, defkey, locale);
            this.getAndSetNodeI18n("parallelGateway", process, defkey, locale);
            bpmnXml = document.asXML();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return bpmnXml;
        }
        return bpmnXml;
    }

    private void getAndSetNodeI18n(String nodeName, Element process, String defkey, Locale locale) {
        List elements = process.elements(nodeName);
        for (Element elm : elements) {
            String nodeId = elm.attributeValue("id");
            String key = "flow." + defkey + "." + nodeId;
            String mes = I18nUtil.getMessage((String)key, (Locale)locale);
            if (mes == null) {
                return;
            }
            if (!key.equals(mes)) {
                elm.addAttribute("name", mes);
            }
            String string = elm.getName();
        }
    }
}

