/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.activiti.editor.constants.HtStencilConstants;
import com.hotent.activiti.editor.language.json.converter.HtAndGatewayJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtCustomSignTaskJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtEndEventJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtMessageTaskJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtOrGatewayJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtScriptTaskJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtSignTaskJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtStartEventJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtStartSubFlowTaskJsonConverter;
import com.hotent.activiti.editor.language.json.converter.HtXorGatewayJsonConverter;
import com.hotent.base.util.BeanUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.line.Line2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.polygon.Polyline2D;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.MessageFlow;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.AssociationJsonConverter;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BoundaryEventJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.BusinessRuleTaskJsonConverter;
import org.activiti.editor.language.json.converter.CallActivityJsonConverter;
import org.activiti.editor.language.json.converter.CamelTaskJsonConverter;
import org.activiti.editor.language.json.converter.CatchEventJsonConverter;
import org.activiti.editor.language.json.converter.DataStoreJsonConverter;
import org.activiti.editor.language.json.converter.EndEventJsonConverter;
import org.activiti.editor.language.json.converter.EventGatewayJsonConverter;
import org.activiti.editor.language.json.converter.EventSubProcessJsonConverter;
import org.activiti.editor.language.json.converter.ExclusiveGatewayJsonConverter;
import org.activiti.editor.language.json.converter.InclusiveGatewayJsonConverter;
import org.activiti.editor.language.json.converter.MailTaskJsonConverter;
import org.activiti.editor.language.json.converter.ManualTaskJsonConverter;
import org.activiti.editor.language.json.converter.MessageFlowJsonConverter;
import org.activiti.editor.language.json.converter.MuleTaskJsonConverter;
import org.activiti.editor.language.json.converter.ParallelGatewayJsonConverter;
import org.activiti.editor.language.json.converter.ReceiveTaskJsonConverter;
import org.activiti.editor.language.json.converter.SendTaskJsonConverter;
import org.activiti.editor.language.json.converter.SequenceFlowJsonConverter;
import org.activiti.editor.language.json.converter.ServiceTaskJsonConverter;
import org.activiti.editor.language.json.converter.StartEventJsonConverter;
import org.activiti.editor.language.json.converter.SubProcessJsonConverter;
import org.activiti.editor.language.json.converter.TextAnnotationJsonConverter;
import org.activiti.editor.language.json.converter.ThrowEventJsonConverter;
import org.activiti.editor.language.json.converter.UserTaskJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.editor.language.json.converter.util.JsonConverterUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtBpmnJsonConverter
implements EditorJsonConstants,
StencilConstants,
ActivityProcessor,
HtStencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HtBpmnJsonConverter.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected static Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap = new HashMap<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>>();
    protected static Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap = new HashMap<String, Class<? extends BaseBpmnJsonConverter>>();
    public static final String MODELER_NAMESPACE = "http://activiti.com/modeler";
    protected final DateFormat defaultFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected final DateFormat entFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final List<String> DI_CIRCLES;
    private static final List<String> DI_RECTANGLES;
    private static final List<String> DI_GATEWAY;

    public ObjectNode convertToJson(BpmnModel model) {
        GraphicInfo graphicInfo;
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        double maxX = 0.0;
        double maxY = 0.0;
        for (GraphicInfo flowInfo : model.getLocationMap().values()) {
            if (flowInfo.getX() + flowInfo.getWidth() > maxX) {
                maxX = flowInfo.getX() + flowInfo.getWidth();
            }
            if (!(flowInfo.getY() + flowInfo.getHeight() > maxY)) continue;
            maxY = flowInfo.getY() + flowInfo.getHeight();
        }
        maxX += 50.0;
        maxY += 50.0;
        if (maxX < 1485.0) {
            maxX = 1485.0;
        }
        if (maxY < 700.0) {
            maxY = 700.0;
        }
        modelNode.set("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode((double)maxX, (double)maxY, (double)0.0, (double)0.0));
        modelNode.put("resourceId", "canvas");
        ObjectNode stencilNode = this.objectMapper.createObjectNode();
        stencilNode.put("id", "BPMNDiagram");
        modelNode.set("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = this.objectMapper.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        stencilsetNode.put("url", "../editor/stencilsets/bpmn2.0/bpmn2.0.json");
        modelNode.set("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = this.objectMapper.createArrayNode();
        Process mainProcess = null;
        mainProcess = model.getPools().size() > 0 ? model.getProcess(((Pool)model.getPools().get(0)).getId()) : model.getMainProcess();
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getId())) {
            propertiesNode.put("process_id", mainProcess.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getName())) {
            propertiesNode.put("name", mainProcess.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getDocumentation())) {
            propertiesNode.put("documentation", mainProcess.getDocumentation());
        }
        if (!mainProcess.isExecutable()) {
            propertiesNode.put("process_executable", "No");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{model.getTargetNamespace()})) {
            propertiesNode.put("process_namespace", model.getTargetNamespace());
        }
        BpmnJsonConverterUtil.convertMessagesToJson((Collection)model.getMessages(), (ObjectNode)propertiesNode);
        BpmnJsonConverterUtil.convertListenersToJson((List)mainProcess.getExecutionListeners(), (boolean)true, (ObjectNode)propertiesNode);
        BpmnJsonConverterUtil.convertEventListenersToJson((List)mainProcess.getEventListeners(), (ObjectNode)propertiesNode);
        BpmnJsonConverterUtil.convertSignalDefinitionsToJson((BpmnModel)model, (ObjectNode)propertiesNode);
        BpmnJsonConverterUtil.convertMessagesToJson((BpmnModel)model, (ObjectNode)propertiesNode);
        if (CollectionUtils.isNotEmpty((Collection)mainProcess.getDataObjects())) {
            BpmnJsonConverterUtil.convertDataPropertiesToJson((List)mainProcess.getDataObjects(), (ObjectNode)propertiesNode);
        }
        modelNode.set("properties", (JsonNode)propertiesNode);
        boolean poolHasDI = false;
        if (model.getPools().size() > 0) {
            for (Pool pool : model.getPools()) {
                graphicInfo = model.getGraphicInfo(pool.getId());
                if (graphicInfo == null) continue;
                poolHasDI = true;
                break;
            }
        }
        if (model.getPools().size() > 0 && poolHasDI) {
            for (Pool pool : model.getPools()) {
                graphicInfo = model.getGraphicInfo(pool.getId());
                if (graphicInfo == null) continue;
                ObjectNode poolNode = BpmnJsonConverterUtil.createChildShape((String)pool.getId(), (String)"Pool", (double)(graphicInfo.getX() + graphicInfo.getWidth()), (double)(graphicInfo.getY() + graphicInfo.getHeight()), (double)graphicInfo.getX(), (double)graphicInfo.getY());
                shapesArrayNode.add((JsonNode)poolNode);
                ObjectNode poolPropertiesNode = this.objectMapper.createObjectNode();
                poolPropertiesNode.put("overrideid", pool.getId());
                poolPropertiesNode.put("process_id", pool.getProcessRef());
                if (!pool.isExecutable()) {
                    poolPropertiesNode.put("process_executable", "No");
                }
                if (StringUtils.isNotEmpty((CharSequence)pool.getName())) {
                    poolPropertiesNode.put("name", pool.getName());
                }
                poolNode.set("properties", (JsonNode)poolPropertiesNode);
                ArrayNode laneShapesArrayNode = this.objectMapper.createArrayNode();
                poolNode.set("childShapes", (JsonNode)laneShapesArrayNode);
                ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
                poolNode.set("outgoing", (JsonNode)outgoingArrayNode);
                Process process = model.getProcess(pool.getId());
                if (process != null) {
                    HashMap<String, ArrayNode> laneMap = new HashMap<String, ArrayNode>();
                    for (Lane lane : process.getLanes()) {
                        GraphicInfo laneGraphicInfo = model.getGraphicInfo(lane.getId());
                        if (laneGraphicInfo == null) continue;
                        ObjectNode laneNode = BpmnJsonConverterUtil.createChildShape((String)lane.getId(), (String)"Lane", (double)(laneGraphicInfo.getX() + laneGraphicInfo.getWidth()), (double)(laneGraphicInfo.getY() + laneGraphicInfo.getHeight()), (double)laneGraphicInfo.getX(), (double)laneGraphicInfo.getY());
                        laneShapesArrayNode.add((JsonNode)laneNode);
                        ObjectNode lanePropertiesNode = this.objectMapper.createObjectNode();
                        lanePropertiesNode.put("overrideid", lane.getId());
                        if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                            lanePropertiesNode.put("name", lane.getName());
                        }
                        laneNode.set("properties", (JsonNode)lanePropertiesNode);
                        ArrayNode elementShapesArrayNode = this.objectMapper.createArrayNode();
                        laneNode.set("childShapes", (JsonNode)elementShapesArrayNode);
                        laneNode.set("outgoing", (JsonNode)this.objectMapper.createArrayNode());
                        laneMap.put(lane.getId(), elementShapesArrayNode);
                    }
                    for (FlowElement flowElement : process.getFlowElements()) {
                        Lane laneForElement = null;
                        GraphicInfo laneGraphicInfo = null;
                        FlowElement lookForElement = null;
                        if (flowElement instanceof SequenceFlow) {
                            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                            lookForElement = model.getFlowElement(sequenceFlow.getSourceRef());
                        } else {
                            lookForElement = flowElement;
                        }
                        for (Lane lane : process.getLanes()) {
                            if (!lane.getFlowReferences().contains(lookForElement.getId())) continue;
                            laneGraphicInfo = model.getGraphicInfo(lane.getId());
                            if (laneGraphicInfo == null) break;
                            laneForElement = lane;
                            break;
                        }
                        if (!(flowElement instanceof SequenceFlow) || laneForElement == null) continue;
                        this.processFlowElement(flowElement, (FlowElementsContainer)process, model, (ArrayNode)laneMap.get(laneForElement.getId()), laneGraphicInfo.getX(), laneGraphicInfo.getY());
                    }
                    this.processArtifacts((FlowElementsContainer)process, model, shapesArrayNode, 0.0, 0.0);
                }
                for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                    if (!messageFlow.getSourceRef().equals(pool.getId())) continue;
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode((String)messageFlow.getId()));
                }
            }
            this.processMessageFlows(model, shapesArrayNode);
        } else {
            this.processFlowElements((FlowElementsContainer)model.getMainProcess(), model, shapesArrayNode, 0.0, 0.0);
            this.processMessageFlows(model, shapesArrayNode);
        }
        modelNode.set("childShapes", (JsonNode)shapesArrayNode);
        return modelNode;
    }

    public void processFlowElements(FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        for (FlowElement flowElement : container.getFlowElements()) {
            this.processFlowElement(flowElement, container, model, shapesArrayNode, subProcessX, subProcessY);
        }
        this.processArtifacts(container, model, shapesArrayNode, subProcessX, subProcessY);
    }

    protected void processFlowElement(FlowElement flowElement, FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double containerX, double containerY) {
        Class<? extends BaseBpmnJsonConverter> converter = convertersToJsonMap.get(flowElement.getClass());
        if (converter != null) {
            try {
                converter.newInstance().convertToJson((BaseElement)flowElement, (ActivityProcessor)this, model, container, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)flowElement, (Object)e);
            }
        }
    }

    protected void processArtifacts(FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double containerX, double containerY) {
        for (Artifact artifact : container.getArtifacts()) {
            Class<? extends BaseBpmnJsonConverter> converter = convertersToJsonMap.get(artifact.getClass());
            if (converter == null) continue;
            try {
                converter.newInstance().convertToJson((BaseElement)artifact, (ActivityProcessor)this, model, container, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)artifact, (Object)e);
            }
        }
    }

    protected void processMessageFlows(BpmnModel model, ArrayNode shapesArrayNode) {
        for (MessageFlow messageFlow : model.getMessageFlows().values()) {
            MessageFlowJsonConverter jsonConverter = new MessageFlowJsonConverter();
            jsonConverter.convertToJson((BaseElement)messageFlow, (ActivityProcessor)this, model, null, shapesArrayNode, 0.0, 0.0);
        }
    }

    public BpmnModel convertToBpmnModel(JsonNode modelNode) {
        BpmnModel bpmnModel = new BpmnModel();
        bpmnModel.setTargetNamespace("http://activiti.org/test");
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        this.readShapeDI(modelNode, 0.0, 0.0, shapeMap, sourceRefMap, bpmnModel);
        this.filterAllEdges(modelNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
        this.readEdgeDI(edgeMap, sourceAndTargetMap, bpmnModel);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        if (shapesArrayNode == null || shapesArrayNode.size() == 0) {
            return bpmnModel;
        }
        boolean nonEmptyPoolFound = false;
        HashMap<String, Lane> elementInLaneMap = new HashMap<String, Lane>();
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode);
            if (!"Pool".equals(stencilId)) continue;
            Pool pool = new Pool();
            pool.setId(BpmnJsonConverterUtil.getElementId((JsonNode)shapeNode));
            pool.setName(JsonConverterUtil.getPropertyValueAsString((String)"name", (JsonNode)shapeNode));
            pool.setProcessRef(BpmnJsonConverterUtil.getPropertyValueAsString((String)"process_id", (JsonNode)modelNode));
            pool.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean((String)"process_executable", (JsonNode)shapeNode, (boolean)true));
            bpmnModel.getPools().add(pool);
            Process process = new Process();
            process.setId(BpmnJsonConverterUtil.getPropertyValueAsString((String)"process_id", (JsonNode)modelNode));
            process.setName(BpmnJsonConverterUtil.getPropertyValueAsString((String)"name", (JsonNode)modelNode));
            process.setExecutable(pool.isExecutable());
            bpmnModel.addProcess(process);
            ArrayNode laneArrayNode = (ArrayNode)shapeNode.get("childShapes");
            for (JsonNode laneNode : laneArrayNode) {
                String laneStencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)laneNode);
                if (!"Lane".equals(laneStencilId)) continue;
                nonEmptyPoolFound = true;
                Lane lane = new Lane();
                lane.setId(BpmnJsonConverterUtil.getElementId((JsonNode)laneNode));
                lane.setName(JsonConverterUtil.getPropertyValueAsString((String)"name", (JsonNode)laneNode));
                lane.setParentProcess(process);
                process.getLanes().add(lane);
                this.processJsonElements(laneNode.get("childShapes"), modelNode, (BaseElement)lane, shapeMap, bpmnModel);
                if (!CollectionUtils.isNotEmpty((Collection)lane.getFlowReferences())) continue;
                for (String elementRef : lane.getFlowReferences()) {
                    elementInLaneMap.put(elementRef, lane);
                }
            }
        }
        JsonNode signalDefinitionNode = BpmnJsonConverterUtil.getProperty((String)"signaldefinitions", (JsonNode)modelNode);
        signalDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)signalDefinitionNode);
        if ((signalDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)signalDefinitionNode)) != null && signalDefinitionNode instanceof ArrayNode) {
            ArrayNode signalDefinitionArrayNode = (ArrayNode)signalDefinitionNode;
            for (JsonNode signalDefinitionJsonNode : signalDefinitionArrayNode) {
                String signalId = signalDefinitionJsonNode.get("id").asText();
                String signalName = signalDefinitionJsonNode.get("name").asText();
                String signalScope = signalDefinitionJsonNode.get("scope").asText();
                Signal signal = new Signal();
                signal.setId(signalId);
                signal.setName(signalName);
                signal.setScope(signalScope.toLowerCase().equals("processinstance") ? "processInstance" : "global");
                bpmnModel.addSignal(signal);
            }
        }
        if (!nonEmptyPoolFound) {
            JsonNode processDataPropertiesNode;
            Iterator process = new Process();
            bpmnModel.getProcesses().add(process);
            process.setId(BpmnJsonConverterUtil.getPropertyValueAsString((String)"process_id", (JsonNode)modelNode));
            process.setName(BpmnJsonConverterUtil.getPropertyValueAsString((String)"name", (JsonNode)modelNode));
            String namespace = BpmnJsonConverterUtil.getPropertyValueAsString((String)"process_namespace", (JsonNode)modelNode);
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                bpmnModel.setTargetNamespace(namespace);
            }
            process.setDocumentation(BpmnJsonConverterUtil.getPropertyValueAsString((String)"documentation", (JsonNode)modelNode));
            JsonNode processExecutableNode = JsonConverterUtil.getProperty((String)"process_executable", (JsonNode)modelNode);
            if (processExecutableNode != null && StringUtils.isNotEmpty((CharSequence)processExecutableNode.asText())) {
                process.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean((String)"process_executable", (JsonNode)modelNode));
            }
            BpmnJsonConverterUtil.convertJsonToMessages((JsonNode)modelNode, (BpmnModel)bpmnModel);
            BpmnJsonConverterUtil.convertJsonToListeners((JsonNode)modelNode, (BaseElement)process);
            JsonNode eventListenersNode = BpmnJsonConverterUtil.getProperty((String)"eventlisteners", (JsonNode)modelNode);
            if (eventListenersNode != null) {
                eventListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)eventListenersNode);
                BpmnJsonConverterUtil.parseEventListeners((JsonNode)eventListenersNode.get("eventListeners"), (Process)process);
            }
            if ((processDataPropertiesNode = modelNode.get("properties").get("dataproperties")) != null) {
                List dataObjects = BpmnJsonConverterUtil.convertJsonToDataProperties((JsonNode)processDataPropertiesNode, (BaseElement)process);
                process.setDataObjects(dataObjects);
                process.getFlowElements().addAll(dataObjects);
            }
            this.processJsonElements((JsonNode)shapesArrayNode, modelNode, (BaseElement)process, shapeMap, bpmnModel);
        } else {
            for (Object shapeNode : shapesArrayNode) {
                String sourceRef;
                if (!"SequenceFlow".equalsIgnoreCase(BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode)) && !"Association".equalsIgnoreCase(BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode)) || (sourceRef = BpmnJsonConverterUtil.lookForSourceRef((String)shapeNode.get("resourceId").asText(), (JsonNode)modelNode.get("childShapes"))) == null) continue;
                Lane lane = (Lane)elementInLaneMap.get(sourceRef);
                SequenceFlowJsonConverter flowConverter = new SequenceFlowJsonConverter();
                if (lane != null) {
                    flowConverter.convertToBpmnModel((JsonNode)shapeNode, modelNode, (ActivityProcessor)this, (BaseElement)lane, shapeMap, bpmnModel);
                    continue;
                }
                flowConverter.convertToBpmnModel((JsonNode)shapeNode, modelNode, (ActivityProcessor)this, (BaseElement)bpmnModel.getProcesses().get(0), shapeMap, bpmnModel);
            }
            if (BeanUtils.isNotEmpty((Object)bpmnModel.getProcesses())) {
                BpmnJsonConverterUtil.convertJsonToListeners((JsonNode)modelNode, (BaseElement)((BaseElement)bpmnModel.getProcesses().get(0)));
            }
        }
        HashMap<String, SubProcess> subShapesMap = new HashMap<String, SubProcess>();
        for (Process process : bpmnModel.getProcesses()) {
            Object flowElement2;
            for (Object flowElement2 : process.findFlowElementsOfType(SubProcess.class)) {
                SubProcess subProcess = (SubProcess)flowElement2;
                this.fillSubShapes(subShapesMap, subProcess);
            }
            if (subShapesMap.size() <= 0) continue;
            ArrayList<String> removeSubFlowsList = new ArrayList<String>();
            for (FlowElement flowElement3 : process.findFlowElementsOfType(SequenceFlow.class)) {
                SubProcess subProcess;
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement3;
                if (!subShapesMap.containsKey(sequenceFlow.getSourceRef()) || (subProcess = (SubProcess)subShapesMap.get(sequenceFlow.getSourceRef())).getFlowElement(sequenceFlow.getId()) != null) continue;
                subProcess.addFlowElement((FlowElement)sequenceFlow);
                removeSubFlowsList.add(sequenceFlow.getId());
            }
            flowElement2 = removeSubFlowsList.iterator();
            while (flowElement2.hasNext()) {
                String flowId = (String)flowElement2.next();
                process.removeFlowElement(flowId);
            }
        }
        HashMap<String, FlowWithContainer> allFlowMap = new HashMap<String, FlowWithContainer>();
        ArrayList<Gateway> gatewayWithOrderList = new ArrayList<Gateway>();
        for (Process process : bpmnModel.getProcesses()) {
            this.postProcessElements((FlowElementsContainer)process, process.getFlowElements(), edgeMap, bpmnModel, allFlowMap, gatewayWithOrderList);
        }
        for (Gateway gateway : gatewayWithOrderList) {
            List orderList = (List)gateway.getExtensionElements().get("EDITOR_FLOW_ORDER");
            if (CollectionUtils.isNotEmpty((Collection)orderList)) {
                for (ExtensionElement orderElement : orderList) {
                    String flowValue = orderElement.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)flowValue) || !allFlowMap.containsKey(flowValue)) continue;
                    FlowWithContainer flowWithContainer = (FlowWithContainer)allFlowMap.get(flowValue);
                    flowWithContainer.getFlowContainer().removeFlowElement(flowWithContainer.getSequenceFlow().getId());
                    flowWithContainer.getFlowContainer().addFlowElement((FlowElement)flowWithContainer.getSequenceFlow());
                }
            }
            gateway.getExtensionElements().remove("EDITOR_FLOW_ORDER");
        }
        return bpmnModel;
    }

    public void processJsonElements(JsonNode shapesArrayNode, JsonNode modelNode, BaseElement parentElement, Map<String, JsonNode> shapeMap, BpmnModel bpmnModel) {
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode);
            Class<? extends BaseBpmnJsonConverter> converter = convertersToBpmnMap.get(stencilId);
            try {
                BaseBpmnJsonConverter converterInstance = converter.newInstance();
                converterInstance.convertToBpmnModel(shapeNode, modelNode, (ActivityProcessor)this, parentElement, shapeMap, bpmnModel);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode), (Object)e);
            }
        }
    }

    private void fillSubShapes(Map<String, SubProcess> subShapesMap, SubProcess subProcess) {
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (flowElement instanceof SubProcess) {
                SubProcess childSubProcess = (SubProcess)flowElement;
                subShapesMap.put(childSubProcess.getId(), subProcess);
                this.fillSubShapes(subShapesMap, childSubProcess);
                continue;
            }
            subShapesMap.put(flowElement.getId(), subProcess);
        }
    }

    private void postProcessElements(FlowElementsContainer parentContainer, Collection<FlowElement> flowElementList, Map<String, JsonNode> edgeMap, BpmnModel bpmnModel, Map<String, FlowWithContainer> allFlowMap, List<Gateway> gatewayWithOrderList) {
        for (FlowElement flowElement : flowElementList) {
            FlowElement targetFlowElement;
            Event event;
            if (flowElement instanceof Event && CollectionUtils.isNotEmpty((Collection)(event = (Event)flowElement).getEventDefinitions())) {
                MessageEventDefinition messageEventDef;
                EventDefinition eventDef = (EventDefinition)event.getEventDefinitions().get(0);
                if (eventDef instanceof SignalEventDefinition) {
                    SignalEventDefinition signalEventDef = (SignalEventDefinition)eventDef;
                    if (StringUtils.isNotEmpty((CharSequence)signalEventDef.getSignalRef()) && bpmnModel.getSignal(signalEventDef.getSignalRef()) == null) {
                        bpmnModel.addSignal(new Signal(signalEventDef.getSignalRef(), signalEventDef.getSignalRef()));
                    }
                } else if (eventDef instanceof MessageEventDefinition && StringUtils.isNotEmpty((CharSequence)(messageEventDef = (MessageEventDefinition)eventDef).getMessageRef()) && bpmnModel.getMessage(messageEventDef.getMessageRef()) == null) {
                    bpmnModel.addMessage(new Message(messageEventDef.getMessageRef(), messageEventDef.getMessageRef(), null));
                }
            }
            if (flowElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
                Activity activity = this.retrieveAttachedRefObject(boundaryEvent.getAttachedToRefId(), parentContainer.getFlowElements());
                if (activity == null) {
                    LOGGER.warn("Boundary event " + boundaryEvent.getId() + " is not attached to any activity");
                    continue;
                }
                boundaryEvent.setAttachedToRef(activity);
                activity.getBoundaryEvents().add(boundaryEvent);
                continue;
            }
            if (flowElement instanceof Gateway) {
                if (!flowElement.getExtensionElements().containsKey("EDITOR_FLOW_ORDER")) continue;
                gatewayWithOrderList.add((Gateway)flowElement);
                continue;
            }
            if (flowElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)flowElement;
                this.postProcessElements((FlowElementsContainer)subProcess, subProcess.getFlowElements(), edgeMap, bpmnModel, allFlowMap, gatewayWithOrderList);
                continue;
            }
            if (!(flowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            FlowElement sourceFlowElement = parentContainer.getFlowElement(sequenceFlow.getSourceRef());
            if (sourceFlowElement != null && sourceFlowElement instanceof FlowNode) {
                boolean isDefault;
                FlowWithContainer flowWithContainer = new FlowWithContainer(sequenceFlow, parentContainer);
                if (sequenceFlow.getExtensionElements().get("EDITOR_RESOURCEID") != null && ((List)sequenceFlow.getExtensionElements().get("EDITOR_RESOURCEID")).size() > 0) {
                    allFlowMap.put(((ExtensionElement)((List)sequenceFlow.getExtensionElements().get("EDITOR_RESOURCEID")).get(0)).getElementText(), flowWithContainer);
                    sequenceFlow.getExtensionElements().remove("EDITOR_RESOURCEID");
                }
                ((FlowNode)sourceFlowElement).getOutgoingFlows().add(sequenceFlow);
                JsonNode edgeNode = edgeMap.get(sequenceFlow.getId());
                if (edgeNode != null && (isDefault = JsonConverterUtil.getPropertyValueAsBoolean((String)"defaultflow", (JsonNode)edgeNode))) {
                    if (sourceFlowElement instanceof Activity) {
                        ((Activity)sourceFlowElement).setDefaultFlow(sequenceFlow.getId());
                    } else if (sourceFlowElement instanceof Gateway) {
                        ((Gateway)sourceFlowElement).setDefaultFlow(sequenceFlow.getId());
                    }
                }
            }
            if ((targetFlowElement = parentContainer.getFlowElement(sequenceFlow.getTargetRef())) == null || !(targetFlowElement instanceof FlowNode)) continue;
            ((FlowNode)targetFlowElement).getIncomingFlows().add(sequenceFlow);
        }
    }

    private Activity retrieveAttachedRefObject(String attachedToRefId, Collection<FlowElement> flowElementList) {
        Activity activity = null;
        if (StringUtils.isNotEmpty((CharSequence)attachedToRefId)) {
            for (FlowElement flowElement : flowElementList) {
                SubProcess subProcess;
                Activity retrievedActivity;
                if (attachedToRefId.equals(flowElement.getId())) {
                    activity = (Activity)flowElement;
                    break;
                }
                if (!(flowElement instanceof SubProcess) || (retrievedActivity = this.retrieveAttachedRefObject(attachedToRefId, (subProcess = (SubProcess)flowElement).getFlowElements())) == null) continue;
                activity = retrievedActivity;
                break;
            }
        }
        return activity;
    }

    private void readShapeDI(JsonNode objectNode, double parentX, double parentY, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap, BpmnModel bpmnModel) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)jsonChildNode);
                if ("SequenceFlow".equals(stencilId)) continue;
                GraphicInfo graphicInfo = new GraphicInfo();
                JsonNode boundsNode = jsonChildNode.get("bounds");
                ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
                graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
                ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
                graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX() + parentX);
                graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY() + parentY);
                String childShapeId = jsonChildNode.get("resourceId").asText();
                bpmnModel.addGraphicInfo(BpmnJsonConverterUtil.getElementId((JsonNode)jsonChildNode), graphicInfo);
                shapeMap.put(childShapeId, jsonChildNode);
                ArrayNode outgoingNode = (ArrayNode)jsonChildNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null) continue;
                        sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                    }
                }
                this.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), shapeMap, sourceRefMap, bpmnModel);
            }
        }
    }

    private void filterAllEdges(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                ObjectNode childNode = (ObjectNode)jsonChildNode;
                String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)childNode);
                if ("SubProcess".equals(stencilId)) {
                    this.filterAllEdges((JsonNode)childNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
                    continue;
                }
                if (!"SequenceFlow".equals(stencilId) && !"Association".equals(stencilId)) continue;
                String childEdgeId = BpmnJsonConverterUtil.getElementId((JsonNode)childNode);
                JsonNode targetNode = childNode.get("target");
                if (targetNode != null && !targetNode.isNull()) {
                    String targetRefId = targetNode.get("resourceId").asText();
                    ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                    sourceAndTargetList.add(sourceRefMap.get(childNode.get("resourceId").asText()));
                    sourceAndTargetList.add(shapeMap.get(targetRefId));
                    sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
                }
                edgeMap.put(childEdgeId, (JsonNode)childNode);
            }
        }
    }

    private void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, BpmnModel bpmnModel) {
        for (String edgeId : edgeMap.keySet()) {
            JsonNode edgeNode = edgeMap.get(edgeId);
            List<JsonNode> sourceAndTargetList = sourceAndTargetMap.get(edgeId);
            JsonNode sourceRefNode = null;
            JsonNode targetRefNode = null;
            if (sourceAndTargetList != null && sourceAndTargetList.size() > 1) {
                sourceRefNode = sourceAndTargetList.get(0);
                targetRefNode = sourceAndTargetList.get(1);
            }
            if (sourceRefNode == null) {
                LOGGER.info("Skipping edge {} because source ref is null", (Object)edgeId);
                continue;
            }
            if (targetRefNode == null) {
                LOGGER.info("Skipping edge {} because target ref is null", (Object)edgeId);
                continue;
            }
            JsonNode dockersNode = edgeNode.get("dockers");
            double sourceDockersX = dockersNode.get(0).get("x").asDouble();
            double sourceDockersY = dockersNode.get(0).get("y").asDouble();
            GraphicInfo sourceInfo = bpmnModel.getGraphicInfo(BpmnJsonConverterUtil.getElementId((JsonNode)sourceRefNode));
            GraphicInfo targetInfo = bpmnModel.getGraphicInfo(BpmnJsonConverterUtil.getElementId((JsonNode)targetRefNode));
            double sourceRefLineX = sourceInfo.getX() + sourceDockersX;
            double sourceRefLineY = sourceInfo.getY() + sourceDockersY;
            double nextPointInLineX = dockersNode.get(1).get("x").asDouble();
            double nextPointInLineY = dockersNode.get(1).get("y").asDouble();
            if (dockersNode.size() == 2) {
                nextPointInLineX += targetInfo.getX();
                nextPointInLineY += targetInfo.getY();
            }
            Line2D firstLine = new Line2D(sourceRefLineX, sourceRefLineY, nextPointInLineX, nextPointInLineY);
            String sourceRefStencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)sourceRefNode);
            String targetRefStencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)targetRefNode);
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            Polyline2D source2D = null;
            if (DI_CIRCLES.contains(sourceRefStencilId)) {
                source2D = new Circle2D(sourceInfo.getX() + sourceDockersX, sourceInfo.getY() + sourceDockersY, sourceDockersX);
            } else if (DI_RECTANGLES.contains(sourceRefStencilId)) {
                source2D = this.createRectangle(sourceInfo);
            } else if (DI_GATEWAY.contains(sourceRefStencilId)) {
                source2D = this.createGateway(sourceInfo);
            }
            if (source2D != null) {
                Collection intersections = source2D.intersections((LinearShape2D)firstLine);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = (Point2D)intersections.iterator().next();
                    graphicInfoList.add(this.createGraphicInfo(intersection.x(), intersection.y()));
                } else {
                    graphicInfoList.add(this.createGraphicInfo(sourceRefLineX, sourceRefLineY));
                }
            }
            Line2D lastLine = null;
            if (dockersNode.size() > 2) {
                for (int i = 1; i < dockersNode.size() - 1; ++i) {
                    double x = dockersNode.get(i).get("x").asDouble();
                    double y = dockersNode.get(i).get("y").asDouble();
                    graphicInfoList.add(this.createGraphicInfo(x, y));
                }
                double startLastLineX = dockersNode.get(dockersNode.size() - 2).get("x").asDouble();
                double startLastLineY = dockersNode.get(dockersNode.size() - 2).get("y").asDouble();
                double endLastLineX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double endLastLineY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                lastLine = new Line2D(startLastLineX, startLastLineY, endLastLineX += targetInfo.getX(), endLastLineY += targetInfo.getY());
            } else {
                lastLine = firstLine;
            }
            Polyline2D target2D = null;
            if (DI_RECTANGLES.contains(targetRefStencilId)) {
                target2D = this.createRectangle(targetInfo);
            } else if (DI_CIRCLES.contains(targetRefStencilId)) {
                double targetDockersX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double targetDockersY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                target2D = new Circle2D(targetInfo.getX() + targetDockersX, targetInfo.getY() + targetDockersY, targetDockersX);
            } else if (DI_GATEWAY.contains(targetRefStencilId)) {
                target2D = this.createGateway(targetInfo);
            }
            if (target2D != null) {
                Collection intersections = target2D.intersections((LinearShape2D)lastLine);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = (Point2D)intersections.iterator().next();
                    graphicInfoList.add(this.createGraphicInfo(intersection.x(), intersection.y()));
                } else {
                    graphicInfoList.add(this.createGraphicInfo(lastLine.getPoint2().x(), lastLine.getPoint2().y()));
                }
            }
            bpmnModel.addFlowGraphicInfoList(edgeId, graphicInfoList);
        }
    }

    private Polyline2D createRectangle(GraphicInfo graphicInfo) {
        Polyline2D rectangle = new Polyline2D(new Point2D[]{new Point2D(graphicInfo.getX(), graphicInfo.getY()), new Point2D(graphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY()), new Point2D(graphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY() + graphicInfo.getHeight()), new Point2D(graphicInfo.getX(), graphicInfo.getY() + graphicInfo.getHeight()), new Point2D(graphicInfo.getX(), graphicInfo.getY())});
        return rectangle;
    }

    private Polyline2D createGateway(GraphicInfo graphicInfo) {
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        double middleY = graphicInfo.getY() + graphicInfo.getHeight() / 2.0;
        Polyline2D gatewayRectangle = new Polyline2D(new Point2D[]{new Point2D(graphicInfo.getX(), middleY), new Point2D(middleX, graphicInfo.getY()), new Point2D(graphicInfo.getX() + graphicInfo.getWidth(), middleY), new Point2D(middleX, graphicInfo.getY() + graphicInfo.getHeight()), new Point2D(graphicInfo.getX(), middleY)});
        return gatewayRectangle;
    }

    private GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    static {
        StartEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EndEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SequenceFlowJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        MessageFlowJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        AssociationJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BusinessRuleTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        MailTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ManualTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ReceiveTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ServiceTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        UserTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CallActivityJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CamelTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        MuleTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SendTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ExclusiveGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        InclusiveGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ParallelGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EventGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SubProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EventSubProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CatchEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ThrowEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BoundaryEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        TextAnnotationJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        DataStoreJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtStartEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtSignTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtCustomSignTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtMessageTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtEndEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtStartSubFlowTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtAndGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtXorGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtOrGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        HtScriptTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        DI_CIRCLES = new ArrayList<String>();
        DI_RECTANGLES = new ArrayList<String>();
        DI_GATEWAY = new ArrayList<String>();
        DI_CIRCLES.add("StartErrorEvent");
        DI_CIRCLES.add("StartMessageEvent");
        DI_CIRCLES.add("StartNoneEvent");
        DI_CIRCLES.add("StartTimerEvent");
        DI_CIRCLES.add("StartSignalEvent");
        DI_CIRCLES.add("BoundaryErrorEvent");
        DI_CIRCLES.add("BoundarySignalEvent");
        DI_CIRCLES.add("BoundaryTimerEvent");
        DI_CIRCLES.add("BoundaryMessageEvent");
        DI_CIRCLES.add("BoundaryCancelEvent");
        DI_CIRCLES.add("BoundaryCompensationEvent");
        DI_CIRCLES.add("CatchMessageEvent");
        DI_CIRCLES.add("CatchSignalEvent");
        DI_CIRCLES.add("CatchTimerEvent");
        DI_CIRCLES.add("ThrowNoneEvent");
        DI_CIRCLES.add("ThrowSignalEvent");
        DI_CIRCLES.add("EndNoneEvent");
        DI_CIRCLES.add("EndErrorEvent");
        DI_CIRCLES.add("EndCancelEvent");
        DI_CIRCLES.add("EndTerminateEvent");
        DI_RECTANGLES.add("CallActivity");
        DI_RECTANGLES.add("SubProcess");
        DI_RECTANGLES.add("EventSubProcess");
        DI_RECTANGLES.add("BusinessRule");
        DI_RECTANGLES.add("MailTask");
        DI_RECTANGLES.add("ManualTask");
        DI_RECTANGLES.add("ReceiveTask");
        DI_RECTANGLES.add("ScriptTask");
        DI_RECTANGLES.add("SendTask");
        DI_RECTANGLES.add("ServiceTask");
        DI_RECTANGLES.add("UserTask");
        DI_RECTANGLES.add("CamelTask");
        DI_RECTANGLES.add("MuleTask");
        DI_RECTANGLES.add("TextAnnotation");
        DI_GATEWAY.add("EventGateway");
        DI_GATEWAY.add("ExclusiveGateway");
        DI_GATEWAY.add("InclusiveGateway");
        DI_GATEWAY.add("ParallelGateway");
        DI_RECTANGLES.add("SignTask");
        DI_RECTANGLES.add("CustomSignTask");
        DI_RECTANGLES.add("MessageTask");
        DI_RECTANGLES.add("StartSubFlowTask");
        DI_GATEWAY.add("XORGateway");
        DI_GATEWAY.add("ANDGateway");
        DI_GATEWAY.add("ORGateway");
        DI_CIRCLES.add("StartEvent");
        DI_CIRCLES.add("EndEvent");
    }

    class FlowWithContainer {
        protected SequenceFlow sequenceFlow;
        protected FlowElementsContainer flowContainer;

        public FlowWithContainer(SequenceFlow sequenceFlow, FlowElementsContainer flowContainer) {
            this.sequenceFlow = sequenceFlow;
            this.flowContainer = flowContainer;
        }

        public SequenceFlow getSequenceFlow() {
            return this.sequenceFlow;
        }

        public void setSequenceFlow(SequenceFlow sequenceFlow) {
            this.sequenceFlow = sequenceFlow;
        }

        public FlowElementsContainer getFlowContainer() {
            return this.flowContainer;
        }

        public void setFlowContainer(FlowElementsContainer flowContainer) {
            this.flowContainer = flowContainer;
        }
    }
}

