/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.ext.listener;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.activiti.ext.factory.BpmDelegateFactory;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.ScriptType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.plugin.core.cmd.ExecutionCommand;
import com.hotent.bpm.api.plugin.core.cmd.TaskCommand;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.exception.BusinessException;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskListener
implements TaskListener {
    private static final long serialVersionUID = -296298349312307694L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    private List<TaskCommand> taskCommands;
    private List<ExecutionCommand> executionCommands;

    public abstract EventType getBeforeTriggerEventType();

    public abstract EventType getAfterTriggerEventType();

    public abstract void beforePluginExecute(BpmDelegateTask var1) throws Exception;

    public abstract void triggerExecute(BpmDelegateTask var1);

    public abstract void afterPluginExecute(BpmDelegateTask var1);

    public void notify(DelegateTask delegateTask) {
        BpmDelegateTask task = BpmDelegateFactory.getBpmDelegateTask(delegateTask);
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        BpmProcessInstance bpmProcessInstance = (BpmProcessInstance)taskCmd.getTransitVars("processInstance");
        if (bpmProcessInstance != null && StringUtil.isNotEmpty((String)bpmProcessInstance.getSubject())) {
            task.setVariable("subject_", (Object)bpmProcessInstance.getSubject());
        }
        try {
            this.beforePluginExecute(task);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        if (this.taskCommands != null && this.getBeforeTriggerEventType() != null) {
            for (TaskCommand taskCommand : this.taskCommands) {
                try {
                    taskCommand.execute(this.getBeforeTriggerEventType(), task);
                }
                catch (Exception e) {
                    throw new BaseException(ExceptionUtil.getExceptionMessage((Throwable)e));
                }
            }
        }
        if (this.executionCommands != null && this.getBeforeTriggerEventType() != null) {
            taskCmd.getVariables().put("restful_task", task);
            for (ExecutionCommand executionCommand : this.executionCommands) {
                BpmDelegateExecution exection = BpmDelegateFactory.getBpmDelegateExecution(delegateTask.getExecution());
                if (!BeanUtils.isNotEmpty((Object)exection)) continue;
                try {
                    executionCommand.execute(this.getBeforeTriggerEventType(), BpmDelegateFactory.getBpmDelegateExecution(delegateTask.getExecution()));
                }
                catch (Exception e) {
                    throw new BaseException(ExceptionUtil.getExceptionMessage((Throwable)e));
                }
            }
        }
        this.triggerExecute(task);
        if (this.taskCommands != null && this.getAfterTriggerEventType() != null) {
            for (TaskCommand taskCommand : this.taskCommands) {
                try {
                    taskCommand.execute(this.getAfterTriggerEventType(), task);
                }
                catch (Exception e) {
                    throw new BaseException(ExceptionUtil.getExceptionMessage((Throwable)e));
                }
            }
        }
        this.afterPluginExecute(task);
        try {
            this.exeEventScript(task);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    protected abstract ScriptType getScriptType();

    private void exeEventScript(BpmDelegateTask delegateTask) throws Exception {
        String bpmnDefId = delegateTask.getBpmnDefId();
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
        String nodeId = delegateTask.getTaskDefinitionKey();
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        ScriptType scriptType = this.getScriptType();
        String script = (String)nodeDef.getScripts().get(scriptType);
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        Map vars = delegateTask.getVariables();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Map boMap = BpmContextUtil.getBoFromContext();
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(cmd.getInstId());
        if (BeanUtils.isEmpty((Object)boMap) && cmd.getDataMode().equals("bo")) {
            List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext((List)boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty((Object)boMap)) {
            HashMap newMap = new HashMap();
            for (Map.Entry next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)next.getValue()));
            }
            vars.putAll(newMap);
        }
        String creator = BeanUtils.isEmpty((Object)bpmProcessInstance) ? ContextUtil.getCurrentUser().getFullname() : bpmProcessInstance.getCreator();
        String createAccount = BeanUtils.isEmpty((Object)bpmProcessInstance) ? ContextUtil.getCurrentUser().getAccount() : bpmProcessInstance.getCreateAccount();
        vars.put("startorName", creator);
        vars.put("startUserAccount", createAccount);
        vars.put("nodeDef", nodeDef);
        vars.put("task", delegateTask);
        vars.put("cmd", cmd);
        try {
            this.groovyScriptEngine.execute(script, vars);
        }
        catch (BusinessException e) {
            throw new WorkFlowException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("\u6d41\u7a0b\u811a\u672c\u5f02\u5e38\uff1a", (Throwable)e);
            StringBuffer sb = new StringBuffer();
            sb.append("<br/><br/>\u6d41\u7a0b\u5728\u8282\u70b9\uff1a" + nodeDef.getName() + "(" + nodeDef.getNodeId() + ")\u6267\u884c" + scriptType.getValue() + "\u65f6\u51fa\u73b0\u5f02\u5e38\u60c5\u51b5\uff01");
            sb.append("<br/>\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            sb.append("<br/>\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
            sb.append("<br/>\u6267\u884c\u811a\u672c\u4e3a\uff1a" + script);
            sb.append("\u811a\u672c\u53d8\u91cf\uff1a" + vars.toString());
            String errorMsg = "\u6d41\u7a0b\u5728\u8282\u70b9\u3010" + nodeDef.getName() + "(" + nodeDef.getNodeId() + ")\u3011\u6267\u884c" + scriptType.getValue() + "\u65f6\u51fa\u73b0\u5f02\u5e38\u60c5\u51b5\uff01\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a" + e.getMessage();
            ThreadMsgUtil.addMapMsg((String)"msg_flow_error", (String)errorMsg);
            throw new WorkFlowException(sb.toString(), (Throwable)new RuntimeException(errorMsg));
        }
    }

    public List<TaskCommand> getTaskCommands() {
        return this.taskCommands;
    }

    public void setTaskCommands(List<TaskCommand> taskCommands) {
        this.taskCommands = taskCommands;
    }

    public List<ExecutionCommand> getExecutionCommands() {
        return this.executionCommands;
    }

    public void setExecutionCommands(List<ExecutionCommand> executionCommands) {
        this.executionCommands = executionCommands;
    }
}

