/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.ext.listener;

import com.hotent.base.exception.WorkFlowException;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.event.PushStackEvent;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.model.ActTask;
import com.hotent.bpm.persistence.model.PushStackModel;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PushStackEventListener
implements ApplicationListener<PushStackEvent>,
Ordered {
    protected static final Logger logger = LoggerFactory.getLogger(PushStackEventListener.class);
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    NatProInstanceService natProInstanceService;

    public int getOrder() {
        return 0;
    }

    public void onApplicationEvent(PushStackEvent event) {
        try {
            PushStackModel model = (PushStackModel)event.getSource();
            ActTask actTask = model.getActTask();
            BpmTask bpmTask = model.getBpmTask();
            if (actTask == null) {
                return;
            }
            String token = String.valueOf(this.natProInstanceService.getVariable(actTask.getExecutionId(), "token_"));
            this.bpmExeStackManager.pushStack(bpmTask.getProcDefId(), token, bpmTask.getProcInstId(), bpmTask.getNodeId(), MultiInstanceType.PARALLEL, bpmTask);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6dfb\u52a0\u5806\u6808\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new WorkFlowException("\u6dfb\u52a0\u5806\u6808\u6570\u636e\u5931\u8d25");
        }
    }
}

