/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.ext.listener;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.activiti.ext.listener.AbstractExecutionListener;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.ScriptType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.MultiInstanceDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.model.def.SubProcessStartOrEndEventModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class SubProcessEndListener
extends AbstractExecutionListener {
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    private GroovyScriptEngine groovyScriptEngine;
    @Resource
    private BpmDefinitionAccessor bpmDefinitionAccessor;
    private static final long serialVersionUID = -968956129657422689L;

    @Override
    public EventType getBeforeTriggerEventType() {
        return null;
    }

    @Override
    public EventType getAfterTriggerEventType() {
        return null;
    }

    @Override
    public void beforePluginExecute(BpmDelegateExecution bpmDelegateExecution) {
    }

    @Override
    public void triggerExecute(BpmDelegateExecution bpmDelegateExecution) {
    }

    @Override
    public void afterPluginExecute(BpmDelegateExecution bpmDelegateExecution) throws Exception {
        String bpmnDefId = bpmDelegateExecution.getBpmnDefId();
        String nodeId = bpmDelegateExecution.getNodeId();
        BpmNodeDef nodeDef = this.bpmDefinitionService.getBpmNodeDef(bpmnDefId, nodeId);
        this.exeEventScript(bpmDelegateExecution);
        if (!(nodeDef instanceof MultiInstanceDef)) {
            return;
        }
        MultiInstanceDef multiNodeDef = (MultiInstanceDef)nodeDef;
        if (multiNodeDef.supportMuliInstance() && !multiNodeDef.isParallel()) {
            Integer nrOfInstances = (Integer)bpmDelegateExecution.getVariable("nrOfInstances");
            Integer nrOfCompletedInstances = (Integer)bpmDelegateExecution.getVariable("nrOfCompletedInstances");
            if (BeanUtils.isNotEmpty((Object)nrOfInstances) && !nrOfInstances.equals(nrOfCompletedInstances)) {
                return;
            }
            String varName = "signUsers_" + bpmDelegateExecution.getNodeId();
            bpmDelegateExecution.removeVariable(varName);
        }
    }

    @Override
    protected ScriptType getScriptType() {
        return ScriptType.END;
    }

    private void exeEventScript(BpmDelegateExecution bpmDelegateExecution) throws Exception {
        String bpmnDefId = bpmDelegateExecution.getBpmnDefId();
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
        String nodeId = bpmDelegateExecution.getNodeId();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Object objModel = cmd.getTransitVars("SubProcessStartOrEndEventModel");
        if (objModel instanceof SubProcessStartOrEndEventModel) {
            SubProcessStartOrEndEventModel eventModel = (SubProcessStartOrEndEventModel)objModel;
            nodeId = eventModel.getNodeId();
        }
        if (StringUtil.isEmpty((String)nodeId)) {
            return;
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        ScriptType scriptType = this.getScriptType();
        String script = (String)nodeDef.getScripts().get(scriptType);
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        Map vars = bpmDelegateExecution.getVariables();
        Map boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty((Object)boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(cmd.getInstId());
            List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext((List)boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty((Object)boMap) && BeanUtils.isNotEmpty((Object)boMap)) {
            HashMap newMap = new HashMap();
            for (Map.Entry next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)next.getValue()));
            }
            vars.putAll(newMap);
        }
        vars.put("nodeDef", nodeDef);
        vars.put("execution", bpmDelegateExecution);
        vars.put("cmd", cmd);
        this.groovyScriptEngine.execute(script, vars);
    }
}

