/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activiti.ext.servicetask;

import com.hotent.activiti.ext.factory.BpmDelegateFactory;
import com.hotent.base.enums.CommonEnum;
import com.hotent.base.exception.BaseException;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.plugin.core.cmd.ExecutionCommand;
import com.hotent.bpm.api.service.BpmProStatusService;
import com.hotent.bpm.persistence.manager.BpmServiceLogManager;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.JavaDelegate;

public class CustomServiceTask
implements JavaDelegate {
    @Resource
    BpmProStatusService bpmProStatusService;
    @Resource
    BpmServiceLogManager serviceLogManager;
    private List<ExecutionCommand> executionCommands;

    public List<ExecutionCommand> getExecutionCommands() {
        return this.executionCommands;
    }

    public void setExecutionCommands(List<ExecutionCommand> executionCommands) {
        this.executionCommands = executionCommands;
    }

    public void execute(DelegateExecution execution) throws Exception {
        BpmDelegateExecution bpmExecution = BpmDelegateFactory.getBpmDelegateExecution(execution);
        if (this.executionCommands != null) {
            for (ExecutionCommand cmd : this.executionCommands) {
                String subject = (String)bpmExecution.getVariable("subject_");
                String defId = (String)bpmExecution.getVariable("processDefId_");
                String instId = (String)bpmExecution.getVariable("instanceId_");
                try {
                    cmd.execute(EventType.AUTO_TASK_EVENT, bpmExecution);
                }
                catch (Exception e) {
                    this.serviceLogManager.checkAndSave(subject, defId, instId, bpmExecution.getNodeId(), CommonEnum.YesOrNo.NO.getValue().intValue());
                    throw new BaseException((Throwable)e);
                }
                this.serviceLogManager.checkAndSave(subject, defId, instId, bpmExecution.getNodeId(), CommonEnum.YesOrNo.YES.getValue().intValue());
            }
        }
        String instId = (String)bpmExecution.getVariable("instanceId_");
        this.bpmProStatusService.createOrUpd(instId, bpmExecution.getBpmnDefId(), bpmExecution.getNodeId(), bpmExecution.getNodeName(), NodeStatus.COMPLETE);
    }
}

