/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.hotent.base.exception.BaseException;
import java.util.ArrayList;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExclusiveGatewayActivityBehavior.class);

    protected void leave(ActivityExecution execution) {
        if (log.isDebugEnabled()) {
            log.debug("Leaving activity '{}'", (Object)execution.getActivity().getId());
        }
        ArrayList<PvmTransition> emptyExpressionFlows = new ArrayList<PvmTransition>();
        for (PvmTransition seqFlow : execution.getActivity().getOutgoingTransitions()) {
            Expression skipExpression = seqFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled((ActivityExecution)execution, (Expression)skipExpression)) {
                Condition condition = (Condition)seqFlow.getProperty("condition");
                if (condition != null) {
                    if (!condition.evaluate(seqFlow.getId(), (DelegateExecution)execution)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Sequence flow '{}'selected as outgoing sequence flow.", (Object)seqFlow.getId());
                    }
                    execution.take(seqFlow);
                    return;
                }
                emptyExpressionFlows.add(seqFlow);
                continue;
            }
            if (!SkipExpressionUtil.shouldSkipFlowElement((ActivityExecution)execution, (Expression)skipExpression)) continue;
            execution.take(seqFlow);
            return;
        }
        if (emptyExpressionFlows.size() != 1) {
            if (emptyExpressionFlows.size() > 1) {
                throw new BaseException("\u5b58\u5728\u591a\u4e2a\u65e0\u6548\u5206\u652f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            }
            throw new BaseException("\u4e0d\u5b58\u5728\u7b26\u5408\u6761\u4ef6\u7684\u5206\u652f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        execution.take((PvmTransition)emptyExpressionFlows.get(0));
    }
}

