/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.util;

import com.hotent.sdk.feign.util.SdkStringUtil;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class Base64Util {
    protected static final byte PAD_DEFAULT = 61;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String getBase64(String s) throws UnsupportedEncodingException {
        if (SdkStringUtil.isEmpty(s)) {
            s = "";
        }
        byte[] bytes = Base64.encodeBase64((byte[])s.getBytes("utf-8"));
        return new String(bytes, "utf-8");
    }

    public static String getFromBase64(String s) throws UnsupportedEncodingException {
        if (s != null) {
            byte[] bytes = s.getBytes("utf-8");
            byte[] convertBytes = Base64.decodeBase64((byte[])bytes);
            return new String(convertBytes, "utf-8");
        }
        return "";
    }

    public static boolean isBase64(String base64) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, base64);
    }

    public static byte[] decodeBase64(String s) {
        if (s != null) {
            try {
                byte[] bytes = s.getBytes("utf-8");
                byte[] convertBytes = Base64.decodeBase64((byte[])bytes);
                return convertBytes;
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }
}

