/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign;

import com.hotent.entity.CommonResult;
import com.hotent.sdk.feign.config.SdkFeinConfig;
import com.hotent.sdk.feign.exception.TodoFeignFallBackException;
import com.hotent.vo.CopyDoneVo;
import com.hotent.vo.CopyVo;
import com.hotent.vo.DeleteTaskVo;
import com.hotent.vo.FlowInstanceVo;
import com.hotent.vo.LockOrUnLockVo;
import com.hotent.vo.PageList;
import com.hotent.vo.TaskDoneVo;
import com.hotent.vo.TaskVo;
import com.hotent.vo.TodoQueryVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="${eip.sdk.todo-service:eip-todo}", contextId="api-manager-eip-todo", fallbackFactory=TodoFeignFallBackException.class, configuration={SdkFeinConfig.class})
public interface TodoFeignClient {
    @GetMapping(value={"/apiManager/getToken"})
    public CommonResult getApiToken(@RequestParam(value="sysCode") String var1, @RequestParam(value="secretKey") String var2, @RequestParam(value="account") String var3);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/startFlow"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult startFlow(@RequestBody FlowInstanceVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/task/lockOrUnLockTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult lockOrUnLockTask(@RequestBody LockOrUnLockVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/updateFlow"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult updateFlow(@RequestBody FlowInstanceVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/deleteTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult deleteTask(@RequestBody DeleteTaskVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/taskToDone"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult taskToDone(@RequestBody TaskDoneVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/addTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult addTask(@RequestBody TaskVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/addCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult addCopy(@RequestBody CopyVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/doneCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult doneCopy(@RequestBody CopyDoneVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/task/exist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    public CommonResult<Boolean> exist(@RequestParam(value="instanceId") String var1, @RequestParam(value="taskId") String var2);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/instanceQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<PageList<FlowInstanceVo>> instanceQuery(@RequestBody TodoQueryVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/taskQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<PageList<TaskVo>> taskQuery(@RequestBody TodoQueryVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/taskDoneQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<PageList<TaskDoneVo>> taskDoneQuery(@RequestBody TodoQueryVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/copyQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<PageList<CopyVo>> copyQuery(@RequestBody TodoQueryVo var1);

    @RequestMapping(value={"/${eip.sdk.api-prefix}/todo/v1/physicsRemove"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    public CommonResult<String> physicsRemove(@RequestParam(value="flowKey") String var1, @RequestParam(value="sysCode") String var2);
}

