/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.config;

import cn.hutool.core.util.StrUtil;
import com.hotent.sdk.feign.service.EipSdkService;
import feign.Contract;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.clientconfig.FeignClientConfigurer;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;

public class SdkFeinConfig
implements FeignClientConfigurer {
    private final Logger logger = LoggerFactory.getLogger(SdkFeinConfig.class);

    @Bean
    public Contract feignContract() {
        return new SpringMvcContract();
    }

    @Bean
    public RequestInterceptor requestTokenBearerInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate requestTemplate) {
                String threadToken = EipSdkService.getThreadToken();
                if (StrUtil.isNotEmpty((CharSequence)threadToken)) {
                    SdkFeinConfig.this.logger.info("threadToken={}", (Object)threadToken);
                    requestTemplate.header("Authorization", new String[]{"Bearer " + threadToken});
                }
            }
        };
    }
}

