/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hotent.entity.CommonResult;
import com.hotent.sdk.feign.BpmRuntimeFeignClient;
import com.hotent.sdk.feign.UCFeignClient;
import com.hotent.sdk.feign.properties.EipSdkProperty;
import com.hotent.vo.DoNextParamObjectVo;
import com.hotent.vo.StartFlowParamObjectVo;
import com.hotent.vo.StartResult;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class EipSdkService {
    EipSdkProperty eipSdkProperty;
    private static final ThreadLocal<String> threadLocalToken = new ThreadLocal();
    private static final String UNDERLINE = "_";
    private final Cache<String, String> tokenCache;

    public EipSdkService(EipSdkProperty eipSdkProperty) {
        this.eipSdkProperty = eipSdkProperty;
        this.tokenCache = Caffeine.newBuilder().expireAfterWrite(eipSdkProperty.getTokenTimeout(), TimeUnit.SECONDS).maximumSize(10000L).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartResult start(StartFlowParamObjectVo startFlowParamObjectVo) throws Exception {
        try {
            if (StrUtil.isEmptyIfStr((Object)startFlowParamObjectVo.getAccount())) {
                throw new RuntimeException("\u53d1\u8d77\u4eba\u5e10\u53f7\u6ca1\u6709\u8bbe\u7f6e");
            }
            startFlowParamObjectVo.setSysCode(this.eipSdkProperty.getSysCode());
            this.getToken(this.eipSdkProperty.getSysCode(), this.eipSdkProperty.getSecretKey(), startFlowParamObjectVo.getAccount());
            BpmRuntimeFeignClient bpmRuntimeFeignClient = (BpmRuntimeFeignClient)SpringUtil.getBean(BpmRuntimeFeignClient.class);
            StartResult startResult = bpmRuntimeFeignClient.start(startFlowParamObjectVo);
            return startResult;
        }
        finally {
            this.clearThreadToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResult<String> complete(DoNextParamObjectVo dNextParamObjectVo) throws Exception {
        try {
            if (StrUtil.isEmptyIfStr((Object)dNextParamObjectVo.getAccount())) {
                throw new RuntimeException("\u5ba1\u6279\u4eba\u5e10\u53f7\u6ca1\u6709\u8bbe\u7f6e");
            }
            this.getToken(this.eipSdkProperty.getSysCode(), this.eipSdkProperty.getSecretKey(), dNextParamObjectVo.getAccount());
            BpmRuntimeFeignClient bpmRuntimeFeignClient = (BpmRuntimeFeignClient)SpringUtil.getBean(BpmRuntimeFeignClient.class);
            CommonResult<String> commonResult = bpmRuntimeFeignClient.complete(dNextParamObjectVo);
            return commonResult;
        }
        finally {
            this.clearThreadToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String currentUserAccount, Supplier<T> supplier) throws Exception {
        try {
            this.getToken(this.eipSdkProperty.getSysCode(), this.eipSdkProperty.getSecretKey(), currentUserAccount);
            T t = supplier.get();
            return t;
        }
        finally {
            this.clearThreadToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String currentUserAccount, Supplier<T> supplier, Consumer<Exception> consumer) throws Exception {
        T result = null;
        try {
            this.getToken(this.eipSdkProperty.getSysCode(), this.eipSdkProperty.getSecretKey(), currentUserAccount);
            result = supplier.get();
        }
        catch (Exception e) {
            consumer.accept(e);
        }
        finally {
            this.clearThreadToken();
        }
        return result;
    }

    public void getToken(String sysCode, String secretKey, String account) {
        StringJoiner tokenCacheKey = new StringJoiner(UNDERLINE);
        tokenCacheKey.add(sysCode);
        tokenCacheKey.add(secretKey);
        tokenCacheKey.add(account);
        String token = this.setToken2Cache(tokenCacheKey.toString());
        if (StrUtil.isEmptyIfStr((Object)token)) {
            UCFeignClient ucFeignClient = (UCFeignClient)SpringUtil.getBean(UCFeignClient.class);
            CommonResult apiToken = ucFeignClient.getApiToken(sysCode, secretKey, account);
            if (apiToken.getState().booleanValue()) {
                this.tokenCache.put((Object)tokenCacheKey.toString(), (Object)String.valueOf(apiToken.getValue()));
                this.setToken2Cache(tokenCacheKey.toString());
            } else {
                throw new RuntimeException("\u83b7\u53d6token\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e");
            }
        }
    }

    public void getToken(String currentUserAccount) {
        this.getToken(this.eipSdkProperty.getSysCode(), this.eipSdkProperty.getSecretKey(), currentUserAccount);
    }

    private String setToken2Cache(String tokenCacheKey) {
        String token = (String)this.tokenCache.getIfPresent((Object)tokenCacheKey);
        if (StrUtil.isNotEmpty((CharSequence)token)) {
            threadLocalToken.set(token);
        }
        return token;
    }

    public void clearThreadToken() {
        threadLocalToken.remove();
    }

    public static String getThreadToken() {
        return threadLocalToken.get();
    }
}

