/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.util;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class SdkBeanUtils {
    private static Logger logger = LoggerFactory.getLogger(SdkBeanUtils.class);
    public static ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private static BeanUtilsBean beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            if (((String)o).trim().length() == 0) {
                return true;
            }
        } else if (o instanceof Collection) {
            if (((Collection)o).size() == 0) {
                return true;
            }
        } else {
            if (o.getClass().isArray()) {
                if (o instanceof byte[]) {
                    return ((byte[])o).length == 0;
                }
                if (o instanceof int[]) {
                    return ((int[])o).length == 0;
                }
                if (o instanceof short[]) {
                    return ((short[])o).length == 0;
                }
                if (o instanceof long[]) {
                    return ((long[])o).length == 0;
                }
                if (o instanceof double[]) {
                    return ((double[])o).length == 0;
                }
                if (o instanceof float[]) {
                    return ((float[])o).length == 0;
                }
                if (o instanceof boolean[]) {
                    return ((boolean[])o).length == 0;
                }
                if (o instanceof char[]) {
                    return ((char[])o).length == 0;
                }
                return ((Object[])o).length == 0;
            }
            if (o instanceof Map) {
                if (((Map)o).size() == 0) {
                    return true;
                }
            } else {
                if (o instanceof ArrayNode) {
                    ArrayNode an = (ArrayNode)o;
                    return an.isEmpty(null);
                }
                if (o instanceof Serializable) {
                    return ((Serializable)o).toString().trim().length() == 0;
                }
            }
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !SdkBeanUtils.isEmpty(o);
    }

    public static boolean isNumber(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            try {
                Double.parseDouble((String)o);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean validClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isInherit(Class cls, Class parentClass) {
        return parentClass.isAssignableFrom(cls);
    }

    public static List<String> scanPackages(String basePackages) throws IllegalArgumentException {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)rl);
        ArrayList<String> result = new ArrayList<String>();
        String[] arrayPackages = basePackages.split(",");
        try {
            for (int j = 0; j < arrayPackages.length; ++j) {
                String packageToScan = arrayPackages[j];
                String packagePart = packageToScan.replace('.', '/');
                String classPattern = "classpath*:/" + packagePart + "/**/*.class";
                Resource[] resources = rl.getResources(classPattern);
                for (int i = 0; i < resources.length; ++i) {
                    Resource resource = resources[i];
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    result.add(className);
                }
            }
        }
        catch (Exception e) {
            new IllegalArgumentException("scan pakcage class error,pakcages:" + basePackages);
        }
        return result;
    }

    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = SdkBeanUtils.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Object convertByActType(String typeName, String value) {
        Object o = null;
        o = typeName.equals("int") ? Integer.valueOf(Integer.parseInt(value)) : (typeName.equals("short") ? Short.valueOf(Short.parseShort(value)) : (typeName.equals("long") ? Long.valueOf(Long.parseLong(value)) : (typeName.equals("float") ? Float.valueOf(Float.parseFloat(value)) : (typeName.equals("double") ? Double.valueOf(Double.parseDouble(value)) : (typeName.equals("boolean") ? Boolean.valueOf(Boolean.parseBoolean(value)) : (typeName.equals("java.lang.String") ? value : value))))));
        return o;
    }

    public static Class<?> getParameterTypes(String type) {
        Class claz = null;
        try {
            claz = type.equalsIgnoreCase("string") ? String.class : (type.equalsIgnoreCase("int") ? Integer.class : (type.equalsIgnoreCase("float") ? Float.class : (type.equalsIgnoreCase("double") ? Double.class : (type.equalsIgnoreCase("byte") ? Byte.class : (type.equalsIgnoreCase("short") ? Short.class : (type.equalsIgnoreCase("long") ? Long.class : (type.equalsIgnoreCase("boolean") ? Boolean.class : (type.equalsIgnoreCase("date") ? Date.class : String.class))))))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claz;
    }

    public static Field getField(Class<?> thisClass, String fieldName) throws NoSuchFieldException {
        if (fieldName == null) {
            throw new NoSuchFieldException("Error field !");
        }
        Field field = thisClass.getDeclaredField(fieldName);
        return field;
    }

    public static void mergeObject(Object srcObj, Object desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Field[] fs1 = srcObj.getClass().getDeclaredFields();
        Field[] fs2 = desObj.getClass().getDeclaredFields();
        for (int i = 0; i < fs1.length; ++i) {
            try {
                fs1[i].setAccessible(true);
                Object value = fs1[i].get(srcObj);
                fs1[i].setAccessible(false);
                if (null == value) continue;
                fs2[i].setAccessible(true);
                fs2[i].set(desObj, value);
                fs2[i].setAccessible(false);
                continue;
            }
            catch (Exception e) {
                logger.error("mergeObject" + e.getMessage());
            }
        }
    }

    public static void removeDuplicate(List list) {
        HashSet h = new HashSet(list);
        list.clear();
        list.addAll(h);
    }

    static {
        convertUtilsBean.register((Converter)new DateConverter(), Date.class);
        convertUtilsBean.register((Converter)new LongConverter(null), Long.class);
    }
}

