/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.autoconfigure;

import com.hotent.sdk.feign.properties.EipSdkProperty;
import com.hotent.sdk.feign.service.EipSdkService;
import com.hotent.sdk.feign.service.EipTodoPushSdkService;
import com.hotent.sdk.feign.service.EipTodoSdkService;
import feign.Client;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="eip.sdk", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Client.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@EnableConfigurationProperties(value={EipSdkProperty.class})
@EnableFeignClients(basePackages={"com.hotent.sdk.*"})
public class EipSdkAutoConfigure {
    @Bean
    public EipSdkService eipSdkService(EipSdkProperty eipSdkProperty) {
        return new EipSdkService(eipSdkProperty);
    }

    @Bean
    public EipTodoSdkService eipTodoSdkService(EipSdkProperty eipSdkProperty) {
        return new EipTodoSdkService(eipSdkProperty);
    }

    @Bean
    public EipTodoPushSdkService eipTodoPushSdkService(EipSdkProperty eipSdkProperty) {
        return new EipTodoPushSdkService(eipSdkProperty);
    }
}

