/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.sdk.feign.util.Base64Util;
import com.hotent.sdk.feign.util.SdkBeanUtils;
import com.hotent.sdk.feign.util.SdkJsonUtil;
import com.hotent.sdk.feign.util.SdkStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SdkFluentUtil {
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final Logger logger = LoggerFactory.getLogger(SdkFluentUtil.class);

    public static String get(String url, String headerStr) throws ClientProtocolException, IOException {
        return SdkFluentUtil.get(url, headerStr, 0, 0);
    }

    public static String get(String url, String headerStr, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Get((String)url);
        request = SdkFluentUtil.setHeaders(request, headerStr);
        HttpResponse returnResponse = request.connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return SdkFluentUtil.handleResponse(returnResponse);
    }

    public static String post(String url, String headerStr, Object params) throws ClientProtocolException, IOException {
        return SdkFluentUtil.post(url, headerStr, params, 0, 0);
    }

    public static String post(String url, String headerStr, Object params, ContentType contentType) throws ClientProtocolException, IOException {
        return SdkFluentUtil.post(url, headerStr, params, 0, 0, contentType);
    }

    private static String post(String url, String headerStr, Object params, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        return SdkFluentUtil.post(url, headerStr, params, connectTimeout, socketTimeout, ContentType.APPLICATION_JSON);
    }

    private static String post(String url, String headerStr, Object params, int connectTimeout, int socketTimeout, ContentType contentType) throws ClientProtocolException, IOException {
        logger.debug("[Fluent Request]:" + url);
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Post((String)url);
        request = SdkFluentUtil.setHeaders(request, headerStr);
        String paramStr = "";
        if (SdkBeanUtils.isNotEmpty(params)) {
            paramStr = SdkJsonUtil.toJson(params);
        }
        HttpResponse returnResponse = request.bodyString(paramStr, contentType).connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return SdkFluentUtil.handleResponse(returnResponse);
    }

    private static Request setHeaders(Request request, String headerStr) {
        if (SdkStringUtil.isNotEmpty(headerStr)) {
            try {
                headerStr = Base64Util.getFromBase64(headerStr);
                ObjectNode obj = (ObjectNode)SdkJsonUtil.toJsonNode(headerStr);
                Iterator it = obj.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    request.setHeader(key, obj.get(key).asText());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return request;
    }

    private static String handleResponse(HttpResponse returnResponse) throws IOException {
        int statusCode = returnResponse.getStatusLine().getStatusCode();
        InputStream content = returnResponse.getEntity().getContent();
        String res = SdkStringUtil.InputStreamToString(content);
        logger.debug("[Fluent Response]:" + res);
        if (statusCode != 200) {
            logger.error("[Fluent Response Error]:{}", (Object)res);
            JsonNode jsonNode = SdkJsonUtil.toJsonNode(res);
            throw new RuntimeException(SdkJsonUtil.getString(jsonNode, "message", res));
        }
        return res;
    }

    public static boolean isHttpUrl(String url) {
        Assert.notNull((Object)url, (String)"\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a");
        url = url.toLowerCase();
        String regex = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*\u2018().&=+$%-]+: )?[0-9a-z_!~*\u2018().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*\u2018()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,5})?((/?)|(/[0-9a-z_!~*\u2018().;?:@&=+$,%#-\\{\\}]+)+/?)$";
        return url.matches(regex);
    }
}

