/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.feign.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.hotent.sdk.feign.util.SdkBeanUtils;
import com.hotent.sdk.feign.util.SdkStringUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class SdkJsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static <C> C toBean(String json, Class<C> cls) throws JsonParseException, JsonMappingException, IOException {
        return (C)mapper.readValue(json, cls);
    }

    public static <C> C toBean(JsonNode jsonNode, Class<C> cls) throws JsonParseException, JsonMappingException, IOException {
        Assert.notNull((Object)jsonNode, (String)"jsonNode can not be empty.");
        return (C)mapper.convertValue((Object)jsonNode, cls);
    }

    public static JsonNode toJsonNode(Object obj) throws IOException {
        if (SdkBeanUtils.isEmpty(obj)) {
            return null;
        }
        return (JsonNode)mapper.convertValue(obj, JsonNode.class);
    }

    public static JsonNode toJsonNode(String json) throws IOException {
        return mapper.readTree(json);
    }

    public static <C> C toBean(String json, TypeReference<C> typeRef) throws JsonParseException, JsonMappingException, IOException {
        Object list = mapper.readValue(json, typeRef);
        return (C)list;
    }

    public static String toJson(Object obj) throws IOException {
        return mapper.writeValueAsString(obj);
    }

    public static String toJsonIndent(Object obj) throws IOException {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString(obj);
    }

    public static String toJsonString(Object obj) throws Exception {
        if (obj != null && obj instanceof String) {
            return obj.toString();
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new Exception("\u5c06\u5bf9\u8c61\u89e3\u6790\u4e3a\u5b57\u7b26\u4e32\u65f6\u51fa\u9519", e);
        }
    }

    public static <T> Map<String, T> toMap(String json) throws IOException {
        Map map = (Map)mapper.readValue(json, Map.class);
        return map;
    }

    public static String getString(JsonNode obj, String key, String defaultValue) {
        if (!SdkJsonUtil.isContainsKey(obj, key)) {
            return defaultValue;
        }
        try {
            if (obj.get(key).isObject() || obj.get(key).isArray()) {
                return SdkJsonUtil.toJson(obj.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonNode jsonNode = obj.get(key);
        if (jsonNode.isNull()) {
            return defaultValue;
        }
        return jsonNode.asText();
    }

    public static String getString(JsonNode obj, String key) {
        return SdkJsonUtil.getString(obj, key, "");
    }

    public static int getInt(ObjectNode obj, String key) {
        if (!SdkJsonUtil.isContainsKey((JsonNode)obj, key)) {
            return 0;
        }
        return obj.get(key).asInt();
    }

    public static int getInt(ObjectNode obj, String key, int defaultValue) {
        if (!SdkJsonUtil.isContainsKey((JsonNode)obj, key)) {
            return defaultValue;
        }
        return obj.get(key).asInt();
    }

    public static boolean getBoolean(ObjectNode obj, String key) {
        if (!SdkJsonUtil.isContainsKey((JsonNode)obj, key)) {
            return false;
        }
        return obj.get(key).asBoolean();
    }

    public static long getLong(ObjectNode obj, String key, long defaultValue) {
        if (!SdkJsonUtil.isContainsKey((JsonNode)obj, key)) {
            return defaultValue;
        }
        return obj.get(key).asLong();
    }

    public static long getLong(ObjectNode obj, String key) {
        return SdkJsonUtil.getLong(obj, key, 0L);
    }

    public static boolean getBoolean(ObjectNode obj, String key, boolean defaultValue) {
        if (!SdkJsonUtil.isContainsKey((JsonNode)obj, key)) {
            return defaultValue;
        }
        return obj.get(key).asBoolean();
    }

    public static ArrayNode getArray(JsonNode node, String key, ArrayNode defaultValue) throws Exception {
        if (!SdkJsonUtil.isContainsKey(node, key)) {
            return defaultValue;
        }
        if (!node.get(key).isArray()) {
            throw new Exception("\u8be5\u5c5e\u6027\u4e0b\u7684\u503c\u4e0d\u662f\u6570\u7ec4");
        }
        return (ArrayNode)node.get(key);
    }

    public static ArrayNode getArray(JsonNode node, String key) throws Exception {
        return SdkJsonUtil.getArray(node, key, SdkJsonUtil.createArrayNode());
    }

    public static boolean isNotEmptyJsonArr(String jsonArrStr) {
        return !SdkJsonUtil.isEmptyJsonArr(jsonArrStr);
    }

    public static boolean isEmptyJsonArr(String jsonArrStr) {
        if (SdkStringUtil.isEmpty(jsonArrStr)) {
            return true;
        }
        try {
            ArrayNode jsonAry = (ArrayNode)SdkJsonUtil.toJsonNode(jsonArrStr);
            return jsonAry.size() <= 0;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return true;
        }
    }

    public static boolean isContainsKey(JsonNode obj, String key) {
        if (obj != null && key != null) {
            Iterator iterator = obj.fieldNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (!key.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static String escapeSpecialChar(String str) {
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void removeNull(ObjectNode jsonObject) {
        Iterator newSet = jsonObject.fields();
        while (newSet.hasNext()) {
            Map.Entry ent = (Map.Entry)newSet.next();
            JsonNode val = jsonObject.get((String)ent.getKey());
            if (!(val instanceof NullNode)) continue;
            jsonObject.put((String)ent.getKey(), "");
        }
    }

    public static void removeNull(ArrayNode jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            SdkJsonUtil.removeNull((ObjectNode)jsonArray.get(i));
        }
    }

    public static ObjectNode arrayToObject(ArrayNode jsonArray, String keyName) throws IOException {
        ObjectNode jsonObject = SdkJsonUtil.getMapper().createObjectNode();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonNode temp = SdkJsonUtil.toJsonNode(jsonArray.get(i));
            Objects.requireNonNull(temp);
            jsonObject.put(temp.get(keyName).asText(), temp);
        }
        return jsonObject;
    }

    public static ArrayNode objectToArray(JsonNode jsonObject) {
        ArrayNode jsonArray = SdkJsonUtil.getMapper().createArrayNode();
        Iterator newSet = jsonObject.fields();
        while (newSet.hasNext()) {
            Map.Entry ent = (Map.Entry)newSet.next();
            jsonArray.add(jsonObject.get((String)ent.getKey()));
        }
        return jsonArray;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof ObjectNode) {
            return ((ObjectNode)obj).isObject();
        }
        if (obj instanceof ArrayNode) {
            return ((ArrayNode)obj).isArray();
        }
        return NullNode.getInstance().equals(obj);
    }

    public static List<ObjectNode> arrayToList(ArrayNode jsonArray) throws IOException {
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonNode temp = SdkJsonUtil.toJsonNode(jsonArray.get(i));
            list.add((ObjectNode)temp);
        }
        return list;
    }

    public static <T> ArrayNode listToArrayNode(List<T> list) throws IOException {
        if (SdkBeanUtils.isEmpty(list)) {
            return null;
        }
        ArrayNode aryNode = SdkJsonUtil.getMapper().createArrayNode();
        if (SdkBeanUtils.isNotEmpty(list)) {
            for (T uv : list) {
                aryNode.add(SdkJsonUtil.toJsonNode(uv));
            }
        }
        return aryNode;
    }

    public static <T> List<ObjectNode> listToListNode(List<T> list) throws IOException {
        if (SdkBeanUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<ObjectNode> nodeList = new ArrayList<ObjectNode>();
        if (SdkBeanUtils.isNotEmpty(list)) {
            for (T uv : list) {
                nodeList.add((ObjectNode)SdkJsonUtil.toJsonNode(uv));
            }
        }
        return nodeList;
    }

    public static String clearJsonStrBackslash(String jsonStr) throws IOException {
        if (SdkStringUtil.isEmpty(jsonStr)) {
            return "";
        }
        JsonNode jsonNode = SdkJsonUtil.toJsonNode(jsonStr);
        if (jsonNode instanceof TextNode) {
            return jsonNode.asText();
        }
        return SdkJsonUtil.toJson(jsonNode);
    }

    public static void putObjectToJson(ObjectNode obj, String filedName, Object value) {
        if (SdkBeanUtils.isEmpty(value) || SdkBeanUtils.isEmpty(obj) || SdkStringUtil.isEmpty(filedName)) {
            return;
        }
        if (value instanceof String) {
            obj.put(filedName, (String)value);
        } else if (value instanceof Integer) {
            obj.put(filedName, ((Integer)value).intValue());
        } else if (value instanceof Double) {
            obj.put(filedName, (Double)value);
        } else if (value instanceof Float) {
            obj.put(filedName, (Float)value);
        } else if (value instanceof Long) {
            obj.put(filedName, (Long)value);
        } else if (value instanceof Boolean) {
            obj.put(filedName, (Boolean)value);
        }
    }

    public static JsonNode getByPath(JsonNode obj, String path) {
        Assert.notNull((Object)path, (String)"\u8981\u83b7\u53d6\u5bf9\u8c61\u7684path\u4e0d\u80fd\u4e3a\u7a7a!");
        if (SdkBeanUtils.isEmpty(obj)) {
            return null;
        }
        Object[] pathList = path.split("\\.");
        if (pathList.length > 1) {
            if (SdkBeanUtils.isNotEmpty(obj.get(pathList[0]))) {
                return SdkJsonUtil.getByPath(obj.get(pathList[0]), StringUtils.join((Object[])ArrayUtils.remove((Object[])pathList, (int)0), (String)"."));
            }
            return null;
        }
        return obj.get(path);
    }

    public static String getStrByPath(JsonNode obj, String path) {
        return SdkJsonUtil.getStrByPath(obj, path, Objects::requireNonNull);
    }

    public static String getStrByPath(JsonNode obj, String path, Consumer<JsonNode> consumer) {
        JsonNode jsonNode = SdkJsonUtil.getByPath(obj, path);
        consumer.accept(jsonNode);
        if (SdkBeanUtils.isNotEmpty(jsonNode) && jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        return "";
    }

    public static JsonNode getIgnoreCase(JsonNode obj, String key) {
        if (SdkBeanUtils.isEmpty(obj) || SdkStringUtil.isEmpty(key)) {
            return null;
        }
        Iterator iterator = obj.fields();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (!((String)next.getKey()).equalsIgnoreCase(key)) continue;
            return (JsonNode)next.getValue();
        }
        return null;
    }

    public static String getStringIgnoreKey(JsonNode obj, String key, String defalutVal) {
        JsonNode jsonNode = SdkJsonUtil.getIgnoreCase(obj, key);
        if (SdkBeanUtils.isNotEmpty(jsonNode) && jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        return defalutVal;
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return mapper.createArrayNode();
    }

    public static <C> List toList(String json, Class<C> cls) throws JsonParseException, JsonMappingException, IOException {
        List list = (List)mapper.readValue(json, mapper.getTypeFactory().constructParametricType(List.class, new Class[]{cls}));
        return list;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleDateFormat myDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormat));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormat));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormat));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormat));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormat));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormat));
        mapper.registerModule((Module)javaTimeModule);
        mapper.setDateFormat((DateFormat)myDateFormat);
        SimpleModule sm = new SimpleModule();
        mapper.registerModule((Module)sm);
    }
}

