/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class JdbcUtils {
    private static final Log logger = LogFactory.getLog(JdbcUtils.class);

    public static DbType getDbType(String jdbcUrl) {
        Assert.isFalse((boolean)StringUtils.isBlank((CharSequence)jdbcUrl), (String)"Error: The jdbcUrl is Null, Cannot read database type", (Object[])new Object[0]);
        if (jdbcUrl.contains(":gbasedbt-sqli:")) {
            return DbType.GBASE_8S;
        }
        if (jdbcUrl.contains(":mysql:") || jdbcUrl.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (jdbcUrl.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (jdbcUrl.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (jdbcUrl.contains(":sqlserver:") || jdbcUrl.contains(":microsoft:")) {
            return DbType.SQL_SERVER2005;
        }
        if (jdbcUrl.contains(":sqlserver2012:")) {
            return DbType.SQL_SERVER;
        }
        if (jdbcUrl.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (jdbcUrl.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (jdbcUrl.contains(":db2:")) {
            return DbType.DB2;
        }
        if (jdbcUrl.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (jdbcUrl.contains(":h2:")) {
            return DbType.H2;
        }
        if (jdbcUrl.contains(":dm:")) {
            return DbType.DM;
        }
        if (jdbcUrl.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (jdbcUrl.contains(":kingbase:") || jdbcUrl.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        }
        if (jdbcUrl.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        logger.warn("The jdbcUrl is " + jdbcUrl + ", Mybatis Plus Cannot Read Database type or The Database's Not Supported!");
        return DbType.OTHER;
    }
}

