/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.auth.server.controller;

import com.hotent.auth.server.service.AuthenticationService;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.LogType;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.CertificateException;
import com.hotent.base.jwt.JwtAuthenticationRequest;
import com.hotent.base.manager.CaptchaManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.ClientProtocolException;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ba4\u8bc1\u63a5\u53e3"})
@ApiGroup(group={"group_auth"})
public class AuthenticationRestController {
    @Resource
    AuthenticationService authenticationService;
    @Resource
    private CaptchaManager captchaManager;

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/auth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u767b\u5f55\u7cfb\u7edf", httpMethod="POST", notes="\u767b\u5f55\u7cfb\u7edf")
    public ResponseEntity<?> createAuthenticationToken(@RequestBody JwtAuthenticationRequest authenticationRequest) throws AuthenticationException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.authenticationService.createAuthenticationToken(authenticationRequest);
    }

    @RequestMapping(value={"/auth/captcha"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801", httpMethod="GET", notes="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801")
    public Map<String, String> getCaptchaImage() {
        return this.captchaManager.generateImage();
    }

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/sso/auth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u767b\u5f55\u7cfb\u7edf-\u5355\u70b9\u767b\u5f55", httpMethod="GET", notes="\u767b\u5f55\u7cfb\u7edf-\u5355\u70b9\u767b\u5f55")
    public ResponseEntity<?> ssoAuth(@RequestParam Optional<String> ticket, @RequestParam Optional<String> code, @RequestParam Optional<String> ssoMode, @RequestParam String service) throws AuthenticationException, ClientProtocolException, IOException {
        return this.authenticationService.ssoAuth(ticket, code, ssoMode, service);
    }

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/sso/weixin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u8fdb\u5165\u624b\u673a\u7aef-\u5355\u70b9\u767b\u5f55", httpMethod="GET", notes="\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u8fdb\u5165\u624b\u673a\u7aef-\u5355\u70b9\u767b\u5f55")
    public ResponseEntity<?> ssoWeixin(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        return this.authenticationService.ssoWeixin(code);
    }

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/sso/weixinPublic"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5fae\u4fe1\u516c\u4f17\u53f7\u8fdb\u5165\u624b\u673a\u7aef", httpMethod="GET", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u8fdb\u5165\u624b\u673a\u7aef")
    public ResponseEntity<?> weixinPublic(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        return this.authenticationService.ssoWeixinPublic(code);
    }

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/sso/dingTalk"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9489\u9489\u8fdb\u5165\u624b\u673a\u7aef", httpMethod="GET", notes="\u9489\u9489\u8fdb\u5165\u624b\u673a\u7aef")
    public ResponseEntity<?> dingTalk(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        return this.authenticationService.ssoDingTalk(code);
    }

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/sso/miniprogram"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u767b\u9646\u51ed\u8bc1\u6821\u9a8c", httpMethod="GET", notes="\u5c0f\u7a0b\u5e8f\u767b\u5f55\u51ed\u8bc1\u6821\u9a8c")
    public CommonResult<?> miniprogram(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        return this.authenticationService.ssoMiniprogram(code);
    }

    @LogType(value="\u767b\u5f55\u65e5\u5fd7")
    @RequestMapping(value={"/sso/flybook"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u98de\u4e66\u5e94\u7528\u8fdb\u5165\u624b\u673a\u7aef-\u5355\u70b9\u767b\u5f55", httpMethod="GET", notes="\u98de\u4e66\u5e94\u7528\u8fdb\u5165\u624b\u673a\u7aef-\u5355\u70b9\u767b\u5f55")
    public ResponseEntity<?> ssoFlyBook(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        return this.authenticationService.ssoFlyBook(code);
    }

    @RequestMapping(value={"/auth/scanLogin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u5fae\u9489\u9489App\u626b\u7801\u767b\u5f55PC\u7aef", httpMethod="GET", notes="\u4f01\u5fae\u9489\u9489App\u626b\u7801\u767b\u5f55PC\u7aef")
    public CommonResult<?> scanLogin(@RequestParam(value="code") Optional<String> code, @RequestParam(value="type") Optional<String> type, @ApiParam(name="redirectUri", value="\u98de\u4e66\u524d\u7aef\u56de\u8c03\u5730\u5740") @RequestParam(value="redirectUri", required=false) String redirectUri, @ApiParam(name="tenantId", value="\u5f53\u524d\u79df\u6237ID") @RequestParam(value="tenantId", required=false) String tenantId) {
        if (StringUtil.isNotEmpty((String)tenantId)) {
            BaseContext context = (BaseContext)AppUtil.getBean(BaseContext.class);
            context.setTempTenantId(tenantId);
        }
        return this.authenticationService.scanLogin(code, type, redirectUri);
    }

    @RequestMapping(value={"/sso/info"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u70b9\u767b\u5f55\u914d\u7f6e", httpMethod="GET", notes="\u5355\u70b9\u767b\u5f55\u914d\u7f6e")
    public ResponseEntity<Map<String, Object>> isUseCas(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return ResponseEntity.ok(this.authenticationService.getSsoInfo());
    }

    @RequestMapping(value={"/refresh"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5237\u65b0token", httpMethod="GET", notes="\u5237\u65b0token")
    public ResponseEntity<?> refreshAndGetAuthenticationToken(HttpServletRequest request) {
        return this.authenticationService.refreshAndGetAuthenticationToken(request);
    }

    @RequestMapping(value={"/signout"}, method={RequestMethod.GET})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", httpMethod="GET", notes="\u4f7ftoken\u7684\u72b6\u6001\u5931\u6548,\u5fc5\u987b\u8bbe\u7f6ejwt.single\u548cjwt.stricky\u5747\u4e3atrue")
    public CommonResult<String> signout(HttpServletRequest request) {
        this.authenticationService.signOut(request);
        return CommonResult.ok().message("\u9000\u51fa\u6210\u529f");
    }
}

