/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.auth.server.service.impl;

import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.auth.server.service.AuthenticationService;
import com.hotent.base.conf.JwtConfig;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.conf.SsoConfig;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.CertificateException;
import com.hotent.base.exception.ServerRejectException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jwt.JwtAuthenticationRequest;
import com.hotent.base.jwt.JwtAuthenticationResponse;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.manager.CaptchaManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.service.TwoVerifyService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CacheEvictUtil;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.RSAUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.XmlUtil;
import com.hotent.base.vo.LoginFailedVo;
import com.hotent.base.vo.TwoVerifyInfoVo;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLSyntaxErrorException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    @Resource
    AuthenticationManager authenticationManager;
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    UserDetailsService userDetailsService;
    @Resource
    SsoConfig ssoConfig;
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Resource
    UCFeignService uCFeignService;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    SaaSConfig saasConfig;
    @Resource
    JwtConfig jwtConfig;
    @Resource
    private CaptchaManager captchaManager;
    @Resource
    private TwoVerifyService twoVerifyService;

    @Override
    public ResponseEntity<?> createAuthenticationToken(JwtAuthenticationRequest authenticationRequest) throws AuthenticationException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (!this.captchaManager.verifyCode(authenticationRequest)) {
            return ResponseEntity.ok((Object)CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.BAD_CAPTCHA));
        }
        String reqAccount = authenticationRequest.getUsername();
        String reqPassword = "";
        CacheEvictUtil.deleteUserDetailsCache((String)reqAccount);
        this.checkLoginFailed(reqAccount);
        try {
            reqPassword = RSAUtil.Decrypt((String)authenticationRequest.getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5bc6\u7801\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5RSA\u516c\u94a5\u548c\u79c1\u94a5\u914d\u7f6e");
        }
        String errorMsg = "";
        String commonMsg = I18nUtil.handleI18nMessage((String)"incorrect.account.password.exception", (String)"\u60a8\u7684\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u53ef\u7528");
        try {
            this.authenticate(reqAccount, reqPassword);
        }
        catch (Exception e) {
            logger.error(String.format("Login failed account[%s].", reqAccount), (Throwable)e);
            errorMsg = commonMsg;
            Throwable cause = ExceptionUtil.getRootCauseOrSelf((Throwable)e.getCause());
            if (cause instanceof CertificateException) {
                CertificateException ce = (CertificateException)cause;
                errorMsg = ce.getMessage();
            } else if (cause instanceof SQLSyntaxErrorException) {
                SQLSyntaxErrorException sqlSyntaxErrorException = (SQLSyntaxErrorException)cause;
                logger.error(sqlSyntaxErrorException.getMessage());
            } else if (cause instanceof BaseException) {
                BaseException baseException = (BaseException)cause;
                logger.error(baseException.getMessage());
            } else if (e instanceof CertificateException) {
                logger.error(e.getMessage());
            } else if (e instanceof LockedException) {
                logger.error("\u8d26\u53f7{}\u88ab\u7981\u7528\u6216\u79bb\u804c", (Object)reqAccount);
            } else if (e instanceof InternalAuthenticationServiceException) {
                logger.error("\u8d26\u6237{}\u9519\u8bef\u6216\u8be5\u79df\u6237\u672a\u542f\u7528", (Object)reqAccount);
            } else if (e instanceof BadCredentialsException) {
                errorMsg = this.recordLoginFailed(reqAccount, errorMsg);
            }
            if (this.captchaManager.addFailedCount(authenticationRequest.getUsername())) {
                return ResponseEntity.ok((Object)CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.BAD_CAPTCHA, (String)errorMsg));
            }
            throw new RuntimeException(errorMsg);
        }
        HttpServletRequest request = HttpUtil.getRequest();
        boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(authenticationRequest.getUsername());
        String userName = userDetails.getUsername();
        String account = "";
        String userId = "";
        String twoVerifySecret = "";
        boolean loginStatus = true;
        HashMap<String, String> userAttrs = new HashMap<String, String>();
        if (userDetails instanceof IUser) {
            IUser user = (IUser)userDetails;
            userName = user.getFullname();
            account = user.getAccount();
            userId = user.getUserId();
            if (user.getExpireDate() != null && LocalDate.now().isAfter(user.getExpireDate())) {
                BaseException exception = new BaseException(commonMsg);
                logger.error(String.format("\u3010%s\u3011\u5df2\u8fc7\u7528\u6237\u6709\u6548\u65e5\u671f", account), (Throwable)exception);
                throw exception;
            }
            request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            loginStatus = this.checkUser(user, reqPassword);
            userAttrs.put("tenantId", user.getTenantId());
            Map userMap = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)user), Map.class);
            twoVerifySecret = StringUtil.isNotEmpty((String)String.valueOf(userMap.get("twoVerifySecret"))) ? userMap.get("twoVerifySecret").toString() : null;
        }
        String token = this.jwtTokenHandler.generateToken(userDetails);
        this.handleSingleLogin(isMobile, MapUtil.getString(userAttrs, (String)"tenantId"), account, token);
        JwtAuthenticationResponse jwtAuthenticationResponse = new JwtAuthenticationResponse(token, userName, account, userId, Long.valueOf(this.jwtConfig.getExpirationLong()), loginStatus, userAttrs);
        CommonResult commonResult = this.checkTwoStepVerify(isMobile, twoVerifySecret, jwtAuthenticationResponse);
        this.captchaManager.resetLimit(reqAccount);
        this.ucFeignService.removeLoginFailedByAccount(reqAccount);
        if (commonResult != null) {
            return ResponseEntity.ok((Object)commonResult);
        }
        return ResponseEntity.ok((Object)jwtAuthenticationResponse);
    }

    @Override
    public ResponseEntity<?> ssoAuth(Optional<String> ticket, Optional<String> code, Optional<String> ssoMode, String service) throws AuthenticationException, ClientProtocolException, IOException {
        Assert.isTrue((boolean)this.ssoConfig.isEnable(), (String)"\u5f53\u524d\u670d\u52a1\u672a\u5f00\u542f\u5355\u70b9\u767b\u5f55");
        String username = null;
        String mode = this.ssoConfig.getMode();
        if (ssoMode.isPresent()) {
            mode = ssoMode.get();
        }
        if (ticket.isPresent() && "cas".equals(mode)) {
            username = this.getUserNameWithCas(ticket.get(), service);
        } else if (code.isPresent() && "oauth".equals(mode)) {
            username = this.getUserNameWithOauth(code.get(), service);
        } else if (ticket.isPresent() && code.isPresent() && "jwt".equals(mode)) {
            username = this.jwtTokenHandler.getUsernameFromToken(ticket.get());
        } else {
            throw new ServerRejectException("\u5355\u70b9\u767b\u5f55\u6a21\u5f0f\u5339\u914d\u5f02\u5e38");
        }
        CacheEvictUtil.deleteUserDetailsCache((String)username);
        HttpServletRequest request = HttpUtil.getRequest();
        boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        String token = this.jwtTokenHandler.generateToken(userDetails);
        String userName = userDetails.getUsername();
        String account = "";
        String userId = "";
        HashMap<String, String> userAttrs = new HashMap<String, String>();
        if (userDetails instanceof IUser) {
            IUser user = (IUser)userDetails;
            userName = user.getFullname();
            account = user.getAccount();
            userId = user.getUserId();
            request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            userAttrs.put("tenantId", user.getTenantId());
        }
        logger.debug("\u901a\u8fc7\u5355\u70b9\u8ba4\u8bc1\u767b\u5f55\u6210\u529f\u3002");
        if (!code.isPresent() || !"jwt".equals(mode)) {
            this.handleSingleLogin(isMobile, MapUtil.getString(userAttrs, (String)"tenantId"), account, token);
        }
        return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId, Long.valueOf(this.jwtConfig.getExpirationLong()), userAttrs));
    }

    @Override
    public ResponseEntity<?> ssoWeixin(Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String resultJson = HttpUtil.sendHttpsRequest((String)this.portalFeignService.getUserInfoUrl("weChatWork", code.orElse("")), (String)"", (String)"POST");
        logger.error("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u8fd4\u56de\u7ed3\u679c\uff1a" + resultJson);
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        Objects.requireNonNull(result);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            String wxWorkId = result.get("UserId").asText();
            JsonNode simpleUser = this.uCFeignService.getUserByWxWorkId(wxWorkId);
            if (BeanUtils.isEmpty((Object)simpleUser) || simpleUser.isNull()) {
                throw new RuntimeException("\u67e5\u65e0\u4e0e\u60a8\u4f01\u5fae\u8d26\u53f7[userid:" + wxWorkId + "]\u7ed1\u5b9a\u7684eip\u8d26\u53f7");
            }
            String account = simpleUser.get("account").asText();
            try {
                CacheEvictUtil.deleteUserDetailsCache((String)account);
                HttpServletRequest request = HttpUtil.getRequest();
                Objects.requireNonNull(request);
                boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                logger.debug("\u901a\u8fc7\u5355\u70b9\u8ba4\u8bc1\u767b\u5f55\u6210\u529f\u3002");
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            catch (Exception e) {
                throw new RuntimeException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u5931\u8d25 ,eip\u7528\u6237\u8d26\u53f7:" + account);
            }
        }
        throw new RuntimeException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public ResponseEntity<?> ssoWeixinPublic(Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String resultJson = HttpUtil.sendHttpsRequest((String)this.portalFeignService.getUserInfoUrl("weChatOffAcc", code.get()), (String)"", (String)"POST");
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (result.has("openid")) {
            String openid = result.get("openid").asText();
            CommonResult r = this.uCFeignService.getUserByOpenId(openid);
            if (r.getState().booleanValue()) {
                JsonNode node = (JsonNode)r.getValue();
                if (StringUtil.isNotEmpty((String)openid) && BeanUtils.isEmpty((Object)node)) {
                    return ResponseEntity.ok((Object)new JwtAuthenticationResponse(openid));
                }
                String account = node.get("account").asText();
                CacheEvictUtil.deleteUserDetailsCache((String)account);
                HttpServletRequest request = HttpUtil.getRequest();
                boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            if (StringUtil.isNotEmpty((String)openid)) {
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(openid));
            }
        }
        throw new RuntimeException("\u5fae\u4fe1\u767b\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public ResponseEntity<?> ssoDingTalk(Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String resultJson = HttpUtil.sendHttpsRequest((String)this.portalFeignService.getUserInfoUrl("dingtalk", code.get()), (String)"", (String)"GET");
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (result.has("userid")) {
            String dingtalkId = result.get("userid").asText();
            JsonNode simpleUser = this.uCFeignService.getUserByDingtalkId(dingtalkId);
            if (BeanUtils.isEmpty((Object)simpleUser) || simpleUser.isNull()) {
                throw new RuntimeException("\u67e5\u65e0\u4e0e\u60a8\u9489\u9489\u8d26\u53f7[userid:" + dingtalkId + "]\u7ed1\u5b9a\u7684eip\u8d26\u53f7");
            }
            String account = simpleUser.get("account").asText();
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
            if (BeanUtils.isNotEmpty((Object)userDetails)) {
                CacheEvictUtil.deleteUserDetailsCache((String)account);
                HttpServletRequest request = HttpUtil.getRequest();
                boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            throw new RuntimeException("\u9489\u9489\u767b\u5f55\u5931\u8d25\uff01eip\u8d26\u53f7:" + account + "\u4e0d\u5b58\u5728");
        }
        throw new RuntimeException("\u9489\u9489\u767b\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public CommonResult<?> ssoMiniprogram(Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String url = this.portalFeignService.getUserInfoUrl("miniprogram", code.get());
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"POST");
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (result.has("openid")) {
            String openid = result.get("openid").asText();
            JsonNode simpleUser = this.uCFeignService.getUserByMpOpenId(openid);
            if (BeanUtils.isEmpty((Object)simpleUser) || simpleUser.isNull()) {
                return new CommonResult(false, "\u7cfb\u7edf\u5185\u65e0openid\u5bf9\u5e94\u7684\u7528\u6237", (Object)openid);
            }
            String account = simpleUser.get("account").asText();
            CacheEvictUtil.deleteUserDetailsCache((String)account);
            HttpServletRequest request = HttpUtil.getRequest();
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
            String token = this.jwtTokenHandler.generateToken(userDetails);
            String userName = userDetails.getUsername();
            String userId = "";
            String tenantId = "";
            if (userDetails instanceof IUser) {
                IUser user = (IUser)userDetails;
                userName = user.getFullname();
                userId = user.getUserId();
                tenantId = user.getTenantId();
                request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            }
            this.handleSingleLogin(HttpUtil.isMobile((HttpServletRequest)request), tenantId, account, token);
            return new CommonResult(true, "\u767b\u9646\u6210\u529f", (Object)new JwtAuthenticationResponse(token, userName, account, userId));
        }
        throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u767b\u9646\u5931\u8d25 \uff1a " + (result == null ? "" : JsonUtil.getString((JsonNode)result, (String)"errmsg")));
    }

    @Override
    public ResponseEntity<?> ssoFlyBook(Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        if (!code.isPresent()) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        CommonResult resultFlyBookId = this.portalFeignService.getFlyBookIdByCode(code.get());
        if (resultFlyBookId == null || !resultFlyBookId.getState().booleanValue()) {
            logger.error("\u98de\u4e66\u83b7\u53d6\u767b\u5f55\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01" + resultFlyBookId.getMessage());
            throw new RuntimeException("\u98de\u4e66\u83b7\u53d6\u767b\u5f55\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01");
        }
        String flyBookUserId = (String)resultFlyBookId.getValue();
        JsonNode simpleUser = this.uCFeignService.getUserByFlyBookId(flyBookUserId);
        if (simpleUser == null || simpleUser.isNull() || !simpleUser.has("account")) {
            throw new RuntimeException("\u67e5\u65e0\u4e0e\u60a8\u98de\u4e66\u8d26\u53f7[userid:" + flyBookUserId + "]\u7ed1\u5b9a\u7684eip\u8d26\u53f7");
        }
        String account = simpleUser.get("account").asText();
        try {
            CacheEvictUtil.deleteUserDetailsCache((String)account);
            HttpServletRequest request = HttpUtil.getRequest();
            Objects.requireNonNull(request);
            boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
            String token = this.jwtTokenHandler.generateToken(userDetails);
            String userName = userDetails.getUsername();
            String userId = "";
            String tenantId = "";
            if (userDetails instanceof IUser) {
                IUser user = (IUser)userDetails;
                userName = user.getFullname();
                userId = user.getUserId();
                tenantId = user.getTenantId();
                request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            }
            logger.debug("\u901a\u8fc7\u98de\u4e66\u8ba4\u8bc1\u767b\u5f55\u6210\u529f\u3002");
            this.handleSingleLogin(isMobile, tenantId, account, token);
            return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
        }
        catch (Exception e) {
            throw new RuntimeException("\u98de\u4e66\u8ba4\u8bc1\u767b\u5f55\u5931\u8d25 ,eip\u7528\u6237\u8d26\u53f7:" + account);
        }
    }

    @Override
    public CommonResult<?> scanLogin(Optional<String> code, Optional<String> type, String redirectUri) {
        if (!code.isPresent() || !type.isPresent()) {
            return new CommonResult(false, "\u53c2\u6570\u9519\u8bef\uff01");
        }
        CommonResult result = null;
        if (type.get().equals("dingtalk")) {
            result = this.portalFeignService.getDingtalkIdFromScanCode(code.get());
        } else if (type.get().equals("wechatWork")) {
            result = this.portalFeignService.getWxWorkIdFromScanCode(code.get());
        } else if (type.get().equals("flyBook")) {
            result = this.portalFeignService.getFlyBookIdFromScanCode(code.get(), redirectUri);
        }
        if (result != null && result.getState().booleanValue()) {
            String userid = (String)result.getValue();
            String typeName = "\u9489\u9489";
            JsonNode simpleUser = null;
            if (type.get().equals("dingtalk")) {
                simpleUser = this.uCFeignService.getUserByDingtalkId(userid);
            } else if (type.get().equals("wechatWork")) {
                typeName = "\u4f01\u4e1a\u5fae\u4fe1";
                simpleUser = this.uCFeignService.getUserByWxWorkId(userid);
            } else if (type.get().equals("flyBook")) {
                typeName = "\u98de\u4e66";
                simpleUser = this.uCFeignService.getUserByFlyBookId(userid);
            }
            if (BeanUtils.isEmpty((Object)simpleUser) || simpleUser.isNull()) {
                String msg = "\u626b\u7801\u767b\u5f55\u5931\u8d25\uff0c\u67e5\u65e0\u4e0e\u60a8" + typeName + "\u8d26\u53f7[userid:" + userid + "]\u7ed1\u5b9a\u7684eip\u8d26\u53f7";
                return new CommonResult(false, msg);
            }
            String account = simpleUser.get("account").asText();
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
            if (BeanUtils.isNotEmpty((Object)userDetails)) {
                CacheEvictUtil.deleteUserDetailsCache((String)account);
                HttpServletRequest request = HttpUtil.getRequest();
                boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return new CommonResult(true, "\u626b\u7801\u767b\u5f55\u6210\u529f", (Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            return new CommonResult(false, "\u626b\u7801\u767b\u5f55\u5931\u8d25\uff01eip\u8d26\u53f7:" + account + "\u4e0d\u5b58\u5728");
        }
        return new CommonResult(false, "\u626b\u7801\u767b\u5f55\u5931\u8d25 \uff1a " + (result != null ? result.getMessage() : ""));
    }

    @Override
    public Map<String, Object> getSsoInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enable", this.ssoConfig.isEnable());
        map.put("ssoUrl", this.ssoConfig.getSsoUrl());
        map.put("ssoLogoutUrl", this.ssoConfig.getSsoLogoutUrl());
        return map;
    }

    @Override
    public ResponseEntity<?> refreshAndGetAuthenticationToken(HttpServletRequest request) {
        ArrayNode users;
        String authToken = request.getHeader(this.jwtConfig.getHeader());
        String token = authToken.substring(7);
        String tenantId = this.jwtTokenHandler.getTenantIdFromToken(token);
        String account = this.jwtTokenHandler.getUsernameFromToken(token);
        String refreshedToken = this.jwtTokenHandler.refreshToken(token);
        boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
        this.handleSingleLogin(isMobile, tenantId, account, refreshedToken);
        long expiration = this.jwtConfig.getExpirationLong();
        String userId = "";
        if (StringUtil.isNotEmpty((String)account) && (users = this.ucFeignService.getUserByAccounts(account)) != null && users.size() > 0) {
            userId = JsonUtil.getString((JsonNode)users.get(0), (String)"id", (String)"");
        }
        return ResponseEntity.ok((Object)new JwtAuthenticationResponse(refreshedToken, account, account, userId, Long.valueOf(expiration), null));
    }

    @Override
    public void signOut(HttpServletRequest request) {
        String authToken = request.getHeader(this.jwtConfig.getHeader());
        String token = authToken.substring(7);
        String tenantId = this.jwtTokenHandler.getTenantIdFromToken(token);
        String account = this.jwtTokenHandler.getUsernameFromToken(token);
        boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
        this.handleLogout(isMobile, tenantId, account);
    }

    private String getUserNameWithCas(String ticket, String service) throws IOException {
        String casUserDetail = "";
        String username = null;
        String errorCode = "";
        try {
            casUserDetail = FluentUtil.get((String)String.format("%s/p3/serviceValidate?ticket=%s&service=%s", this.ssoConfig.getCasUrl(), ticket, URLEncoder.encode(service, "UTF-8")), (String)"");
            String json = XmlUtil.toJson((String)casUserDetail);
            JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
            if (jsonNode.has("authenticationSuccess")) {
                username = jsonNode.get("authenticationSuccess").get("user").asText();
            } else if (jsonNode.has("authenticationFailure")) {
                errorCode = jsonNode.get("authenticationFailure").get("code").asText();
                throw new RuntimeException(errorCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u83b7\u53d6cas\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a" + casUserDetail);
            throw new RuntimeException("\u83b7\u53d6cas\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a " + e.getMessage());
        }
        return username;
    }

    private String getUserNameWithOauth(String code, String service) throws UnsupportedEncodingException {
        String userName = null;
        String oauthTokenUrl = this.ssoConfig.getOauthTokenUrl();
        String stufix = String.format("&code=%s&redirect_uri=%s", code, URLEncoder.encode(service, "UTF-8"));
        try {
            String header = this.ssoConfig.getOauthBasicHeader();
            logger.debug("[get token]request Url: " + oauthTokenUrl + stufix);
            String tokenResult = FluentUtil.post((String)(oauthTokenUrl + stufix), (String)header, null, (ContentType)ContentType.APPLICATION_FORM_URLENCODED);
            logger.debug("[get token]tokenResult: " + tokenResult);
            JsonNode jsonNode = JsonUtil.toJsonNode((String)tokenResult);
            if (jsonNode != null && jsonNode.isObject()) {
                String token = jsonNode.get(this.ssoConfig.getOauthAccesstokenKey()).asText();
                String oauthCheckUrl = this.ssoConfig.getOauthCheckUrl();
                String checkResult = "";
                logger.debug("[check and get user info]request url: " + oauthCheckUrl + token);
                checkResult = "GET".equalsIgnoreCase(this.ssoConfig.getCheckRequestType()) ? FluentUtil.get((String)(oauthCheckUrl + token), (String)header) : FluentUtil.post((String)(oauthCheckUrl + token), null, null, (ContentType)ContentType.APPLICATION_FORM_URLENCODED);
                logger.debug("[check and get user info]result: " + checkResult);
                JsonNode checkJNode = JsonUtil.toJsonNode((String)checkResult);
                if (checkJNode != null && checkJNode.isObject()) {
                    userName = checkJNode.get(this.ssoConfig.getOauthUsernameKey()).asText();
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6oauth\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6oauth\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25", e);
        }
        return userName;
    }

    private void authenticate(String username, String password) throws AuthenticationException, CertificateException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    private boolean checkUser(IUser user, String password) {
        JsonNode json = this.ucFeignService.getPwdStrategyDefault();
        if (BeanUtils.isNotEmpty((Object)json)) {
            String initPwd = json.get("initPwd").asText();
            int pwdRule = json.get("pwdRule").asInt();
            int pwdLength = json.get("pwdLength").asInt();
            int duration = json.get("duration").asInt();
            int enable = json.get("enable").asInt();
            int forceInvalid = json.get("forceInvalid").asInt();
            Objects.requireNonNull(password);
            if (enable == 1) {
                LocalDateTime pwdCreateTime;
                String regex;
                boolean result;
                if (password.length() < pwdLength) {
                    return false;
                }
                if (pwdRule != 1 && (pwdRule == 2 ? !(result = password.matches(regex = "^(?![a-zA-z]+$)(?!\\d+$)(?![!@#$%^&*]+$)[a-zA-Z\\d!@#$%^&*]+$")) : (pwdRule == 3 ? !(result = password.matches(regex = "^(?=.*?[A-Za-z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$")) : pwdRule == 4 && !(result = password.matches(regex = "^(?=.*?[a-z])(?=.*?[A-Z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$"))))) {
                    return false;
                }
                if (forceInvalid == 1 && BeanUtils.isNotEmpty((Object)(pwdCreateTime = user.getPwdCreateTime()))) {
                    return LocalDateTime.now().isBefore(pwdCreateTime.plusDays(duration));
                }
            }
        }
        return true;
    }

    private void handleSingleLogin(boolean isMobile, String tenantId, String username, String token) {
        if (this.jwtConfig.isSingle()) {
            String userAgent;
            String string = userAgent = isMobile ? "mobile" : "pc";
            if (StringUtil.isEmpty((String)tenantId) && !this.saasConfig.isEnable()) {
                tenantId = "-1";
            }
            this.jwtTokenHandler.putTokenInCache(userAgent, tenantId, username, this.jwtConfig.getExpiration(), token);
        }
        this.ucFeignService.loginLog(username, isMobile ? "mobile" : "pc");
    }

    private void handleLogout(boolean isMobile, String tenantId, String account) {
        if (this.jwtConfig.isSingle()) {
            String userAgent;
            String string = userAgent = isMobile ? "mobile" : "pc";
            if (StringUtil.isEmpty((String)tenantId) && !this.saasConfig.isEnable()) {
                tenantId = "-1";
            }
            this.jwtTokenHandler.removeFromCache(userAgent, tenantId, account);
        }
    }

    private CommonResult checkTwoStepVerify(boolean isMobile, String userSecret, JwtAuthenticationResponse jwtAuthenticationResponse) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String key;
        if (jwtAuthenticationResponse.getAccount().equals("admin")) {
            return null;
        }
        boolean openForceVerify = this.twoVerifyService.getTwoVerifyConfig().getForceTwoVerify();
        String string = key = isMobile ? "mobile" : "pc_" + MapUtil.getString((Map)jwtAuthenticationResponse.getUserAttrs(), (String)"tenantId") + "_" + jwtAuthenticationResponse.getAccount();
        if (StringUtil.isNotEmpty((String)userSecret) && !isMobile) {
            key = key + "_" + userSecret;
            this.twoVerifyService.putTempTokenInCache(key, jwtAuthenticationResponse);
            this.twoVerifyService.putTwoVerifyErrorCountInCache(key, 0);
            key = RSAUtil.publicEncrypt((String)key, (RSAPublicKey)RSAUtil.getPublicKey((String)RSAUtil.publicKey));
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.NEED_TWO_VERIFY).value((Object)key);
        }
        if (openForceVerify && !isMobile) {
            TwoVerifyInfoVo twoVerifyInfoVo = this.twoVerifyService.initTwoVerifyInfo(jwtAuthenticationResponse.getAccount(), null);
            key = key + "_" + twoVerifyInfoVo.getSecret();
            this.twoVerifyService.putTempTokenInCache(key, jwtAuthenticationResponse);
            key = RSAUtil.publicEncrypt((String)key, (RSAPublicKey)RSAUtil.getPublicKey((String)RSAUtil.publicKey));
            twoVerifyInfoVo.setTempToken(key);
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.NEED_TWO_VERIFY_BIND).value((Object)twoVerifyInfoVo);
        }
        return null;
    }

    private void checkLoginFailed(String reqAccount) {
        JsonNode json = this.ucFeignService.getPwdStrategyDefault();
        CommonResult loginFailedResult = this.ucFeignService.getLoginFailedByAccount(reqAccount);
        LoginFailedVo loginFailedVo = (LoginFailedVo)loginFailedResult.getValue();
        if (BeanUtils.isNotEmpty((Object)json) && BeanUtils.isNotEmpty((Object)loginFailedVo)) {
            int enable = json.get("enable").asInt();
            int errAutoLock = json.get("errAutoLock").asInt();
            if (enable == 1 && errAutoLock == 1) {
                int errAutoUnlock = json.get("errAutoUnlock").asInt();
                int errTimes = json.get("errTimes").asInt();
                int errUnlockMinutes = json.get("errUnlockMinutes").asInt();
                if (loginFailedVo.getLoginFailedTimes() >= errTimes) {
                    if (errAutoUnlock == 1 && loginFailedVo.isUnlock(errUnlockMinutes)) {
                        this.ucFeignService.removeLoginFailedByAccount(reqAccount);
                    } else {
                        throw new RuntimeException("\u7528\u6237\u5e10\u53f7\u5df2\u9501\u5b9a");
                    }
                }
            }
        }
    }

    private String recordLoginFailed(String reqAccount, String errorMsg) {
        JsonNode json = this.ucFeignService.getPwdStrategyDefault();
        if (BeanUtils.isNotEmpty((Object)json)) {
            int enable = json.get("enable").asInt();
            int errAutoLock = json.get("errAutoLock").asInt();
            if (enable == 1 && errAutoLock == 1) {
                int errTimes = json.get("errTimes").asInt();
                CommonResult loginFailedResult = this.ucFeignService.getLoginFailedByAccount(reqAccount);
                if (loginFailedResult.getState().booleanValue()) {
                    LoginFailedVo loginFailedVo = (LoginFailedVo)loginFailedResult.getValue();
                    loginFailedVo = Optional.ofNullable(loginFailedVo).orElse(new LoginFailedVo());
                    loginFailedVo.setAccount(reqAccount);
                    if (errTimes == 1) {
                        loginFailedVo.setLoginFailedTimes(Integer.valueOf(1));
                        loginFailedVo.setLockTime(LocalDateTime.now());
                        this.ucFeignService.saveLoginFailed(loginFailedVo);
                    } else {
                        loginFailedVo.setLoginFailedTimes(Integer.valueOf(loginFailedVo.getLoginFailedTimes() + 1));
                    }
                    int times = errTimes - loginFailedVo.getLoginFailedTimes();
                    errorMsg = times == 0 ? "\u7528\u6237\u5e10\u53f7\u5df2\u9501\u5b9a" : "\u767b\u5f55\u5931\u8d25\uff0c\u8fd8\u6709" + times + "\u6b21\u673a\u4f1a";
                    loginFailedVo.setLockTime(LocalDateTime.now());
                    this.ucFeignService.saveLoginFailed(loginFailedVo);
                }
            }
        }
        return errorMsg;
    }
}

