/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.aop;

import com.hotent.base.service.RedisLock;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AvoidRepeatableCommitAspect {
    private Logger logger = LoggerFactory.getLogger(AvoidRepeatableCommitAspect.class);
    @Autowired
    RedisLock redisLock;

    @Around(value="@annotation(com.hotent.base.annotation.AvoidRepeatableCommit)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletRequest request = HttpUtil.getRequest();
        String uri = request.getRequestURI();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] args = joinPoint.getArgs();
        StringBuffer sb = new StringBuffer();
        if (BeanUtils.isNotEmpty(args)) {
            for (Object object : args) {
                if (object instanceof ServletRequest || object instanceof ServletResponse) continue;
                try {
                    String json = JsonUtil.toJson(object);
                    sb.append(json);
                }
                catch (Exception e) {
                    sb.append(object.toString());
                }
            }
        }
        String queryStr = sb.toString();
        String className = method.getDeclaringClass().getName();
        String name = method.getName();
        String uriKey = String.format("%s#%s#%s#%s#%s", uri, className, name, queryStr, AuthenticationUtil.getCurrentUserId());
        int hashCode = Math.abs(uriKey.hashCode());
        String key = String.format("%s_%d", uri, hashCode);
        this.logger.info("uriKey={},hashCode={},key={}", new Object[]{uriKey, hashCode, key});
        this.logger.info("\u9632\u6b62\u91cd\u590d\u63d0\u4ea4");
        return this.redisLock.commitRedisLock(key, joinPoint);
    }
}

