/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.cache.impl;

import com.hotent.base.cache.ICache;
import com.hotent.base.cache.impl.AbstractCacheManager;
import com.hotent.base.cache.impl.CaffeineCache;
import com.hotent.base.cache.setting.CacheSetting;
import com.hotent.base.util.StringUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"redisCacheManager"})
public class DefaultCacheManager
extends AbstractCacheManager {
    @Override
    protected ICache getMissingCache(String name, CacheSetting cacheSetting) {
        CaffeineCache caffeineCache = new CaffeineCache(name, cacheSetting.getFirstCacheSetting());
        return caffeineCache;
    }

    @Override
    public void clearCascadeByKey(String key) {
        Assert.notNull((Object)key, (String)"\u6839\u636ekey\u6e05\u9664\u7f13\u5b58\u65f6\uff0ckey\u4e0d\u80fd\u4e3a\u7a7a");
        this.cacheContainer.forEach((k, map) -> {
            if (StringUtil.isNotEmpty(k) && (k.equals(key) || k.startsWith(key + ":"))) {
                map.forEach((i, cache) -> cache.clear());
            }
        });
    }
}

