/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.conf;

import com.hotent.base.annotation.IgnoreOnAssembly;
import com.hotent.base.context.BaseContext;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.WebUtil;
import feign.Contract;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;

@Configuration
@IgnoreOnAssembly
public class FeignConfig {
    @Value(value="${feign.encry.key:feignCallEncry}")
    private String encryKey;
    @Value(value="${feign.fallback.default.exception:true}")
    private boolean fallbackException = true;

    public boolean isFallbackException() {
        return this.fallbackException;
    }

    @Bean
    public Contract feignContract() {
        return new SpringMvcContract();
    }

    @Bean
    public RequestInterceptor requestTokenBearerInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate requestTemplate) {
                String token = "";
                JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
                String proxyToken = "Bearer " + jwtTokenHandler.generateFeignToken();
                requestTemplate.header("Proxy-Authorization", new String[]{proxyToken});
                try {
                    HttpServletRequest request = HttpUtil.getRequest();
                    if (request != null) {
                        token = request.getHeader("Authorization");
                    }
                }
                catch (Exception request) {
                    // empty catch block
                }
                if (StringUtil.isNotEmpty(token)) {
                    requestTemplate.header("Authorization", new String[]{token});
                } else {
                    requestTemplate.header("Authorization", new String[]{proxyToken});
                }
                if (BeanUtils.isNotEmpty(LocaleContextHolder.getLocale())) {
                    requestTemplate.header("Accept-Language", new String[]{LocaleContextHolder.getLocale().toLanguageTag()});
                }
                if (HttpUtil.getRequest() != null) {
                    requestTemplate.header("origin-ip", new String[]{WebUtil.getIpAddr(HttpUtil.getRequest())});
                }
                BaseContext context = AppUtil.getBean(BaseContext.class);
                String currentTenantId = context.getCurrentTenantId();
                if (context.hasTempTenant()) {
                    String tempToken = jwtTokenHandler.generateToken();
                    requestTemplate.removeHeader("Authorization");
                    requestTemplate.header("Authorization", new String[]{"Bearer " + tempToken});
                }
                String url = requestTemplate.url();
                if (StringUtil.isNotEmpty(currentTenantId)) {
                    if (url.indexOf("?") == -1) {
                        url = url + String.format("?%s=%s", "tenantId", currentTenantId);
                    } else if (url.indexOf("tenantId=") < 0) {
                        url = url + String.format("&%s=%s", "tenantId", currentTenantId);
                    }
                }
                requestTemplate.uri(url);
            }
        };
    }
}

