/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.conf;

import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.constants.TenantConstant;
import com.hotent.base.filter.ClobDataResultSetFilter;
import com.hotent.base.filter.FormDataResultSetFilter;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.id.MybatisPlusIdGenerator;
import com.hotent.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.hotent.base.interceptor.ResultSetInterceptor;
import com.hotent.base.query.PageBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfig {
    @Autowired
    MultiTenantHandler myTenantHandler;
    @Autowired
    SaaSConfig saaSConfig;

    @Bean
    public Interceptor getResultSetInterceptor() {
        ResultSetInterceptor resultSetInterceptor = new ResultSetInterceptor();
        FormDataResultSetFilter formDataResultSetFilter = new FormDataResultSetFilter();
        ClobDataResultSetFilter clobDataResultSetFilter = new ClobDataResultSetFilter();
        resultSetInterceptor.addFilters(formDataResultSetFilter);
        resultSetInterceptor.addFilters(clobDataResultSetFilter);
        return resultSetInterceptor;
    }

    @Bean
    public IdentifierGenerator identifierGenerator() {
        return new MybatisPlusIdGenerator();
    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLimit((long)PageBean.WITHOUT_PAGE.intValue());
        ArrayList<TenantSqlParser> sqlParserList = new ArrayList<TenantSqlParser>();
        if (this.saaSConfig.isEnable()) {
            this.myTenantHandler.setTenantId(this.saaSConfig.getTenantId());
            List<String> ignoreTables = this.saaSConfig.getIgnoreTables();
            ignoreTables.addAll(TenantConstant.IGNORE_TABLES);
            this.myTenantHandler.setIgnoreTableNames(ignoreTables);
            TenantSqlParser tenantSqlParser = new TenantSqlParser();
            tenantSqlParser.setTenantHandler((TenantHandler)this.myTenantHandler);
            sqlParserList.add(tenantSqlParser);
        }
        paginationInterceptor.setSqlParserList(sqlParserList);
        return paginationInterceptor;
    }

    @Bean
    public MasterSlaveAutoRoutingPlugin masterSlaveAutoRoutingPlugin() {
        return new MasterSlaveAutoRoutingPlugin();
    }

    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.put("Oracle", "oracle");
        properties.put("MySQL", "mysql");
        properties.put("H2", "h2");
        properties.put("SQLServer", "sqlserver");
        properties.put("PostgreSQL", "pg");
        properties.put("DM DBMS", "oracle");
        properties.put("KingbaseES", "oracle");
        properties.put("GBase 8s Server", "gbasedbt");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }
}

