/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.conf;

import com.google.common.collect.Lists;
import com.hotent.base.annotation.ApiGroup;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.WebFluxRequestHandlerProvider;
import springfox.documentation.spring.web.plugins.WebMvcRequestHandlerProvider;

public abstract class SwaggerConfigHelper {
    @Value(value="${spring.profiles.title}")
    private String title;
    @Value(value="${spring.profiles.description}")
    private String description;
    @Value(value="${spring.profiles.version}")
    private String version;

    public Docket buildProductApi(String apiGroupName, String apiGroupKey) {
        Docket docket = this.buildDocket(apiGroupName).apiInfo(this.buildBaseProductApiInfo());
        ApiSelectorBuilder builder = this.buildApiForGroupKey(docket, apiGroupKey);
        return this.buildApiSecurityAuth(builder);
    }

    public Docket buildDocket(String apiGroupName) {
        return new Docket(DocumentationType.SWAGGER_2).groupName(apiGroupName).useDefaultResponseMessages(false).forCodeGeneration(false);
    }

    public ApiSelectorBuilder buildApiForGroupKey(Docket docket, String apiGroupKey) {
        return docket.select().apis(this.getPredicateWithGroup(apiGroupKey)).paths(PathSelectors.any());
    }

    public ApiSelectorBuilder buildApiForPackage(Docket docket, String basePackage) {
        return docket.select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any());
    }

    public Docket buildApiSecurityAuth(ApiSelectorBuilder builder) {
        return builder.build().securityContexts((List)Lists.newArrayList((Object[])new SecurityContext[]{this.buildSecurityContext()})).securitySchemes((List)Lists.newArrayList((Object[])new SecurityScheme[]{this.apiSecurityKey()}));
    }

    private ApiKey apiSecurityKey() {
        return new ApiKey("BearerToken", "Authorization", "header");
    }

    private SecurityContext buildSecurityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).operationSelector(operationContext -> operationContext.requestMappingPattern().matches("/.*")).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference("BearerToken", authorizationScopes)});
    }

    protected Predicate<RequestHandler> getPredicateWithGroup(final String group) {
        return new Predicate<RequestHandler>(){

            @Override
            public boolean test(RequestHandler t) {
                Optional ApiGroup2 = t.findControllerAnnotation(ApiGroup.class);
                return ApiGroup2.isPresent() && Arrays.asList(((ApiGroup)ApiGroup2.get()).group()).contains(group);
            }
        };
    }

    protected ApiInfo buildBaseProductApiInfo() {
        Contact contact = new Contact("heyifan", "www.hotent.com", "heyf@jee-soft.cn");
        return this.buildApiInfo(this.title, this.description, this.version, "http://127.0.0.1:8080", contact);
    }

    protected ApiInfo buildApiInfo(String title, String description, String version, String url, Contact contact) {
        ApiInfo apiInfo = new ApiInfo(title, description, version, url, contact, "license", "license url", new ArrayList());
        return apiInfo;
    }

    @Bean
    public WebMvcEndpointHandlerMapping webEndpointServletHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment) {
        ArrayList allEndpoints = new ArrayList();
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(servletEndpointsSupplier.getEndpoints());
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        String basePath = webEndpointProperties.getBasePath();
        EndpointMapping endpointMapping = new EndpointMapping(basePath);
        boolean shouldRegisterLinksMapping = this.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath);
        return new WebMvcEndpointHandlerMapping(endpointMapping, webEndpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), new EndpointLinksResolver(allEndpoints, basePath), shouldRegisterLinksMapping, null);
    }

    private boolean shouldRegisterLinksMapping(WebEndpointProperties webEndpointProperties, Environment environment, String basePath) {
        return webEndpointProperties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment).equals((Object)ManagementPortType.DIFFERENT));
    }

    @Bean
    public static BeanPostProcessor springfoxHandlerProviderBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof WebMvcRequestHandlerProvider || bean instanceof WebFluxRequestHandlerProvider) {
                    List<RequestMappingInfoHandlerMapping> handlerMappings = this.getHandlerMappings(bean);
                    this.customizeSpringfoxHandlerMappings(handlerMappings);
                }
                return bean;
            }

            private <T extends RequestMappingInfoHandlerMapping> void customizeSpringfoxHandlerMappings(List<T> mappings) {
                List copy = mappings.stream().filter(mapping -> mapping.getPatternParser() == null).collect(Collectors.toList());
                mappings.clear();
                mappings.addAll(copy);
            }

            private List<RequestMappingInfoHandlerMapping> getHandlerMappings(Object bean) {
                try {
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"handlerMappings");
                    field.setAccessible(true);
                    return (List)field.get(bean);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }
}

