/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.conf;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.util.Base64;
import com.hotent.base.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="system")
public class SystemYmlConfig {
    private Logger logger = LoggerFactory.getLogger(SystemYmlConfig.class);
    private Map<String, String> basic = new HashMap<String, String>();

    public Map<String, String> getBasic() {
        return this.basic;
    }

    public void setBasic(Map<String, String> basic) {
        this.basic = basic;
    }

    public String getToken() {
        if (this.basic.containsKey("token")) {
            return this.basic.get("token");
        }
        return "eyJBdXRob3JpemF0aW9uIjoiQmFzaWMgWVdSdGFXNDZNVEl6TkRVMiJ9";
    }

    public String getBasicToken() {
        String token = this.getToken();
        try {
            String fromBase64 = Base64.getFromBase64(token);
            JsonNode jsonNode = JsonUtil.toJsonNode(fromBase64);
            return jsonNode.get("Authorization").asText();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8bbe\u7f6e\u7684basic token \u6709\u95ee\u9898");
            return "";
        }
    }

    private String getBasicTokenUsernameAndPassord() {
        String result = "admin:123456";
        try {
            String basic = this.getBasicToken();
            if (basic.startsWith("Basic ")) {
                basic = basic.substring(6);
                result = Base64.getFromBase64(basic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getUsername() {
        return this.getBasicTokenUsernameAndPassord().split(":")[0];
    }

    public String getPassword() {
        return this.getBasicTokenUsernameAndPassord().split(":")[1];
    }
}

