/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.datasource.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.datasource.DatabaseSwitchResult;
import com.hotent.base.exception.DataBaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.ExtendClassLoader;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TransactionThreadLocal;
import io.seata.rm.datasource.ConnectionProxy;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

@Service
public class DefaultDatabaseContext
implements DatabaseContext,
ContextThread {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultDatabaseContext.class);
    @Resource
    DynamicRoutingDataSource dynamicRoutingDataSource;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Autowired
    TransactionThreadLocal transactionThreadLocal;
    private static final Map<Object, DbType> map = new ConcurrentHashMap<Object, DbType>();
    private static final ThreadLocal<DataSource> currentDatasource = new ThreadLocal();

    public void clear() {
        currentDatasource.remove();
    }

    public static boolean isLocalDataSource(String alias) {
        return "master".equalsIgnoreCase(alias) || "slave".equalsIgnoreCase(alias) || "LOCAL".equalsIgnoreCase(alias);
    }

    @Override
    @Deprecated
    public DatabaseSwitchResult setDataSource(String alias) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(alias), (String)"\u8981\u5207\u6362\u7684\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        String dbType = this.getDbTypeByAlias(alias);
        if (DefaultDatabaseContext.isLocalDataSource(alias)) {
            return new DatabaseSwitchResult("LOCAL", "LOCAL", dbType);
        }
        MasterSlaveAutoRoutingPlugin.setInExternalDatasource();
        MultiTenantHandler.setThreadLocalIgnore();
        DataSource datasource = this.getDataSourceByAlias(alias);
        String currentDsAlias = DynamicDataSourceContextHolder.peek();
        DynamicDataSourceContextHolder.push((String)alias);
        currentDatasource.set(datasource);
        if (!DefaultDatabaseContext.isLocalDataSource(alias)) {
            MasterSlaveAutoRoutingPlugin.setInExternalDatasource();
            MultiTenantHandler.setThreadLocalIgnore();
        }
        return new DatabaseSwitchResult(currentDsAlias, alias, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSourceByAlias(String alias) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(alias), (String)"\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        if (DefaultDatabaseContext.isLocalDataSource(alias)) {
            return this.dynamicRoutingDataSource.determineDataSource();
        }
        this.dynamicRoutingDataSource.setStrict(true);
        DataSource dataSource = null;
        try {
            dataSource = this.dynamicRoutingDataSource.getDataSource(alias);
        }
        catch (RuntimeException portalFeignService) {
            if (BeanUtils.isEmpty(dataSource)) {
                PortalFeignService portalFeignService2 = AppUtil.getBean(PortalFeignService.class);
                JsonNode sysDataSourceJNode = portalFeignService2.getBeanByAlias(alias);
                Assert.isTrue((boolean)BeanUtils.isNotEmpty(sysDataSourceJNode), (String)String.format("\u522b\u540d\u4e3a\uff1a%s\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", alias));
                dataSource = this.getDsFromSysSource(sysDataSourceJNode);
                this.dynamicRoutingDataSource.addDataSource(alias, dataSource);
            }
        }
        catch (Throwable throwable) {
            if (BeanUtils.isEmpty(dataSource)) {
                PortalFeignService portalFeignService = AppUtil.getBean(PortalFeignService.class);
                JsonNode sysDataSourceJNode = portalFeignService.getBeanByAlias(alias);
                Assert.isTrue((boolean)BeanUtils.isNotEmpty(sysDataSourceJNode), (String)String.format("\u522b\u540d\u4e3a\uff1a%s\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", alias));
                dataSource = this.getDsFromSysSource(sysDataSourceJNode);
                this.dynamicRoutingDataSource.addDataSource(alias, dataSource);
            }
            throw throwable;
        }
        if (BeanUtils.isEmpty(dataSource)) {
            PortalFeignService portalFeignService = AppUtil.getBean(PortalFeignService.class);
            JsonNode sysDataSourceJNode = portalFeignService.getBeanByAlias(alias);
            Assert.isTrue((boolean)BeanUtils.isNotEmpty(sysDataSourceJNode), (String)String.format("\u522b\u540d\u4e3a\uff1a%s\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", alias));
            dataSource = this.getDsFromSysSource(sysDataSourceJNode);
            this.dynamicRoutingDataSource.addDataSource(alias, dataSource);
        }
        if (BeanUtils.isEmpty(dataSource)) {
            dataSource = this.dynamicRoutingDataSource.determineDataSource();
        }
        return dataSource;
    }

    @Override
    public DataSource getDsFromSysSource(JsonNode sysDataSource) {
        try {
            String initMethodStr;
            Assert.isTrue((boolean)BeanUtils.isNotEmpty(sysDataSource), (String)"\u6570\u636e\u6e90\u5bf9\u8c61\u4e3a\u7a7a");
            Class<?> _class = null;
            _class = Class.forName(sysDataSource.get("classPath").asText());
            DataSource sqldataSource = null;
            sqldataSource = (DataSource)_class.newInstance();
            String settingJson = sysDataSource.get("settingJson").asText();
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(settingJson);
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode jo = (ObjectNode)arrayNode.get(i);
                Object value = BeanUtils.convertByActType(JsonUtil.getString((JsonNode)jo, "type"), JsonUtil.getString((JsonNode)jo, "value"));
                BeanUtils.setProperty(sqldataSource, JsonUtil.getString((JsonNode)jo, "name"), value);
            }
            if (sqldataSource instanceof DruidDataSource) {
                ((DruidDataSource)sqldataSource).setBreakAfterAcquireFailure(true);
            }
            if (!StringUtil.isEmpty(initMethodStr = sysDataSource.get("initMethod").asText())) {
                Method method = _class.getMethod(initMethodStr, new Class[0]);
                method.invoke((Object)sqldataSource, new Object[0]);
            }
            return sqldataSource;
        }
        catch (Exception e) {
            String name = JsonUtil.getString(sysDataSource, "name");
            String alias = JsonUtil.getString(sysDataSource, "alias");
            logger.warn(String.format("\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e\u6e90\uff1a%s(%s) \u65f6\u51fa\u9519", name, alias), (Throwable)e);
            return null;
        }
    }

    @Override
    public DataSource getDataSource() {
        DataSource dataSource = currentDatasource.get();
        if (dataSource == null) {
            return this.dynamicRoutingDataSource.determineDataSource();
        }
        return dataSource;
    }

    @Override
    public String getDbType() {
        return this.getDbTypeObj().getDb();
    }

    @Override
    public DbType getDbTypeObj() {
        DataSource dataSource = this.getDataSource();
        return this.getDbTypeObj(dataSource);
    }

    @Override
    public String getDbTypeByAlias(String alias) {
        DataSource dataSourceByAlias = this.getDataSourceByAlias(alias);
        return this.getDbTypeObj(dataSourceByAlias).getDb();
    }

    public DbType getDbTypeObj(DataSource dataSource) {
        DbType type = map.get(dataSource);
        if (BeanUtils.isEmpty(type)) {
            Connection con = null;
            try {
                con = DataSourceUtils.getConnection((DataSource)dataSource);
                type = JdbcUtils.getDbType((String)con.getMetaData().getURL());
                map.put(dataSource, type);
            }
            catch (Exception e) {
                throw new DataBaseException("\u83b7\u53d6\u5f53\u524d\u6570\u636e\u6e90\u5f02\u5e38");
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
        return type;
    }

    @Override
    public void cleanAll() {
        this.clear();
    }

    @Override
    public void destroyDataSourceByAlias(String alias, DataSource dataSource) {
        this.dynamicRoutingDataSource.removeDataSource(alias);
        if (dataSource instanceof DruidDataSource) {
            ((DruidDataSource)dataSource).close();
        }
    }

    @Override
    public <T> T switchDS(String dsName, Supplier<T> supplier) throws Exception {
        T result;
        try (DatabaseSwitchResult databaseSwitchResult = this.setDataSource(dsName);){
            result = this.startNewConnection(supplier);
        }
        return result;
    }

    @Override
    public <T> T switchDS(String dsName, Supplier<T> supplier, Consumer<Exception> consumer) {
        T result = null;
        try (DatabaseSwitchResult databaseSwitchResult = this.setDataSource(dsName);){
            result = this.startNewConnection(supplier);
        }
        catch (Exception e) {
            consumer.accept(e);
        }
        return result;
    }

    @Override
    public <T> T switchDS(String dsName, Function<DatabaseSwitchResult, T> function) throws Exception {
        Object result = null;
        try (DatabaseSwitchResult databaseSwitchResult = this.setDataSource(dsName);){
            result = this.startNewConnection(() -> function.apply(databaseSwitchResult));
        }
        return (T)result;
    }

    @Override
    public <T> T switchDS(String dsName, Function<DatabaseSwitchResult, T> function, Consumer<Exception> consumer) {
        Object result = null;
        try (DatabaseSwitchResult databaseSwitchResult = this.setDataSource(dsName);){
            result = this.startNewConnection(() -> function.apply(databaseSwitchResult));
        }
        catch (Exception e) {
            consumer.accept(e);
        }
        return (T)result;
    }

    @Override
    public void remove(String dsName) {
        this.dynamicRoutingDataSource.removeDataSource(dsName);
    }

    private <T> T startNewConnection(Supplier<T> supplier) throws Exception, SQLException {
        if (MasterSlaveAutoRoutingPlugin.getInExternalDatasource()) {
            Connection newCon = null;
            DataSource dataSource = this.getDataSource();
            newCon = DataSourceUtils.getConnection((DataSource)dataSource);
            if (ExtendClassLoader.isPresent("io.seata.rm.datasource.ConnectionProxy") && newCon instanceof ConnectionProxy) {
                ConnectionProxy connectionProxy = (ConnectionProxy)newCon;
                newCon = connectionProxy.getTargetConnection();
            }
            boolean synchronizationActive = TransactionSynchronizationManager.isSynchronizationActive();
            try {
                T result;
                if (newCon.getAutoCommit()) {
                    newCon.setAutoCommit(false);
                }
                this.transactionThreadLocal.setCurrentConnections(newCon);
                HashMap<Connection, DataSource> map = new HashMap<Connection, DataSource>();
                map.put(newCon, dataSource);
                this.transactionThreadLocal.addConnectionAndDS(map);
                T t = result = supplier.get();
                return t;
            }
            catch (Exception e) {
                if (!synchronizationActive) {
                    this.transactionThreadLocal.rollback();
                }
                throw e;
            }
            finally {
                if (!synchronizationActive) {
                    this.transactionThreadLocal.commit();
                    this.transactionThreadLocal.close();
                }
                this.transactionThreadLocal.cleanCurrentConnection();
            }
        }
        return supplier.get();
    }
}

