/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.exception;

import com.hotent.base.enums.ResponseErrorEnums;
import dm.jdbc.util.StringUtil;
import org.apache.commons.lang.exception.ExceptionUtils;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected String code;
    protected String message;
    protected ResponseErrorEnums enums;

    public BaseException() {
    }

    public BaseException(Throwable cause) {
        super(cause);
        this.message = ExceptionUtils.getRootCauseMessage((Throwable)cause);
    }

    public BaseException(String message) {
        super(message);
        this.message = message;
    }

    public BaseException(String message, Throwable cause) {
        super(message, cause);
        String finalMessage;
        String rootMessage = ExceptionUtils.getRootCauseMessage((Throwable)cause);
        this.message = finalMessage = StringUtil.isNotEmpty((String)rootMessage) ? rootMessage : message;
    }

    public BaseException(ResponseErrorEnums enums) {
        this.code = enums.getCode();
        this.message = enums.getMessage();
        this.enums = enums;
    }

    public BaseException(ResponseErrorEnums enums, String message) {
        this.code = enums.getCode();
        this.message = message;
        this.enums = enums;
    }

    public BaseException(ResponseErrorEnums enums, Throwable throwable) {
        super(throwable);
        this.code = enums.getCode();
        this.message = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
    }

    public BaseException(ResponseErrorEnums enums, String message, Throwable throwable) {
        super(throwable);
        this.code = enums.getCode();
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ResponseErrorEnums getResponseErrorEnums() {
        return this.enums;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }
}

