/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.feign.error;

import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FeignErrorDecoder
extends ErrorDecoder.Default {
    private static final Logger log = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        Exception exception;
        block6: {
            exception = super.decode(methodKey, response);
            if (exception instanceof RetryableException) {
                return exception;
            }
            try {
                String bodyText;
                if (!(exception instanceof FeignException) || !((FeignException)exception).responseBody().isPresent()) break block6;
                ByteBuffer responseBody = (ByteBuffer)((FeignException)exception).responseBody().get();
                String errorMsg = bodyText = StandardCharsets.UTF_8.newDecoder().decode(responseBody.asReadOnlyBuffer()).toString();
                if (StringUtil.isNotEmpty(bodyText) && bodyText.startsWith("{") && bodyText.contains("message") && (bodyText.contains("state") || bodyText.contains("errorCode"))) {
                    try {
                        CommonResult bean = JsonUtil.toBean(bodyText, CommonResult.class);
                        errorMsg = bean.getMessage();
                    }
                    catch (Exception e) {
                        log.warn("\u83b7\u53d6\u9519\u8bef\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
                BaseException baseException = new BaseException(errorMsg, (Throwable)exception);
                baseException.setMessage(errorMsg);
                return baseException;
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        Throwable rootCauseOrSelf = ExceptionUtil.getRootCauseOrSelf(exception);
        return new BaseException(rootCauseOrSelf.getMessage(), rootCauseOrSelf);
    }
}

